# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndUserMyRequestsArgs', 'EndUserMyRequests']

@pulumi.input_type
class EndUserMyRequestsArgs:
    def __init__(__self__, *,
                 entry_id: pulumi.Input[_builtins.str],
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]] = None):
        """
        The set of arguments for constructing a EndUserMyRequests resource.
        :param pulumi.Input[_builtins.str] entry_id: The ID of the catalog entry for which the request is being made.
        :param pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]] requester_field_values: The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        """
        pulumi.set(__self__, "entry_id", entry_id)
        if requester_field_values is not None:
            pulumi.set(__self__, "requester_field_values", requester_field_values)

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the catalog entry for which the request is being made.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entry_id", value)

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]]:
        """
        The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @requester_field_values.setter
    def requester_field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]]):
        pulumi.set(self, "requester_field_values", value)


@pulumi.input_type
class _EndUserMyRequestsState:
    def __init__(__self__, *,
                 entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndUserMyRequests resources.
        :param pulumi.Input[_builtins.str] entry_id: The ID of the catalog entry for which the request is being made.
        :param pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]] requester_field_values: The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        :param pulumi.Input[_builtins.str] status: The status of the request. Possible values include: `APPROVED`, `CANCELED`, `DENIED`, `EXPIRED`, `PENDING`, `REJECTED`, `SUBMITTED`
        """
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if requester_field_values is not None:
            pulumi.set(__self__, "requester_field_values", requester_field_values)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the catalog entry for which the request is being made.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_id", value)

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]]:
        """
        The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @requester_field_values.setter
    def requester_field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndUserMyRequestsRequesterFieldValueArgs']]]]):
        pulumi.set(self, "requester_field_values", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the request. Possible values include: `APPROVED`, `CANCELED`, `DENIED`, `EXPIRED`, `PENDING`, `REJECTED`, `SUBMITTED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("okta:index/endUserMyRequests:EndUserMyRequests")
class EndUserMyRequests(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndUserMyRequestsRequesterFieldValueArgs', 'EndUserMyRequestsRequesterFieldValueArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import okta:index/endUserMyRequests:EndUserMyRequests example <request_id/entry_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entry_id: The ID of the catalog entry for which the request is being made.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndUserMyRequestsRequesterFieldValueArgs', 'EndUserMyRequestsRequesterFieldValueArgsDict']]]] requester_field_values: The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndUserMyRequestsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import okta:index/endUserMyRequests:EndUserMyRequests example <request_id/entry_id>
        ```

        :param str resource_name: The name of the resource.
        :param EndUserMyRequestsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndUserMyRequestsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndUserMyRequestsRequesterFieldValueArgs', 'EndUserMyRequestsRequesterFieldValueArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndUserMyRequestsArgs.__new__(EndUserMyRequestsArgs)

            if entry_id is None and not opts.urn:
                raise TypeError("Missing required property 'entry_id'")
            __props__.__dict__["entry_id"] = entry_id
            __props__.__dict__["requester_field_values"] = requester_field_values
            __props__.__dict__["status"] = None
        super(EndUserMyRequests, __self__).__init__(
            'okta:index/endUserMyRequests:EndUserMyRequests',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entry_id: Optional[pulumi.Input[_builtins.str]] = None,
            requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndUserMyRequestsRequesterFieldValueArgs', 'EndUserMyRequestsRequesterFieldValueArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EndUserMyRequests':
        """
        Get an existing EndUserMyRequests resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entry_id: The ID of the catalog entry for which the request is being made.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndUserMyRequestsRequesterFieldValueArgs', 'EndUserMyRequestsRequesterFieldValueArgsDict']]]] requester_field_values: The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        :param pulumi.Input[_builtins.str] status: The status of the request. Possible values include: `APPROVED`, `CANCELED`, `DENIED`, `EXPIRED`, `PENDING`, `REJECTED`, `SUBMITTED`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndUserMyRequestsState.__new__(_EndUserMyRequestsState)

        __props__.__dict__["entry_id"] = entry_id
        __props__.__dict__["requester_field_values"] = requester_field_values
        __props__.__dict__["status"] = status
        return EndUserMyRequests(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the catalog entry for which the request is being made.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> pulumi.Output[Optional[Sequence['outputs.EndUserMyRequestsRequesterFieldValue']]]:
        """
        The requester input fields required by the approval system. Note: The fields required are determined by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the request. Possible values include: `APPROVED`, `CANCELED`, `DENIED`, `EXPIRED`, `PENDING`, `REJECTED`, `SUBMITTED`
        """
        return pulumi.get(self, "status")

