# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntitlementArgs', 'Entitlement']

@pulumi.input_type
class EntitlementArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[_builtins.str],
                 external_value: pulumi.Input[_builtins.str],
                 multi_value: pulumi.Input[_builtins.bool],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input['EntitlementParentArgs']] = None,
                 parent_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]] = None):
        """
        The set of arguments for constructing a Entitlement resource.
        :param pulumi.Input[_builtins.str] data_type: The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        :param pulumi.Input[_builtins.str] external_value: The value of an entitlement property.
        :param pulumi.Input[_builtins.bool] multi_value: The property that determines if the entitlement property can hold multiple values.
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement property.
        :param pulumi.Input['EntitlementParentArgs'] parent: Representation of a resource
        :param pulumi.Input[_builtins.str] parent_resource_orn: The Okta app instance, in ORN format.
        :param pulumi.Input[_builtins.str] value: The value of the entitlement property.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "multi_value", multi_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if parent_resource_orn is not None:
            pulumi.set(__self__, "parent_resource_orn", parent_resource_orn)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[_builtins.str]:
        """
        The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of an entitlement property.
        """
        return pulumi.get(self, "external_value")

    @external_value.setter
    def external_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_value", value)

    @_builtins.property
    @pulumi.getter(name="multiValue")
    def multi_value(self) -> pulumi.Input[_builtins.bool]:
        """
        The property that determines if the entitlement property can hold multiple values.
        """
        return pulumi.get(self, "multi_value")

    @multi_value.setter
    def multi_value(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "multi_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for an entitlement property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input['EntitlementParentArgs']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input['EntitlementParentArgs']]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="parentResourceOrn")
    def parent_resource_orn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Okta app instance, in ORN format.
        """
        return pulumi.get(self, "parent_resource_orn")

    @parent_resource_orn.setter
    def parent_resource_orn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_resource_orn", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the entitlement property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _EntitlementState:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_value: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input['EntitlementParentArgs']] = None,
                 parent_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]] = None):
        """
        Input properties used for looking up and filtering Entitlement resources.
        :param pulumi.Input[_builtins.str] data_type: The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[_builtins.str] external_value: The value of an entitlement property.
        :param pulumi.Input[_builtins.bool] multi_value: The property that determines if the entitlement property can hold multiple values.
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement property.
        :param pulumi.Input['EntitlementParentArgs'] parent: Representation of a resource
        :param pulumi.Input[_builtins.str] parent_resource_orn: The Okta app instance, in ORN format.
        :param pulumi.Input[_builtins.str] value: The value of the entitlement property.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if multi_value is not None:
            pulumi.set(__self__, "multi_value", multi_value)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if parent_resource_orn is not None:
            pulumi.set(__self__, "parent_resource_orn", parent_resource_orn)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of an entitlement property.
        """
        return pulumi.get(self, "external_value")

    @external_value.setter
    def external_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_value", value)

    @_builtins.property
    @pulumi.getter(name="multiValue")
    def multi_value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The property that determines if the entitlement property can hold multiple values.
        """
        return pulumi.get(self, "multi_value")

    @multi_value.setter
    def multi_value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for an entitlement property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input['EntitlementParentArgs']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input['EntitlementParentArgs']]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="parentResourceOrn")
    def parent_resource_orn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Okta app instance, in ORN format.
        """
        return pulumi.get(self, "parent_resource_orn")

    @parent_resource_orn.setter
    def parent_resource_orn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_resource_orn", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the entitlement property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementValueArgs']]]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("okta:index/entitlement:Entitlement")
class Entitlement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_value: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[Union['EntitlementParentArgs', 'EntitlementParentArgsDict']]] = None,
                 parent_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementValueArgs', 'EntitlementValueArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages Entitlement. This resource allows you to create and configure an Okta [Entitlement](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Entitlements/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Entitlement("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/entitlement:Entitlement example <entitlement_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_type: The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[_builtins.str] external_value: The value of an entitlement property.
        :param pulumi.Input[_builtins.bool] multi_value: The property that determines if the entitlement property can hold multiple values.
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement property.
        :param pulumi.Input[Union['EntitlementParentArgs', 'EntitlementParentArgsDict']] parent: Representation of a resource
        :param pulumi.Input[_builtins.str] parent_resource_orn: The Okta app instance, in ORN format.
        :param pulumi.Input[_builtins.str] value: The value of the entitlement property.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntitlementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Entitlement. This resource allows you to create and configure an Okta [Entitlement](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Entitlements/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Entitlement("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/entitlement:Entitlement example <entitlement_id>
        ```

        :param str resource_name: The name of the resource.
        :param EntitlementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntitlementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_value: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[Union['EntitlementParentArgs', 'EntitlementParentArgsDict']]] = None,
                 parent_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementValueArgs', 'EntitlementValueArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntitlementArgs.__new__(EntitlementArgs)

            if data_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_type'")
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["description"] = description
            if external_value is None and not opts.urn:
                raise TypeError("Missing required property 'external_value'")
            __props__.__dict__["external_value"] = external_value
            if multi_value is None and not opts.urn:
                raise TypeError("Missing required property 'multi_value'")
            __props__.__dict__["multi_value"] = multi_value
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            __props__.__dict__["parent_resource_orn"] = parent_resource_orn
            __props__.__dict__["value"] = value
            __props__.__dict__["values"] = values
        super(Entitlement, __self__).__init__(
            'okta:index/entitlement:Entitlement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_value: Optional[pulumi.Input[_builtins.str]] = None,
            multi_value: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[Union['EntitlementParentArgs', 'EntitlementParentArgsDict']]] = None,
            parent_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementValueArgs', 'EntitlementValueArgsDict']]]]] = None) -> 'Entitlement':
        """
        Get an existing Entitlement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_type: The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[_builtins.str] external_value: The value of an entitlement property.
        :param pulumi.Input[_builtins.bool] multi_value: The property that determines if the entitlement property can hold multiple values.
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement property.
        :param pulumi.Input[Union['EntitlementParentArgs', 'EntitlementParentArgsDict']] parent: Representation of a resource
        :param pulumi.Input[_builtins.str] parent_resource_orn: The Okta app instance, in ORN format.
        :param pulumi.Input[_builtins.str] value: The value of the entitlement property.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntitlementState.__new__(_EntitlementState)

        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["description"] = description
        __props__.__dict__["external_value"] = external_value
        __props__.__dict__["multi_value"] = multi_value
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["parent_resource_orn"] = parent_resource_orn
        __props__.__dict__["value"] = value
        __props__.__dict__["values"] = values
        return Entitlement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[_builtins.str]:
        """
        The data type of the entitlement property. If the entitlement property is multivalued, the data type is replaced with an array. Enum: "array", "string".
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of an entitlement property.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter(name="multiValue")
    def multi_value(self) -> pulumi.Output[_builtins.bool]:
        """
        The property that determines if the entitlement property can hold multiple values.
        """
        return pulumi.get(self, "multi_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for an entitlement property.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional['outputs.EntitlementParent']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="parentResourceOrn")
    def parent_resource_orn(self) -> pulumi.Output[_builtins.str]:
        """
        The Okta app instance, in ORN format.
        """
        return pulumi.get(self, "parent_resource_orn")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value of the entitlement property.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[Sequence['outputs.EntitlementValue']]]:
        return pulumi.get(self, "values")

