# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntitlementBundleArgs', 'EntitlementBundle']

@pulumi.input_type
class EntitlementBundleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input['EntitlementBundleTargetArgs']] = None,
                 target_resource_orn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EntitlementBundle resource.
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]] entitlements: List of entitlements in the bundle
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement bundle.
        :param pulumi.Input[_builtins.str] status: The status of the entitlement bundle.
        :param pulumi.Input['EntitlementBundleTargetArgs'] target: Representation of a resource
        :param pulumi.Input[_builtins.str] target_resource_orn: The ORN of the target resource. Required when updating the entitlement bundle.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_resource_orn is not None:
            pulumi.set(__self__, "target_resource_orn", target_resource_orn)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]]:
        """
        List of entitlements in the bundle
        """
        return pulumi.get(self, "entitlements")

    @entitlements.setter
    def entitlements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]]):
        pulumi.set(self, "entitlements", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the entitlement bundle.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['EntitlementBundleTargetArgs']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['EntitlementBundleTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceOrn")
    def target_resource_orn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ORN of the target resource. Required when updating the entitlement bundle.
        """
        return pulumi.get(self, "target_resource_orn")

    @target_resource_orn.setter
    def target_resource_orn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_orn", value)


@pulumi.input_type
class _EntitlementBundleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input['EntitlementBundleTargetArgs']] = None,
                 target_resource_orn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EntitlementBundle resources.
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]] entitlements: List of entitlements in the bundle
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement bundle.
        :param pulumi.Input[_builtins.str] status: The status of the entitlement bundle.
        :param pulumi.Input['EntitlementBundleTargetArgs'] target: Representation of a resource
        :param pulumi.Input[_builtins.str] target_resource_orn: The ORN of the target resource. Required when updating the entitlement bundle.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_resource_orn is not None:
            pulumi.set(__self__, "target_resource_orn", target_resource_orn)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]]:
        """
        List of entitlements in the bundle
        """
        return pulumi.get(self, "entitlements")

    @entitlements.setter
    def entitlements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementBundleEntitlementArgs']]]]):
        pulumi.set(self, "entitlements", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the entitlement bundle.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['EntitlementBundleTargetArgs']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['EntitlementBundleTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceOrn")
    def target_resource_orn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ORN of the target resource. Required when updating the entitlement bundle.
        """
        return pulumi.get(self, "target_resource_orn")

    @target_resource_orn.setter
    def target_resource_orn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_orn", value)


@pulumi.type_token("okta:index/entitlementBundle:EntitlementBundle")
class EntitlementBundle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementBundleEntitlementArgs', 'EntitlementBundleEntitlementArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['EntitlementBundleTargetArgs', 'EntitlementBundleTargetArgsDict']]] = None,
                 target_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Entitlement Bundles. This resource allows you to create and configure an Okta [Entitlement Bundle](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Entitlement-Bundles/#tag/Entitlement-Bundles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.EntitlementBundle("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/entitlementBundle:EntitlementBundle example <entitlement_bundle_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntitlementBundleEntitlementArgs', 'EntitlementBundleEntitlementArgsDict']]]] entitlements: List of entitlements in the bundle
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement bundle.
        :param pulumi.Input[_builtins.str] status: The status of the entitlement bundle.
        :param pulumi.Input[Union['EntitlementBundleTargetArgs', 'EntitlementBundleTargetArgsDict']] target: Representation of a resource
        :param pulumi.Input[_builtins.str] target_resource_orn: The ORN of the target resource. Required when updating the entitlement bundle.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EntitlementBundleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Entitlement Bundles. This resource allows you to create and configure an Okta [Entitlement Bundle](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Entitlement-Bundles/#tag/Entitlement-Bundles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.EntitlementBundle("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/entitlementBundle:EntitlementBundle example <entitlement_bundle_id>
        ```

        :param str resource_name: The name of the resource.
        :param EntitlementBundleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntitlementBundleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementBundleEntitlementArgs', 'EntitlementBundleEntitlementArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['EntitlementBundleTargetArgs', 'EntitlementBundleTargetArgsDict']]] = None,
                 target_resource_orn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntitlementBundleArgs.__new__(EntitlementBundleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["entitlements"] = entitlements
            __props__.__dict__["name"] = name
            __props__.__dict__["status"] = status
            __props__.__dict__["target"] = target
            __props__.__dict__["target_resource_orn"] = target_resource_orn
        super(EntitlementBundle, __self__).__init__(
            'okta:index/entitlementBundle:EntitlementBundle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementBundleEntitlementArgs', 'EntitlementBundleEntitlementArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target: Optional[pulumi.Input[Union['EntitlementBundleTargetArgs', 'EntitlementBundleTargetArgsDict']]] = None,
            target_resource_orn: Optional[pulumi.Input[_builtins.str]] = None) -> 'EntitlementBundle':
        """
        Get an existing EntitlementBundle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of an entitlement property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntitlementBundleEntitlementArgs', 'EntitlementBundleEntitlementArgsDict']]]] entitlements: List of entitlements in the bundle
        :param pulumi.Input[_builtins.str] name: The display name for an entitlement bundle.
        :param pulumi.Input[_builtins.str] status: The status of the entitlement bundle.
        :param pulumi.Input[Union['EntitlementBundleTargetArgs', 'EntitlementBundleTargetArgsDict']] target: Representation of a resource
        :param pulumi.Input[_builtins.str] target_resource_orn: The ORN of the target resource. Required when updating the entitlement bundle.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntitlementBundleState.__new__(_EntitlementBundleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entitlements"] = entitlements
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["target"] = target
        __props__.__dict__["target_resource_orn"] = target_resource_orn
        return EntitlementBundle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> pulumi.Output[Optional[Sequence['outputs.EntitlementBundleEntitlement']]]:
        """
        List of entitlements in the bundle
        """
        return pulumi.get(self, "entitlements")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the entitlement bundle.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional['outputs.EntitlementBundleTarget']]:
        """
        Representation of a resource
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetResourceOrn")
    def target_resource_orn(self) -> pulumi.Output[_builtins.str]:
        """
        The ORN of the target resource. Required when updating the entitlement bundle.
        """
        return pulumi.get(self, "target_resource_orn")

