# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAuthServerClaimsResult',
    'AwaitableGetAuthServerClaimsResult',
    'get_auth_server_claims',
    'get_auth_server_claims_output',
]

@pulumi.output_type
class GetAuthServerClaimsResult:
    """
    A collection of values returned by getAuthServerClaims.
    """
    def __init__(__self__, auth_server_id=None, claims=None, id=None):
        if auth_server_id and not isinstance(auth_server_id, str):
            raise TypeError("Expected argument 'auth_server_id' to be a str")
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        if claims and not isinstance(claims, list):
            raise TypeError("Expected argument 'claims' to be a list")
        pulumi.set(__self__, "claims", claims)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> _builtins.str:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @_builtins.property
    @pulumi.getter
    def claims(self) -> Sequence['outputs.GetAuthServerClaimsClaimResult']:
        """
        Collection of authorization server claims retrieved from Okta with the following properties.
        """
        return pulumi.get(self, "claims")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAuthServerClaimsResult(GetAuthServerClaimsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthServerClaimsResult(
            auth_server_id=self.auth_server_id,
            claims=self.claims,
            id=self.id)


def get_auth_server_claims(auth_server_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthServerClaimsResult:
    """
    Get a list of authorization server claims from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_auth_server_claims(auth_server_id="default")
    ```


    :param _builtins.str auth_server_id: Auth server ID
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAuthServerClaims:getAuthServerClaims', __args__, opts=opts, typ=GetAuthServerClaimsResult).value

    return AwaitableGetAuthServerClaimsResult(
        auth_server_id=pulumi.get(__ret__, 'auth_server_id'),
        claims=pulumi.get(__ret__, 'claims'),
        id=pulumi.get(__ret__, 'id'))
def get_auth_server_claims_output(auth_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthServerClaimsResult]:
    """
    Get a list of authorization server claims from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_auth_server_claims(auth_server_id="default")
    ```


    :param _builtins.str auth_server_id: Auth server ID
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getAuthServerClaims:getAuthServerClaims', __args__, opts=opts, typ=GetAuthServerClaimsResult)
    return __ret__.apply(lambda __response__: GetAuthServerClaimsResult(
        auth_server_id=pulumi.get(__response__, 'auth_server_id'),
        claims=pulumi.get(__response__, 'claims'),
        id=pulumi.get(__response__, 'id')))
