# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBrandResult',
    'AwaitableGetBrandResult',
    'get_brand',
    'get_brand_output',
]

@pulumi.output_type
class GetBrandResult:
    """
    A collection of values returned by getBrand.
    """
    def __init__(__self__, brand_id=None, custom_privacy_policy_url=None, id=None, links=None, name=None, remove_powered_by_okta=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if custom_privacy_policy_url and not isinstance(custom_privacy_policy_url, str):
            raise TypeError("Expected argument 'custom_privacy_policy_url' to be a str")
        pulumi.set(__self__, "custom_privacy_policy_url", custom_privacy_policy_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if remove_powered_by_okta and not isinstance(remove_powered_by_okta, bool):
            raise TypeError("Expected argument 'remove_powered_by_okta' to be a bool")
        pulumi.set(__self__, "remove_powered_by_okta", remove_powered_by_okta)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="customPrivacyPolicyUrl")
    def custom_privacy_policy_url(self) -> _builtins.str:
        """
        Custom privacy policy URL
        """
        return pulumi.get(self, "custom_privacy_policy_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Brand
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the brand
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Brand name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="removePoweredByOkta")
    def remove_powered_by_okta(self) -> _builtins.bool:
        """
        Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
        """
        return pulumi.get(self, "remove_powered_by_okta")


class AwaitableGetBrandResult(GetBrandResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBrandResult(
            brand_id=self.brand_id,
            custom_privacy_policy_url=self.custom_privacy_policy_url,
            id=self.id,
            links=self.links,
            name=self.name,
            remove_powered_by_okta=self.remove_powered_by_okta)


def get_brand(brand_id: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBrandResult:
    """
    Get a single Brand from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    test_get_brand = okta.get_brand(brand_id=test.brands[0].id)
    default = okta.get_brand(brand_id="default")
    ```


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getBrand:getBrand', __args__, opts=opts, typ=GetBrandResult).value

    return AwaitableGetBrandResult(
        brand_id=pulumi.get(__ret__, 'brand_id'),
        custom_privacy_policy_url=pulumi.get(__ret__, 'custom_privacy_policy_url'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        remove_powered_by_okta=pulumi.get(__ret__, 'remove_powered_by_okta'))
def get_brand_output(brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBrandResult]:
    """
    Get a single Brand from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    test_get_brand = okta.get_brand(brand_id=test.brands[0].id)
    default = okta.get_brand(brand_id="default")
    ```


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getBrand:getBrand', __args__, opts=opts, typ=GetBrandResult)
    return __ret__.apply(lambda __response__: GetBrandResult(
        brand_id=pulumi.get(__response__, 'brand_id'),
        custom_privacy_policy_url=pulumi.get(__response__, 'custom_privacy_policy_url'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        remove_powered_by_okta=pulumi.get(__response__, 'remove_powered_by_okta')))
