# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetBrandsResult',
    'AwaitableGetBrandsResult',
    'get_brands',
    'get_brands_output',
]

@pulumi.output_type
class GetBrandsResult:
    """
    A collection of values returned by getBrands.
    """
    def __init__(__self__, brands=None, id=None):
        if brands and not isinstance(brands, list):
            raise TypeError("Expected argument 'brands' to be a list")
        pulumi.set(__self__, "brands", brands)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def brands(self) -> Sequence['outputs.GetBrandsBrandResult']:
        """
        List of `Brand` belonging to the organization
        """
        return pulumi.get(self, "brands")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetBrandsResult(GetBrandsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBrandsResult(
            brands=self.brands,
            id=self.id)


def get_brands(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBrandsResult:
    """
    Get the brands belonging to an Okta organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getBrands:getBrands', __args__, opts=opts, typ=GetBrandsResult).value

    return AwaitableGetBrandsResult(
        brands=pulumi.get(__ret__, 'brands'),
        id=pulumi.get(__ret__, 'id'))
def get_brands_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBrandsResult]:
    """
    Get the brands belonging to an Okta organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getBrands:getBrands', __args__, opts=opts, typ=GetBrandsResult)
    return __ret__.apply(lambda __response__: GetBrandsResult(
        brands=pulumi.get(__response__, 'brands'),
        id=pulumi.get(__response__, 'id')))
