# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogEntryDefaultResult',
    'AwaitableGetCatalogEntryDefaultResult',
    'get_catalog_entry_default',
    'get_catalog_entry_default_output',
]

@pulumi.output_type
class GetCatalogEntryDefaultResult:
    """
    A collection of values returned by getCatalogEntryDefault.
    """
    def __init__(__self__, counts=None, description=None, entry_id=None, id=None, label=None, links=None, name=None, parent=None, requestable=None):
        if counts and not isinstance(counts, dict):
            raise TypeError("Expected argument 'counts' to be a dict")
        pulumi.set(__self__, "counts", counts)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entry_id and not isinstance(entry_id, str):
            raise TypeError("Expected argument 'entry_id' to be a str")
        pulumi.set(__self__, "entry_id", entry_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if links and not isinstance(links, dict):
            raise TypeError("Expected argument 'links' to be a dict")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if requestable and not isinstance(requestable, bool):
            raise TypeError("Expected argument 'requestable' to be a bool")
        pulumi.set(__self__, "requestable", requestable)

    @_builtins.property
    @pulumi.getter
    def counts(self) -> Optional['outputs.GetCatalogEntryDefaultCountsResult']:
        return pulumi.get(self, "counts")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the catalog entry.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> _builtins.str:
        """
        TThe ID of the catalog entry.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier for the entry.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label of the entry. Enum: `Application`, `Resource Collection`.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional['outputs.GetCatalogEntryDefaultLinksResult']:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the catalog entry.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        """
        Parent of the catalog entry.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def requestable(self) -> _builtins.bool:
        """
        Is the resource requestable.
        """
        return pulumi.get(self, "requestable")


class AwaitableGetCatalogEntryDefaultResult(GetCatalogEntryDefaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogEntryDefaultResult(
            counts=self.counts,
            description=self.description,
            entry_id=self.entry_id,
            id=self.id,
            label=self.label,
            links=self.links,
            name=self.name,
            parent=self.parent,
            requestable=self.requestable)


def get_catalog_entry_default(counts: Optional[Union['GetCatalogEntryDefaultCountsArgs', 'GetCatalogEntryDefaultCountsArgsDict']] = None,
                              entry_id: Optional[_builtins.str] = None,
                              links: Optional[Union['GetCatalogEntryDefaultLinksArgs', 'GetCatalogEntryDefaultLinksArgsDict']] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogEntryDefaultResult:
    """
    Retrieves a catalog entry.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_catalog_entry_user_access_request_fields()
    ```


    :param _builtins.str entry_id: TThe ID of the catalog entry.
    """
    __args__ = dict()
    __args__['counts'] = counts
    __args__['entryId'] = entry_id
    __args__['links'] = links
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getCatalogEntryDefault:getCatalogEntryDefault', __args__, opts=opts, typ=GetCatalogEntryDefaultResult).value

    return AwaitableGetCatalogEntryDefaultResult(
        counts=pulumi.get(__ret__, 'counts'),
        description=pulumi.get(__ret__, 'description'),
        entry_id=pulumi.get(__ret__, 'entry_id'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'),
        requestable=pulumi.get(__ret__, 'requestable'))
def get_catalog_entry_default_output(counts: Optional[pulumi.Input[Optional[Union['GetCatalogEntryDefaultCountsArgs', 'GetCatalogEntryDefaultCountsArgsDict']]]] = None,
                                     entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     links: Optional[pulumi.Input[Optional[Union['GetCatalogEntryDefaultLinksArgs', 'GetCatalogEntryDefaultLinksArgsDict']]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogEntryDefaultResult]:
    """
    Retrieves a catalog entry.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_catalog_entry_user_access_request_fields()
    ```


    :param _builtins.str entry_id: TThe ID of the catalog entry.
    """
    __args__ = dict()
    __args__['counts'] = counts
    __args__['entryId'] = entry_id
    __args__['links'] = links
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getCatalogEntryDefault:getCatalogEntryDefault', __args__, opts=opts, typ=GetCatalogEntryDefaultResult)
    return __ret__.apply(lambda __response__: GetCatalogEntryDefaultResult(
        counts=pulumi.get(__response__, 'counts'),
        description=pulumi.get(__response__, 'description'),
        entry_id=pulumi.get(__response__, 'entry_id'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent'),
        requestable=pulumi.get(__response__, 'requestable')))
