# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEmailCustomizationsResult',
    'AwaitableGetEmailCustomizationsResult',
    'get_email_customizations',
    'get_email_customizations_output',
]

@pulumi.output_type
class GetEmailCustomizationsResult:
    """
    A collection of values returned by getEmailCustomizations.
    """
    def __init__(__self__, brand_id=None, email_customizations=None, id=None, template_name=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if email_customizations and not isinstance(email_customizations, list):
            raise TypeError("Expected argument 'email_customizations' to be a list")
        pulumi.set(__self__, "email_customizations", email_customizations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="emailCustomizations")
    def email_customizations(self) -> Sequence['outputs.GetEmailCustomizationsEmailCustomizationResult']:
        """
        List of `EmailCustomization` belonging to the named email template of the brand in the organization
        """
        return pulumi.get(self, "email_customizations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        Template Name
        """
        return pulumi.get(self, "template_name")


class AwaitableGetEmailCustomizationsResult(GetEmailCustomizationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailCustomizationsResult(
            brand_id=self.brand_id,
            email_customizations=self.email_customizations,
            id=self.id,
            template_name=self.template_name)


def get_email_customizations(brand_id: Optional[_builtins.str] = None,
                             template_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailCustomizationsResult:
    """
    Get the email customizations of an email template belonging to a brand in an Okta organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    forgot_password = okta.get_email_customizations(brand_id=test.brands[0].id,
        template_name="ForgotPassword")
    ```


    :param _builtins.str brand_id: Brand ID
    :param _builtins.str template_name: Template Name
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getEmailCustomizations:getEmailCustomizations', __args__, opts=opts, typ=GetEmailCustomizationsResult).value

    return AwaitableGetEmailCustomizationsResult(
        brand_id=pulumi.get(__ret__, 'brand_id'),
        email_customizations=pulumi.get(__ret__, 'email_customizations'),
        id=pulumi.get(__ret__, 'id'),
        template_name=pulumi.get(__ret__, 'template_name'))
def get_email_customizations_output(brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    template_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailCustomizationsResult]:
    """
    Get the email customizations of an email template belonging to a brand in an Okta organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    forgot_password = okta.get_email_customizations(brand_id=test.brands[0].id,
        template_name="ForgotPassword")
    ```


    :param _builtins.str brand_id: Brand ID
    :param _builtins.str template_name: Template Name
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getEmailCustomizations:getEmailCustomizations', __args__, opts=opts, typ=GetEmailCustomizationsResult)
    return __ret__.apply(lambda __response__: GetEmailCustomizationsResult(
        brand_id=pulumi.get(__response__, 'brand_id'),
        email_customizations=pulumi.get(__response__, 'email_customizations'),
        id=pulumi.get(__response__, 'id'),
        template_name=pulumi.get(__response__, 'template_name')))
