# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEndUserMyRequestsResult',
    'AwaitableGetEndUserMyRequestsResult',
    'get_end_user_my_requests',
    'get_end_user_my_requests_output',
]

@pulumi.output_type
class GetEndUserMyRequestsResult:
    """
    A collection of values returned by getEndUserMyRequests.
    """
    def __init__(__self__, access_duration=None, created=None, created_by=None, entry_id=None, grant_status=None, granted=None, id=None, last_updated=None, last_updated_by=None, requested=None, requested_by=None, requested_for=None, requester_field_values=None, resolved=None, revocation_scheduled=None, revocation_status=None, revoked=None, risk_assessment=None, status=None):
        if access_duration and not isinstance(access_duration, str):
            raise TypeError("Expected argument 'access_duration' to be a str")
        pulumi.set(__self__, "access_duration", access_duration)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if entry_id and not isinstance(entry_id, str):
            raise TypeError("Expected argument 'entry_id' to be a str")
        pulumi.set(__self__, "entry_id", entry_id)
        if grant_status and not isinstance(grant_status, str):
            raise TypeError("Expected argument 'grant_status' to be a str")
        pulumi.set(__self__, "grant_status", grant_status)
        if granted and not isinstance(granted, str):
            raise TypeError("Expected argument 'granted' to be a str")
        pulumi.set(__self__, "granted", granted)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if requested and not isinstance(requested, dict):
            raise TypeError("Expected argument 'requested' to be a dict")
        pulumi.set(__self__, "requested", requested)
        if requested_by and not isinstance(requested_by, dict):
            raise TypeError("Expected argument 'requested_by' to be a dict")
        pulumi.set(__self__, "requested_by", requested_by)
        if requested_for and not isinstance(requested_for, dict):
            raise TypeError("Expected argument 'requested_for' to be a dict")
        pulumi.set(__self__, "requested_for", requested_for)
        if requester_field_values and not isinstance(requester_field_values, list):
            raise TypeError("Expected argument 'requester_field_values' to be a list")
        pulumi.set(__self__, "requester_field_values", requester_field_values)
        if resolved and not isinstance(resolved, str):
            raise TypeError("Expected argument 'resolved' to be a str")
        pulumi.set(__self__, "resolved", resolved)
        if revocation_scheduled and not isinstance(revocation_scheduled, str):
            raise TypeError("Expected argument 'revocation_scheduled' to be a str")
        pulumi.set(__self__, "revocation_scheduled", revocation_scheduled)
        if revocation_status and not isinstance(revocation_status, str):
            raise TypeError("Expected argument 'revocation_status' to be a str")
        pulumi.set(__self__, "revocation_status", revocation_status)
        if revoked and not isinstance(revoked, str):
            raise TypeError("Expected argument 'revoked' to be a str")
        pulumi.set(__self__, "revoked", revoked)
        if risk_assessment and not isinstance(risk_assessment, dict):
            raise TypeError("Expected argument 'risk_assessment' to be a dict")
        pulumi.set(__self__, "risk_assessment", risk_assessment)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessDuration")
    def access_duration(self) -> _builtins.str:
        return pulumi.get(self, "access_duration")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> _builtins.str:
        """
        The ID of the catalog entry for which the request was made.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter(name="grantStatus")
    def grant_status(self) -> _builtins.str:
        return pulumi.get(self, "grant_status")

    @_builtins.property
    @pulumi.getter
    def granted(self) -> _builtins.str:
        return pulumi.get(self, "granted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the request to retrieve.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def requested(self) -> Optional['outputs.GetEndUserMyRequestsRequestedResult']:
        return pulumi.get(self, "requested")

    @_builtins.property
    @pulumi.getter(name="requestedBy")
    def requested_by(self) -> Optional['outputs.GetEndUserMyRequestsRequestedByResult']:
        return pulumi.get(self, "requested_by")

    @_builtins.property
    @pulumi.getter(name="requestedFor")
    def requested_for(self) -> Optional['outputs.GetEndUserMyRequestsRequestedForResult']:
        return pulumi.get(self, "requested_for")

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> Optional[Sequence['outputs.GetEndUserMyRequestsRequesterFieldValueResult']]:
        """
        The requester input fields and their values from the request.
        """
        return pulumi.get(self, "requester_field_values")

    @_builtins.property
    @pulumi.getter
    def resolved(self) -> _builtins.str:
        return pulumi.get(self, "resolved")

    @_builtins.property
    @pulumi.getter(name="revocationScheduled")
    def revocation_scheduled(self) -> _builtins.str:
        return pulumi.get(self, "revocation_scheduled")

    @_builtins.property
    @pulumi.getter(name="revocationStatus")
    def revocation_status(self) -> _builtins.str:
        return pulumi.get(self, "revocation_status")

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> _builtins.str:
        return pulumi.get(self, "revoked")

    @_builtins.property
    @pulumi.getter(name="riskAssessment")
    def risk_assessment(self) -> Optional['outputs.GetEndUserMyRequestsRiskAssessmentResult']:
        return pulumi.get(self, "risk_assessment")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the request. Possible values include: `APPROVED`, `CANCELED`, `DENIED`, `EXPIRED`, `PENDING`, `REJECTED`, `SUBMITTED`
        """
        return pulumi.get(self, "status")


class AwaitableGetEndUserMyRequestsResult(GetEndUserMyRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndUserMyRequestsResult(
            access_duration=self.access_duration,
            created=self.created,
            created_by=self.created_by,
            entry_id=self.entry_id,
            grant_status=self.grant_status,
            granted=self.granted,
            id=self.id,
            last_updated=self.last_updated,
            last_updated_by=self.last_updated_by,
            requested=self.requested,
            requested_by=self.requested_by,
            requested_for=self.requested_for,
            requester_field_values=self.requester_field_values,
            resolved=self.resolved,
            revocation_scheduled=self.revocation_scheduled,
            revocation_status=self.revocation_status,
            revoked=self.revoked,
            risk_assessment=self.risk_assessment,
            status=self.status)


def get_end_user_my_requests(entry_id: Optional[_builtins.str] = None,
                             id: Optional[_builtins.str] = None,
                             requested: Optional[Union['GetEndUserMyRequestsRequestedArgs', 'GetEndUserMyRequestsRequestedArgsDict']] = None,
                             requested_by: Optional[Union['GetEndUserMyRequestsRequestedByArgs', 'GetEndUserMyRequestsRequestedByArgsDict']] = None,
                             requested_for: Optional[Union['GetEndUserMyRequestsRequestedForArgs', 'GetEndUserMyRequestsRequestedForArgsDict']] = None,
                             requester_field_values: Optional[Sequence[Union['GetEndUserMyRequestsRequesterFieldValueArgs', 'GetEndUserMyRequestsRequesterFieldValueArgsDict']]] = None,
                             risk_assessment: Optional[Union['GetEndUserMyRequestsRiskAssessmentArgs', 'GetEndUserMyRequestsRiskAssessmentArgsDict']] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndUserMyRequestsResult:
    """
    Get an End User Request from Okta Identity Governance. This data source allows you to retrieve information about existing access requests in the Okta Identity Governance system.

    Use this data source to fetch details about a specific request, including its current status, field values, and other metadata.

    > **Note:** This data source is part of Okta Identity Governance functionality and requires appropriate licensing and configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    # Get a request by its catalog entry ID and request ID
    example = okta.get_end_user_my_requests(entry_id="cen123456789abcdefgh",
        id="reqABCDEFG0123456789")
    pulumi.export("requestStatus", example.status)
    pulumi.export("requestFieldValues", example.requester_field_values)
    ```

    ## Field Type Reference

    ### Field Types and Values

    - **TEXT**: Contains free-form text input in the `value` attribute
    - **SELECT**: Contains single selection value in the `value` attribute
    - **MULTISELECT**: Contains multiple selection values in the `values` attribute (list)
    - **DURATION**: Contains time duration specification in the `value` attribute (e.g., "5 days", "2 weeks")
    - **ISO_DATE**: Contains date specification in ISO format in the `value` attribute
    - **OKTA_USER_ID**: Contains Okta user ID in the `value` attribute

    ### Usage Notes

    - For `MULTISELECT` type fields, the values will be in the `values` attribute as a list
    - For all other field types, the value will be in the `value` attribute as a string
    - The `label` and `type` attributes provide metadata about the field structure
    - Field definitions and requirements are determined by the approval system configuration

    ## Limitations and Considerations

    1. **Read-Only**: This data source only retrieves existing request information and cannot modify requests.

    2. **Identity Governance Licensing**: This data source requires Okta Identity Governance licensing and proper configuration.

    3. **Request Lifecycle**: The data reflects the current state of the request in the approval workflow.

    4. **Field Structure**: The field structure and available types depend on the approval system configuration in Okta Identity Governance.


    :param _builtins.str entry_id: The ID of the catalog entry for which the request was made.
    :param _builtins.str id: The ID of the request to retrieve.
    :param Sequence[Union['GetEndUserMyRequestsRequesterFieldValueArgs', 'GetEndUserMyRequestsRequesterFieldValueArgsDict']] requester_field_values: The requester input fields and their values from the request.
    """
    __args__ = dict()
    __args__['entryId'] = entry_id
    __args__['id'] = id
    __args__['requested'] = requested
    __args__['requestedBy'] = requested_by
    __args__['requestedFor'] = requested_for
    __args__['requesterFieldValues'] = requester_field_values
    __args__['riskAssessment'] = risk_assessment
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getEndUserMyRequests:getEndUserMyRequests', __args__, opts=opts, typ=GetEndUserMyRequestsResult).value

    return AwaitableGetEndUserMyRequestsResult(
        access_duration=pulumi.get(__ret__, 'access_duration'),
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        entry_id=pulumi.get(__ret__, 'entry_id'),
        grant_status=pulumi.get(__ret__, 'grant_status'),
        granted=pulumi.get(__ret__, 'granted'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        requested=pulumi.get(__ret__, 'requested'),
        requested_by=pulumi.get(__ret__, 'requested_by'),
        requested_for=pulumi.get(__ret__, 'requested_for'),
        requester_field_values=pulumi.get(__ret__, 'requester_field_values'),
        resolved=pulumi.get(__ret__, 'resolved'),
        revocation_scheduled=pulumi.get(__ret__, 'revocation_scheduled'),
        revocation_status=pulumi.get(__ret__, 'revocation_status'),
        revoked=pulumi.get(__ret__, 'revoked'),
        risk_assessment=pulumi.get(__ret__, 'risk_assessment'),
        status=pulumi.get(__ret__, 'status'))
def get_end_user_my_requests_output(entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    id: Optional[pulumi.Input[_builtins.str]] = None,
                                    requested: Optional[pulumi.Input[Optional[Union['GetEndUserMyRequestsRequestedArgs', 'GetEndUserMyRequestsRequestedArgsDict']]]] = None,
                                    requested_by: Optional[pulumi.Input[Optional[Union['GetEndUserMyRequestsRequestedByArgs', 'GetEndUserMyRequestsRequestedByArgsDict']]]] = None,
                                    requested_for: Optional[pulumi.Input[Optional[Union['GetEndUserMyRequestsRequestedForArgs', 'GetEndUserMyRequestsRequestedForArgsDict']]]] = None,
                                    requester_field_values: Optional[pulumi.Input[Optional[Sequence[Union['GetEndUserMyRequestsRequesterFieldValueArgs', 'GetEndUserMyRequestsRequesterFieldValueArgsDict']]]]] = None,
                                    risk_assessment: Optional[pulumi.Input[Optional[Union['GetEndUserMyRequestsRiskAssessmentArgs', 'GetEndUserMyRequestsRiskAssessmentArgsDict']]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndUserMyRequestsResult]:
    """
    Get an End User Request from Okta Identity Governance. This data source allows you to retrieve information about existing access requests in the Okta Identity Governance system.

    Use this data source to fetch details about a specific request, including its current status, field values, and other metadata.

    > **Note:** This data source is part of Okta Identity Governance functionality and requires appropriate licensing and configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    # Get a request by its catalog entry ID and request ID
    example = okta.get_end_user_my_requests(entry_id="cen123456789abcdefgh",
        id="reqABCDEFG0123456789")
    pulumi.export("requestStatus", example.status)
    pulumi.export("requestFieldValues", example.requester_field_values)
    ```

    ## Field Type Reference

    ### Field Types and Values

    - **TEXT**: Contains free-form text input in the `value` attribute
    - **SELECT**: Contains single selection value in the `value` attribute
    - **MULTISELECT**: Contains multiple selection values in the `values` attribute (list)
    - **DURATION**: Contains time duration specification in the `value` attribute (e.g., "5 days", "2 weeks")
    - **ISO_DATE**: Contains date specification in ISO format in the `value` attribute
    - **OKTA_USER_ID**: Contains Okta user ID in the `value` attribute

    ### Usage Notes

    - For `MULTISELECT` type fields, the values will be in the `values` attribute as a list
    - For all other field types, the value will be in the `value` attribute as a string
    - The `label` and `type` attributes provide metadata about the field structure
    - Field definitions and requirements are determined by the approval system configuration

    ## Limitations and Considerations

    1. **Read-Only**: This data source only retrieves existing request information and cannot modify requests.

    2. **Identity Governance Licensing**: This data source requires Okta Identity Governance licensing and proper configuration.

    3. **Request Lifecycle**: The data reflects the current state of the request in the approval workflow.

    4. **Field Structure**: The field structure and available types depend on the approval system configuration in Okta Identity Governance.


    :param _builtins.str entry_id: The ID of the catalog entry for which the request was made.
    :param _builtins.str id: The ID of the request to retrieve.
    :param Sequence[Union['GetEndUserMyRequestsRequesterFieldValueArgs', 'GetEndUserMyRequestsRequesterFieldValueArgsDict']] requester_field_values: The requester input fields and their values from the request.
    """
    __args__ = dict()
    __args__['entryId'] = entry_id
    __args__['id'] = id
    __args__['requested'] = requested
    __args__['requestedBy'] = requested_by
    __args__['requestedFor'] = requested_for
    __args__['requesterFieldValues'] = requester_field_values
    __args__['riskAssessment'] = risk_assessment
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getEndUserMyRequests:getEndUserMyRequests', __args__, opts=opts, typ=GetEndUserMyRequestsResult)
    return __ret__.apply(lambda __response__: GetEndUserMyRequestsResult(
        access_duration=pulumi.get(__response__, 'access_duration'),
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        entry_id=pulumi.get(__response__, 'entry_id'),
        grant_status=pulumi.get(__response__, 'grant_status'),
        granted=pulumi.get(__response__, 'granted'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        requested=pulumi.get(__response__, 'requested'),
        requested_by=pulumi.get(__response__, 'requested_by'),
        requested_for=pulumi.get(__response__, 'requested_for'),
        requester_field_values=pulumi.get(__response__, 'requester_field_values'),
        resolved=pulumi.get(__response__, 'resolved'),
        revocation_scheduled=pulumi.get(__response__, 'revocation_scheduled'),
        revocation_status=pulumi.get(__response__, 'revocation_status'),
        revoked=pulumi.get(__response__, 'revoked'),
        risk_assessment=pulumi.get(__response__, 'risk_assessment'),
        status=pulumi.get(__response__, 'status')))
