# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEntitlementBundleResult',
    'AwaitableGetEntitlementBundleResult',
    'get_entitlement_bundle',
    'get_entitlement_bundle_output',
]

@pulumi.output_type
class GetEntitlementBundleResult:
    """
    A collection of values returned by getEntitlementBundle.
    """
    def __init__(__self__, created=None, created_by=None, description=None, entitlements=None, id=None, last_updated=None, last_updated_by=None, name=None, status=None, target=None, target_resource_orn=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entitlements and not isinstance(entitlements, list):
            raise TypeError("Expected argument 'entitlements' to be a list")
        pulumi.set(__self__, "entitlements", entitlements)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if target and not isinstance(target, dict):
            raise TypeError("Expected argument 'target' to be a dict")
        pulumi.set(__self__, "target", target)
        if target_resource_orn and not isinstance(target_resource_orn, str):
            raise TypeError("Expected argument 'target_resource_orn' to be a str")
        pulumi.set(__self__, "target_resource_orn", target_resource_orn)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The created timestamp of this resource.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The ID of the user that created this resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> Optional[Sequence['outputs.GetEntitlementBundleEntitlementResult']]:
        """
        List of entitlements in the bundle
        """
        return pulumi.get(self, "entitlements")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The last updated timestamp of this resource.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The ID of the user that last updated this resource.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the entitlement bundle.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.GetEntitlementBundleTargetResult']:
        """
        Representation of a resource
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetResourceOrn")
    def target_resource_orn(self) -> _builtins.str:
        """
        The ORN of the target resource. Required when updating the entitlement bundle.
        """
        return pulumi.get(self, "target_resource_orn")


class AwaitableGetEntitlementBundleResult(GetEntitlementBundleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntitlementBundleResult(
            created=self.created,
            created_by=self.created_by,
            description=self.description,
            entitlements=self.entitlements,
            id=self.id,
            last_updated=self.last_updated,
            last_updated_by=self.last_updated_by,
            name=self.name,
            status=self.status,
            target=self.target,
            target_resource_orn=self.target_resource_orn)


def get_entitlement_bundle(entitlements: Optional[Sequence[Union['GetEntitlementBundleEntitlementArgs', 'GetEntitlementBundleEntitlementArgsDict']]] = None,
                           id: Optional[_builtins.str] = None,
                           target: Optional[Union['GetEntitlementBundleTargetArgs', 'GetEntitlementBundleTargetArgsDict']] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntitlementBundleResult:
    """
    Get the entitlement bundle for the given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_entitlement_bundle(id="<entitlement_bundle id>")
    ```


    :param Sequence[Union['GetEntitlementBundleEntitlementArgs', 'GetEntitlementBundleEntitlementArgsDict']] entitlements: List of entitlements in the bundle
    :param _builtins.str id: The ID of this resource.
    :param Union['GetEntitlementBundleTargetArgs', 'GetEntitlementBundleTargetArgsDict'] target: Representation of a resource
    """
    __args__ = dict()
    __args__['entitlements'] = entitlements
    __args__['id'] = id
    __args__['target'] = target
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getEntitlementBundle:getEntitlementBundle', __args__, opts=opts, typ=GetEntitlementBundleResult).value

    return AwaitableGetEntitlementBundleResult(
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        entitlements=pulumi.get(__ret__, 'entitlements'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        target=pulumi.get(__ret__, 'target'),
        target_resource_orn=pulumi.get(__ret__, 'target_resource_orn'))
def get_entitlement_bundle_output(entitlements: Optional[pulumi.Input[Optional[Sequence[Union['GetEntitlementBundleEntitlementArgs', 'GetEntitlementBundleEntitlementArgsDict']]]]] = None,
                                  id: Optional[pulumi.Input[_builtins.str]] = None,
                                  target: Optional[pulumi.Input[Optional[Union['GetEntitlementBundleTargetArgs', 'GetEntitlementBundleTargetArgsDict']]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEntitlementBundleResult]:
    """
    Get the entitlement bundle for the given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_entitlement_bundle(id="<entitlement_bundle id>")
    ```


    :param Sequence[Union['GetEntitlementBundleEntitlementArgs', 'GetEntitlementBundleEntitlementArgsDict']] entitlements: List of entitlements in the bundle
    :param _builtins.str id: The ID of this resource.
    :param Union['GetEntitlementBundleTargetArgs', 'GetEntitlementBundleTargetArgsDict'] target: Representation of a resource
    """
    __args__ = dict()
    __args__['entitlements'] = entitlements
    __args__['id'] = id
    __args__['target'] = target
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getEntitlementBundle:getEntitlementBundle', __args__, opts=opts, typ=GetEntitlementBundleResult)
    return __ret__.apply(lambda __response__: GetEntitlementBundleResult(
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        entitlements=pulumi.get(__response__, 'entitlements'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        target=pulumi.get(__response__, 'target'),
        target_resource_orn=pulumi.get(__response__, 'target_resource_orn')))
