# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrincipalEntitlementsResult',
    'AwaitableGetPrincipalEntitlementsResult',
    'get_principal_entitlements',
    'get_principal_entitlements_output',
]

@pulumi.output_type
class GetPrincipalEntitlementsResult:
    """
    A collection of values returned by getPrincipalEntitlements.
    """
    def __init__(__self__, datas=None, id=None, parent=None, target_principal=None):
        if datas and not isinstance(datas, list):
            raise TypeError("Expected argument 'datas' to be a list")
        pulumi.set(__self__, "datas", datas)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent and not isinstance(parent, dict):
            raise TypeError("Expected argument 'parent' to be a dict")
        pulumi.set(__self__, "parent", parent)
        if target_principal and not isinstance(target_principal, dict):
            raise TypeError("Expected argument 'target_principal' to be a dict")
        pulumi.set(__self__, "target_principal", target_principal)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.GetPrincipalEntitlementsDataResult']]:
        """
        Principal entitlements list.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional['outputs.GetPrincipalEntitlementsParentResult']:
        """
        Representation of a resource.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="targetPrincipal")
    def target_principal(self) -> Optional['outputs.GetPrincipalEntitlementsTargetPrincipalResult']:
        """
        Representation of a principal.
        """
        return pulumi.get(self, "target_principal")


class AwaitableGetPrincipalEntitlementsResult(GetPrincipalEntitlementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrincipalEntitlementsResult(
            datas=self.datas,
            id=self.id,
            parent=self.parent,
            target_principal=self.target_principal)


def get_principal_entitlements(datas: Optional[Sequence[Union['GetPrincipalEntitlementsDataArgs', 'GetPrincipalEntitlementsDataArgsDict']]] = None,
                               parent: Optional[Union['GetPrincipalEntitlementsParentArgs', 'GetPrincipalEntitlementsParentArgsDict']] = None,
                               target_principal: Optional[Union['GetPrincipalEntitlementsTargetPrincipalArgs', 'GetPrincipalEntitlementsTargetPrincipalArgsDict']] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrincipalEntitlementsResult:
    """
    Get the entitlements for a user and resource after evaluating all grants.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_principal_entitlements(parent={
            "external_id": "<resource_id>",
            "type": "<resource_type>",
        },
        target_principal={
            "external_id": "<principal_id>",
            "type": "<principal_type>",
        })
    ```

    ## Required:

    - `external_id` (String) The Okta user's email address.
    - `type` (String) The Okta user id.

    <a id="nestedblock--target_principal"></a>
    ### Nested Schema for `target_principal`
    ## Required:

    - `external_id` (String) The Okta user id.
    - `type` (String) The type of principal. Enum: `OKTA_USER`.

    <a id="nestedblock--data"></a>
    ### Nested Schema for `data`
    ## Required:

    - `parent` (Object) Representation of a resource. (see below for nested schema)
    - `target_principal` (Object) Representation of a principal. (see below for nested schema)

    ## Optional:

    - `data_type` (String) The data type of the entitlement property. Enum: `array`, `string`.
    - `description` (String) The Okta user id.
    - `external_value` (String) The type of principal. Enum: `OKTA_USER`.
    - `id` (String) The unique identifier of the entitlement.
    - `multi_value` (Boolean) Indicates if the entitlement is multi-valued.
    - `name` (String) The name of the entitlement.
    - `parent_resource_orn` (String) The Okta app instance, in ORN format.
    - `required` (Boolean) Indicates if the entitlement is required.
    - `target_principal_orn` (String) The Okta user id, in ORN format.
    - `values` (List of Objects) The values of the entitlement. (see below for nested schema)

    <a id="nestedblock--values"></a>
    ### Nested Schema for `values`
    - `description` (String) The description of the value.
    - `external_id` (String) The external ID of the value.
    - `external_value` (String) The value of an entitlement property value.
    - `id` (String) The unique identifier of the value.
    - `name` (String) The name of the value.


    :param Sequence[Union['GetPrincipalEntitlementsDataArgs', 'GetPrincipalEntitlementsDataArgsDict']] datas: Principal entitlements list.
    :param Union['GetPrincipalEntitlementsParentArgs', 'GetPrincipalEntitlementsParentArgsDict'] parent: Representation of a resource.
    :param Union['GetPrincipalEntitlementsTargetPrincipalArgs', 'GetPrincipalEntitlementsTargetPrincipalArgsDict'] target_principal: Representation of a principal.
    """
    __args__ = dict()
    __args__['datas'] = datas
    __args__['parent'] = parent
    __args__['targetPrincipal'] = target_principal
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getPrincipalEntitlements:getPrincipalEntitlements', __args__, opts=opts, typ=GetPrincipalEntitlementsResult).value

    return AwaitableGetPrincipalEntitlementsResult(
        datas=pulumi.get(__ret__, 'datas'),
        id=pulumi.get(__ret__, 'id'),
        parent=pulumi.get(__ret__, 'parent'),
        target_principal=pulumi.get(__ret__, 'target_principal'))
def get_principal_entitlements_output(datas: Optional[pulumi.Input[Optional[Sequence[Union['GetPrincipalEntitlementsDataArgs', 'GetPrincipalEntitlementsDataArgsDict']]]]] = None,
                                      parent: Optional[pulumi.Input[Optional[Union['GetPrincipalEntitlementsParentArgs', 'GetPrincipalEntitlementsParentArgsDict']]]] = None,
                                      target_principal: Optional[pulumi.Input[Optional[Union['GetPrincipalEntitlementsTargetPrincipalArgs', 'GetPrincipalEntitlementsTargetPrincipalArgsDict']]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrincipalEntitlementsResult]:
    """
    Get the entitlements for a user and resource after evaluating all grants.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_principal_entitlements(parent={
            "external_id": "<resource_id>",
            "type": "<resource_type>",
        },
        target_principal={
            "external_id": "<principal_id>",
            "type": "<principal_type>",
        })
    ```

    ## Required:

    - `external_id` (String) The Okta user's email address.
    - `type` (String) The Okta user id.

    <a id="nestedblock--target_principal"></a>
    ### Nested Schema for `target_principal`
    ## Required:

    - `external_id` (String) The Okta user id.
    - `type` (String) The type of principal. Enum: `OKTA_USER`.

    <a id="nestedblock--data"></a>
    ### Nested Schema for `data`
    ## Required:

    - `parent` (Object) Representation of a resource. (see below for nested schema)
    - `target_principal` (Object) Representation of a principal. (see below for nested schema)

    ## Optional:

    - `data_type` (String) The data type of the entitlement property. Enum: `array`, `string`.
    - `description` (String) The Okta user id.
    - `external_value` (String) The type of principal. Enum: `OKTA_USER`.
    - `id` (String) The unique identifier of the entitlement.
    - `multi_value` (Boolean) Indicates if the entitlement is multi-valued.
    - `name` (String) The name of the entitlement.
    - `parent_resource_orn` (String) The Okta app instance, in ORN format.
    - `required` (Boolean) Indicates if the entitlement is required.
    - `target_principal_orn` (String) The Okta user id, in ORN format.
    - `values` (List of Objects) The values of the entitlement. (see below for nested schema)

    <a id="nestedblock--values"></a>
    ### Nested Schema for `values`
    - `description` (String) The description of the value.
    - `external_id` (String) The external ID of the value.
    - `external_value` (String) The value of an entitlement property value.
    - `id` (String) The unique identifier of the value.
    - `name` (String) The name of the value.


    :param Sequence[Union['GetPrincipalEntitlementsDataArgs', 'GetPrincipalEntitlementsDataArgsDict']] datas: Principal entitlements list.
    :param Union['GetPrincipalEntitlementsParentArgs', 'GetPrincipalEntitlementsParentArgsDict'] parent: Representation of a resource.
    :param Union['GetPrincipalEntitlementsTargetPrincipalArgs', 'GetPrincipalEntitlementsTargetPrincipalArgsDict'] target_principal: Representation of a principal.
    """
    __args__ = dict()
    __args__['datas'] = datas
    __args__['parent'] = parent
    __args__['targetPrincipal'] = target_principal
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getPrincipalEntitlements:getPrincipalEntitlements', __args__, opts=opts, typ=GetPrincipalEntitlementsResult)
    return __ret__.apply(lambda __response__: GetPrincipalEntitlementsResult(
        datas=pulumi.get(__response__, 'datas'),
        id=pulumi.get(__response__, 'id'),
        parent=pulumi.get(__response__, 'parent'),
        target_principal=pulumi.get(__response__, 'target_principal')))
