# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPrincipalRateLimitsResult',
    'AwaitableGetPrincipalRateLimitsResult',
    'get_principal_rate_limits',
    'get_principal_rate_limits_output',
]

@pulumi.output_type
class GetPrincipalRateLimitsResult:
    """
    A collection of values returned by getPrincipalRateLimits.
    """
    def __init__(__self__, created_by=None, created_date=None, default_concurrency_percentage=None, default_percentage=None, id=None, last_update=None, last_updated_by=None, org_id=None, principal_id=None, principal_type=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if default_concurrency_percentage and not isinstance(default_concurrency_percentage, int):
            raise TypeError("Expected argument 'default_concurrency_percentage' to be a int")
        pulumi.set(__self__, "default_concurrency_percentage", default_concurrency_percentage)
        if default_percentage and not isinstance(default_percentage, int):
            raise TypeError("Expected argument 'default_percentage' to be a int")
        pulumi.set(__self__, "default_percentage", default_percentage)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_update and not isinstance(last_update, str):
            raise TypeError("Expected argument 'last_update' to be a str")
        pulumi.set(__self__, "last_update", last_update)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if principal_id and not isinstance(principal_id, str):
            raise TypeError("Expected argument 'principal_id' to be a str")
        pulumi.set(__self__, "principal_id", principal_id)
        if principal_type and not isinstance(principal_type, str):
            raise TypeError("Expected argument 'principal_type' to be a str")
        pulumi.set(__self__, "principal_type", principal_type)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The ID of the user who created the principal rate limit.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        The date and time when the principal rate limit was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="defaultConcurrencyPercentage")
    def default_concurrency_percentage(self) -> _builtins.int:
        """
        The default concurrency percentage for the principal rate limit.
        """
        return pulumi.get(self, "default_concurrency_percentage")

    @_builtins.property
    @pulumi.getter(name="defaultPercentage")
    def default_percentage(self) -> _builtins.int:
        """
        The default percentage for the principal rate limit.
        """
        return pulumi.get(self, "default_percentage")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the principle rate limit entity.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> _builtins.str:
        return pulumi.get(self, "last_update")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The ID of the user who last updated the principal rate limit.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        The unique identifier of the Okta organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        The type of principal, either an API token or an OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_type")


class AwaitableGetPrincipalRateLimitsResult(GetPrincipalRateLimitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrincipalRateLimitsResult(
            created_by=self.created_by,
            created_date=self.created_date,
            default_concurrency_percentage=self.default_concurrency_percentage,
            default_percentage=self.default_percentage,
            id=self.id,
            last_update=self.last_update,
            last_updated_by=self.last_updated_by,
            org_id=self.org_id,
            principal_id=self.principal_id,
            principal_type=self.principal_type)


def get_principal_rate_limits(id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrincipalRateLimitsResult:
    """
    Get the entitlements for a user and resource after evaluating all grants.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_principal_rate_limits(id="<principal_rate_limit_id>")
    ```


    :param _builtins.str id: The unique identifier of the principle rate limit entity.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getPrincipalRateLimits:getPrincipalRateLimits', __args__, opts=opts, typ=GetPrincipalRateLimitsResult).value

    return AwaitableGetPrincipalRateLimitsResult(
        created_by=pulumi.get(__ret__, 'created_by'),
        created_date=pulumi.get(__ret__, 'created_date'),
        default_concurrency_percentage=pulumi.get(__ret__, 'default_concurrency_percentage'),
        default_percentage=pulumi.get(__ret__, 'default_percentage'),
        id=pulumi.get(__ret__, 'id'),
        last_update=pulumi.get(__ret__, 'last_update'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        org_id=pulumi.get(__ret__, 'org_id'),
        principal_id=pulumi.get(__ret__, 'principal_id'),
        principal_type=pulumi.get(__ret__, 'principal_type'))
def get_principal_rate_limits_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrincipalRateLimitsResult]:
    """
    Get the entitlements for a user and resource after evaluating all grants.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_principal_rate_limits(id="<principal_rate_limit_id>")
    ```


    :param _builtins.str id: The unique identifier of the principle rate limit entity.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getPrincipalRateLimits:getPrincipalRateLimits', __args__, opts=opts, typ=GetPrincipalRateLimitsResult)
    return __ret__.apply(lambda __response__: GetPrincipalRateLimitsResult(
        created_by=pulumi.get(__response__, 'created_by'),
        created_date=pulumi.get(__response__, 'created_date'),
        default_concurrency_percentage=pulumi.get(__response__, 'default_concurrency_percentage'),
        default_percentage=pulumi.get(__response__, 'default_percentage'),
        id=pulumi.get(__response__, 'id'),
        last_update=pulumi.get(__response__, 'last_update'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        org_id=pulumi.get(__response__, 'org_id'),
        principal_id=pulumi.get(__response__, 'principal_id'),
        principal_type=pulumi.get(__response__, 'principal_type')))
