# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRequestConditionResult',
    'AwaitableGetRequestConditionResult',
    'get_request_condition',
    'get_request_condition_output',
]

@pulumi.output_type
class GetRequestConditionResult:
    """
    A collection of values returned by getRequestCondition.
    """
    def __init__(__self__, access_scope_settings=None, created=None, created_by=None, id=None, last_updated=None, last_updated_by=None, name=None, priority=None, requester_settings=None, resource_id=None, status=None):
        if access_scope_settings and not isinstance(access_scope_settings, dict):
            raise TypeError("Expected argument 'access_scope_settings' to be a dict")
        pulumi.set(__self__, "access_scope_settings", access_scope_settings)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if requester_settings and not isinstance(requester_settings, dict):
            raise TypeError("Expected argument 'requester_settings' to be a dict")
        pulumi.set(__self__, "requester_settings", requester_settings)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessScopeSettings")
    def access_scope_settings(self) -> Optional['outputs.GetRequestConditionAccessScopeSettingsResult']:
        return pulumi.get(self, "access_scope_settings")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the request condition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the request condition. Lower numbers indicate higher priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="requesterSettings")
    def requester_settings(self) -> Optional['outputs.GetRequestConditionRequesterSettingsResult']:
        return pulumi.get(self, "requester_settings")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status indicates if this condition is active or not. Default status is INACTIVE. Enum: `ACTIVE`, `INACTIVE`, `DELETED`, `INVALID`.
        """
        return pulumi.get(self, "status")


class AwaitableGetRequestConditionResult(GetRequestConditionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRequestConditionResult(
            access_scope_settings=self.access_scope_settings,
            created=self.created,
            created_by=self.created_by,
            id=self.id,
            last_updated=self.last_updated,
            last_updated_by=self.last_updated_by,
            name=self.name,
            priority=self.priority,
            requester_settings=self.requester_settings,
            resource_id=self.resource_id,
            status=self.status)


def get_request_condition(access_scope_settings: Optional[Union['GetRequestConditionAccessScopeSettingsArgs', 'GetRequestConditionAccessScopeSettingsArgsDict']] = None,
                          id: Optional[_builtins.str] = None,
                          requester_settings: Optional[Union['GetRequestConditionRequesterSettingsArgs', 'GetRequestConditionRequesterSettingsArgsDict']] = None,
                          resource_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRequestConditionResult:
    """
    Retrieves a resource request condition

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_condition(id="<request_condition_id>",
        resource_id="<resource_id>")
    ```


    :param _builtins.str id: Request condition id.
    :param _builtins.str resource_id: The id of the resource in Okta ID format.
    """
    __args__ = dict()
    __args__['accessScopeSettings'] = access_scope_settings
    __args__['id'] = id
    __args__['requesterSettings'] = requester_settings
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getRequestCondition:getRequestCondition', __args__, opts=opts, typ=GetRequestConditionResult).value

    return AwaitableGetRequestConditionResult(
        access_scope_settings=pulumi.get(__ret__, 'access_scope_settings'),
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        name=pulumi.get(__ret__, 'name'),
        priority=pulumi.get(__ret__, 'priority'),
        requester_settings=pulumi.get(__ret__, 'requester_settings'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        status=pulumi.get(__ret__, 'status'))
def get_request_condition_output(access_scope_settings: Optional[pulumi.Input[Optional[Union['GetRequestConditionAccessScopeSettingsArgs', 'GetRequestConditionAccessScopeSettingsArgsDict']]]] = None,
                                 id: Optional[pulumi.Input[_builtins.str]] = None,
                                 requester_settings: Optional[pulumi.Input[Optional[Union['GetRequestConditionRequesterSettingsArgs', 'GetRequestConditionRequesterSettingsArgsDict']]]] = None,
                                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRequestConditionResult]:
    """
    Retrieves a resource request condition

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_condition(id="<request_condition_id>",
        resource_id="<resource_id>")
    ```


    :param _builtins.str id: Request condition id.
    :param _builtins.str resource_id: The id of the resource in Okta ID format.
    """
    __args__ = dict()
    __args__['accessScopeSettings'] = access_scope_settings
    __args__['id'] = id
    __args__['requesterSettings'] = requester_settings
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getRequestCondition:getRequestCondition', __args__, opts=opts, typ=GetRequestConditionResult)
    return __ret__.apply(lambda __response__: GetRequestConditionResult(
        access_scope_settings=pulumi.get(__response__, 'access_scope_settings'),
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        name=pulumi.get(__response__, 'name'),
        priority=pulumi.get(__response__, 'priority'),
        requester_settings=pulumi.get(__response__, 'requester_settings'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        status=pulumi.get(__response__, 'status')))
