# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRequestSequenceResult',
    'AwaitableGetRequestSequenceResult',
    'get_request_sequence',
    'get_request_sequence_output',
]

@pulumi.output_type
class GetRequestSequenceResult:
    """
    A collection of values returned by getRequestSequence.
    """
    def __init__(__self__, compatible_resource_types=None, description=None, id=None, link=None, name=None, resource_id=None):
        if compatible_resource_types and not isinstance(compatible_resource_types, list):
            raise TypeError("Expected argument 'compatible_resource_types' to be a list")
        pulumi.set(__self__, "compatible_resource_types", compatible_resource_types)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link and not isinstance(link, str):
            raise TypeError("Expected argument 'link' to be a str")
        pulumi.set(__self__, "link", link)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="compatibleResourceTypes")
    def compatible_resource_types(self) -> Sequence[_builtins.str]:
        """
        Enum: `APP`, `GROUP`.
        """
        return pulumi.get(self, "compatible_resource_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the sequence.Must be of 24 characters length.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def link(self) -> _builtins.str:
        """
        Link to edit the request sequence.
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")


class AwaitableGetRequestSequenceResult(GetRequestSequenceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRequestSequenceResult(
            compatible_resource_types=self.compatible_resource_types,
            description=self.description,
            id=self.id,
            link=self.link,
            name=self.name,
            resource_id=self.resource_id)


def get_request_sequence(id: Optional[_builtins.str] = None,
                         resource_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRequestSequenceResult:
    """
    Retrieves a access request sequence referenced by the specified resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_sequence(id="<sequence_id>",
        resource_id="<resource_id>")
    ```


    :param _builtins.str id: The id of the sequence.Must be of 24 characters length.
    :param _builtins.str resource_id: The id of the resource in Okta ID format.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getRequestSequence:getRequestSequence', __args__, opts=opts, typ=GetRequestSequenceResult).value

    return AwaitableGetRequestSequenceResult(
        compatible_resource_types=pulumi.get(__ret__, 'compatible_resource_types'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        link=pulumi.get(__ret__, 'link'),
        name=pulumi.get(__ret__, 'name'),
        resource_id=pulumi.get(__ret__, 'resource_id'))
def get_request_sequence_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRequestSequenceResult]:
    """
    Retrieves a access request sequence referenced by the specified resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_sequence(id="<sequence_id>",
        resource_id="<resource_id>")
    ```


    :param _builtins.str id: The id of the sequence.Must be of 24 characters length.
    :param _builtins.str resource_id: The id of the resource in Okta ID format.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getRequestSequence:getRequestSequence', __args__, opts=opts, typ=GetRequestSequenceResult)
    return __ret__.apply(lambda __response__: GetRequestSequenceResult(
        compatible_resource_types=pulumi.get(__response__, 'compatible_resource_types'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        link=pulumi.get(__response__, 'link'),
        name=pulumi.get(__response__, 'name'),
        resource_id=pulumi.get(__response__, 'resource_id')))
