# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRequestSettingResourceResult',
    'AwaitableGetRequestSettingResourceResult',
    'get_request_setting_resource',
    'get_request_setting_resource_output',
]

@pulumi.output_type
class GetRequestSettingResourceResult:
    """
    A collection of values returned by getRequestSettingResource.
    """
    def __init__(__self__, id=None, request_on_behalf_of_settings=None, risk_settings=None, valid_access_duration_settings=None, valid_access_scope_settings=None, valid_requester_settings=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if request_on_behalf_of_settings and not isinstance(request_on_behalf_of_settings, dict):
            raise TypeError("Expected argument 'request_on_behalf_of_settings' to be a dict")
        pulumi.set(__self__, "request_on_behalf_of_settings", request_on_behalf_of_settings)
        if risk_settings and not isinstance(risk_settings, dict):
            raise TypeError("Expected argument 'risk_settings' to be a dict")
        pulumi.set(__self__, "risk_settings", risk_settings)
        if valid_access_duration_settings and not isinstance(valid_access_duration_settings, dict):
            raise TypeError("Expected argument 'valid_access_duration_settings' to be a dict")
        pulumi.set(__self__, "valid_access_duration_settings", valid_access_duration_settings)
        if valid_access_scope_settings and not isinstance(valid_access_scope_settings, list):
            raise TypeError("Expected argument 'valid_access_scope_settings' to be a list")
        pulumi.set(__self__, "valid_access_scope_settings", valid_access_scope_settings)
        if valid_requester_settings and not isinstance(valid_requester_settings, list):
            raise TypeError("Expected argument 'valid_requester_settings' to be a list")
        pulumi.set(__self__, "valid_requester_settings", valid_requester_settings)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID of the request settings to retrieve. This is the unique identifier for the resource in Okta.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="requestOnBehalfOfSettings")
    def request_on_behalf_of_settings(self) -> Optional['outputs.GetRequestSettingResourceRequestOnBehalfOfSettingsResult']:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "request_on_behalf_of_settings")

    @_builtins.property
    @pulumi.getter(name="riskSettings")
    def risk_settings(self) -> Optional['outputs.GetRequestSettingResourceRiskSettingsResult']:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "risk_settings")

    @_builtins.property
    @pulumi.getter(name="validAccessDurationSettings")
    def valid_access_duration_settings(self) -> Optional['outputs.GetRequestSettingResourceValidAccessDurationSettingsResult']:
        """
        Specifies if and for whom a requester may request the resource for.
        """
        return pulumi.get(self, "valid_access_duration_settings")

    @_builtins.property
    @pulumi.getter(name="validAccessScopeSettings")
    def valid_access_scope_settings(self) -> Optional[Sequence['outputs.GetRequestSettingResourceValidAccessScopeSettingResult']]:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "valid_access_scope_settings")

    @_builtins.property
    @pulumi.getter(name="validRequesterSettings")
    def valid_requester_settings(self) -> Optional[Sequence['outputs.GetRequestSettingResourceValidRequesterSettingResult']]:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "valid_requester_settings")


class AwaitableGetRequestSettingResourceResult(GetRequestSettingResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRequestSettingResourceResult(
            id=self.id,
            request_on_behalf_of_settings=self.request_on_behalf_of_settings,
            risk_settings=self.risk_settings,
            valid_access_duration_settings=self.valid_access_duration_settings,
            valid_access_scope_settings=self.valid_access_scope_settings,
            valid_requester_settings=self.valid_requester_settings)


def get_request_setting_resource(id: Optional[_builtins.str] = None,
                                 request_on_behalf_of_settings: Optional[Union['GetRequestSettingResourceRequestOnBehalfOfSettingsArgs', 'GetRequestSettingResourceRequestOnBehalfOfSettingsArgsDict']] = None,
                                 risk_settings: Optional[Union['GetRequestSettingResourceRiskSettingsArgs', 'GetRequestSettingResourceRiskSettingsArgsDict']] = None,
                                 valid_access_duration_settings: Optional[Union['GetRequestSettingResourceValidAccessDurationSettingsArgs', 'GetRequestSettingResourceValidAccessDurationSettingsArgsDict']] = None,
                                 valid_access_scope_settings: Optional[Sequence[Union['GetRequestSettingResourceValidAccessScopeSettingArgs', 'GetRequestSettingResourceValidAccessScopeSettingArgsDict']]] = None,
                                 valid_requester_settings: Optional[Sequence[Union['GetRequestSettingResourceValidRequesterSettingArgs', 'GetRequestSettingResourceValidRequesterSettingArgsDict']]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRequestSettingResourceResult:
    """
    Retrieves the request settings for a resource.

    ## Example Usage


    :param _builtins.str id: The resource ID of the request settings to retrieve. This is the unique identifier for the resource in Okta.
    :param Union['GetRequestSettingResourceRequestOnBehalfOfSettingsArgs', 'GetRequestSettingResourceRequestOnBehalfOfSettingsArgsDict'] request_on_behalf_of_settings: Risk settings for the resource.
    :param Union['GetRequestSettingResourceRiskSettingsArgs', 'GetRequestSettingResourceRiskSettingsArgsDict'] risk_settings: Risk settings for the resource.
    :param Union['GetRequestSettingResourceValidAccessDurationSettingsArgs', 'GetRequestSettingResourceValidAccessDurationSettingsArgsDict'] valid_access_duration_settings: Specifies if and for whom a requester may request the resource for.
    :param Sequence[Union['GetRequestSettingResourceValidAccessScopeSettingArgs', 'GetRequestSettingResourceValidAccessScopeSettingArgsDict']] valid_access_scope_settings: Risk settings for the resource.
    :param Sequence[Union['GetRequestSettingResourceValidRequesterSettingArgs', 'GetRequestSettingResourceValidRequesterSettingArgsDict']] valid_requester_settings: Risk settings for the resource.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['requestOnBehalfOfSettings'] = request_on_behalf_of_settings
    __args__['riskSettings'] = risk_settings
    __args__['validAccessDurationSettings'] = valid_access_duration_settings
    __args__['validAccessScopeSettings'] = valid_access_scope_settings
    __args__['validRequesterSettings'] = valid_requester_settings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getRequestSettingResource:getRequestSettingResource', __args__, opts=opts, typ=GetRequestSettingResourceResult).value

    return AwaitableGetRequestSettingResourceResult(
        id=pulumi.get(__ret__, 'id'),
        request_on_behalf_of_settings=pulumi.get(__ret__, 'request_on_behalf_of_settings'),
        risk_settings=pulumi.get(__ret__, 'risk_settings'),
        valid_access_duration_settings=pulumi.get(__ret__, 'valid_access_duration_settings'),
        valid_access_scope_settings=pulumi.get(__ret__, 'valid_access_scope_settings'),
        valid_requester_settings=pulumi.get(__ret__, 'valid_requester_settings'))
def get_request_setting_resource_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                        request_on_behalf_of_settings: Optional[pulumi.Input[Optional[Union['GetRequestSettingResourceRequestOnBehalfOfSettingsArgs', 'GetRequestSettingResourceRequestOnBehalfOfSettingsArgsDict']]]] = None,
                                        risk_settings: Optional[pulumi.Input[Optional[Union['GetRequestSettingResourceRiskSettingsArgs', 'GetRequestSettingResourceRiskSettingsArgsDict']]]] = None,
                                        valid_access_duration_settings: Optional[pulumi.Input[Optional[Union['GetRequestSettingResourceValidAccessDurationSettingsArgs', 'GetRequestSettingResourceValidAccessDurationSettingsArgsDict']]]] = None,
                                        valid_access_scope_settings: Optional[pulumi.Input[Optional[Sequence[Union['GetRequestSettingResourceValidAccessScopeSettingArgs', 'GetRequestSettingResourceValidAccessScopeSettingArgsDict']]]]] = None,
                                        valid_requester_settings: Optional[pulumi.Input[Optional[Sequence[Union['GetRequestSettingResourceValidRequesterSettingArgs', 'GetRequestSettingResourceValidRequesterSettingArgsDict']]]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRequestSettingResourceResult]:
    """
    Retrieves the request settings for a resource.

    ## Example Usage


    :param _builtins.str id: The resource ID of the request settings to retrieve. This is the unique identifier for the resource in Okta.
    :param Union['GetRequestSettingResourceRequestOnBehalfOfSettingsArgs', 'GetRequestSettingResourceRequestOnBehalfOfSettingsArgsDict'] request_on_behalf_of_settings: Risk settings for the resource.
    :param Union['GetRequestSettingResourceRiskSettingsArgs', 'GetRequestSettingResourceRiskSettingsArgsDict'] risk_settings: Risk settings for the resource.
    :param Union['GetRequestSettingResourceValidAccessDurationSettingsArgs', 'GetRequestSettingResourceValidAccessDurationSettingsArgsDict'] valid_access_duration_settings: Specifies if and for whom a requester may request the resource for.
    :param Sequence[Union['GetRequestSettingResourceValidAccessScopeSettingArgs', 'GetRequestSettingResourceValidAccessScopeSettingArgsDict']] valid_access_scope_settings: Risk settings for the resource.
    :param Sequence[Union['GetRequestSettingResourceValidRequesterSettingArgs', 'GetRequestSettingResourceValidRequesterSettingArgsDict']] valid_requester_settings: Risk settings for the resource.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['requestOnBehalfOfSettings'] = request_on_behalf_of_settings
    __args__['riskSettings'] = risk_settings
    __args__['validAccessDurationSettings'] = valid_access_duration_settings
    __args__['validAccessScopeSettings'] = valid_access_scope_settings
    __args__['validRequesterSettings'] = valid_requester_settings
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getRequestSettingResource:getRequestSettingResource', __args__, opts=opts, typ=GetRequestSettingResourceResult)
    return __ret__.apply(lambda __response__: GetRequestSettingResourceResult(
        id=pulumi.get(__response__, 'id'),
        request_on_behalf_of_settings=pulumi.get(__response__, 'request_on_behalf_of_settings'),
        risk_settings=pulumi.get(__response__, 'risk_settings'),
        valid_access_duration_settings=pulumi.get(__response__, 'valid_access_duration_settings'),
        valid_access_scope_settings=pulumi.get(__response__, 'valid_access_scope_settings'),
        valid_requester_settings=pulumi.get(__response__, 'valid_requester_settings')))
