# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRequestV2Result',
    'AwaitableGetRequestV2Result',
    'get_request_v2',
    'get_request_v2_output',
]

@pulumi.output_type
class GetRequestV2Result:
    """
    A collection of values returned by getRequestV2.
    """
    def __init__(__self__, created=None, created_by=None, id=None, last_updated=None, last_updated_by=None, requested=None, requested_by=None, requested_for=None, status=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if requested and not isinstance(requested, dict):
            raise TypeError("Expected argument 'requested' to be a dict")
        pulumi.set(__self__, "requested", requested)
        if requested_by and not isinstance(requested_by, dict):
            raise TypeError("Expected argument 'requested_by' to be a dict")
        pulumi.set(__self__, "requested_by", requested_by)
        if requested_for and not isinstance(requested_for, dict):
            raise TypeError("Expected argument 'requested_for' to be a dict")
        pulumi.set(__self__, "requested_for", requested_for)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the request.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def requested(self) -> Optional['outputs.GetRequestV2RequestedResult']:
        """
        A representation of a resource that can be requested for access.
        """
        return pulumi.get(self, "requested")

    @_builtins.property
    @pulumi.getter(name="requestedBy")
    def requested_by(self) -> Optional['outputs.GetRequestV2RequestedByResult']:
        """
        A representation of a principal.
        """
        return pulumi.get(self, "requested_by")

    @_builtins.property
    @pulumi.getter(name="requestedFor")
    def requested_for(self) -> Optional['outputs.GetRequestV2RequestedForResult']:
        """
        A representation of a principal.
        """
        return pulumi.get(self, "requested_for")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the request.
        """
        return pulumi.get(self, "status")


class AwaitableGetRequestV2Result(GetRequestV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRequestV2Result(
            created=self.created,
            created_by=self.created_by,
            id=self.id,
            last_updated=self.last_updated,
            last_updated_by=self.last_updated_by,
            requested=self.requested,
            requested_by=self.requested_by,
            requested_for=self.requested_for,
            status=self.status)


def get_request_v2(id: Optional[_builtins.str] = None,
                   requested: Optional[Union['GetRequestV2RequestedArgs', 'GetRequestV2RequestedArgsDict']] = None,
                   requested_by: Optional[Union['GetRequestV2RequestedByArgs', 'GetRequestV2RequestedByArgsDict']] = None,
                   requested_for: Optional[Union['GetRequestV2RequestedForArgs', 'GetRequestV2RequestedForArgsDict']] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRequestV2Result:
    """
    Retrieves the full representation of a specific request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_v2(id="<request_id>")
    ```


    :param _builtins.str id: The ID of the request.
    :param Union['GetRequestV2RequestedArgs', 'GetRequestV2RequestedArgsDict'] requested: A representation of a resource that can be requested for access.
    :param Union['GetRequestV2RequestedByArgs', 'GetRequestV2RequestedByArgsDict'] requested_by: A representation of a principal.
    :param Union['GetRequestV2RequestedForArgs', 'GetRequestV2RequestedForArgsDict'] requested_for: A representation of a principal.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['requested'] = requested
    __args__['requestedBy'] = requested_by
    __args__['requestedFor'] = requested_for
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getRequestV2:getRequestV2', __args__, opts=opts, typ=GetRequestV2Result).value

    return AwaitableGetRequestV2Result(
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        requested=pulumi.get(__ret__, 'requested'),
        requested_by=pulumi.get(__ret__, 'requested_by'),
        requested_for=pulumi.get(__ret__, 'requested_for'),
        status=pulumi.get(__ret__, 'status'))
def get_request_v2_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                          requested: Optional[pulumi.Input[Optional[Union['GetRequestV2RequestedArgs', 'GetRequestV2RequestedArgsDict']]]] = None,
                          requested_by: Optional[pulumi.Input[Optional[Union['GetRequestV2RequestedByArgs', 'GetRequestV2RequestedByArgsDict']]]] = None,
                          requested_for: Optional[pulumi.Input[Optional[Union['GetRequestV2RequestedForArgs', 'GetRequestV2RequestedForArgsDict']]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRequestV2Result]:
    """
    Retrieves the full representation of a specific request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_request_v2(id="<request_id>")
    ```


    :param _builtins.str id: The ID of the request.
    :param Union['GetRequestV2RequestedArgs', 'GetRequestV2RequestedArgsDict'] requested: A representation of a resource that can be requested for access.
    :param Union['GetRequestV2RequestedByArgs', 'GetRequestV2RequestedByArgsDict'] requested_by: A representation of a principal.
    :param Union['GetRequestV2RequestedForArgs', 'GetRequestV2RequestedForArgsDict'] requested_for: A representation of a principal.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['requested'] = requested
    __args__['requestedBy'] = requested_by
    __args__['requestedFor'] = requested_for
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getRequestV2:getRequestV2', __args__, opts=opts, typ=GetRequestV2Result)
    return __ret__.apply(lambda __response__: GetRequestV2Result(
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        requested=pulumi.get(__response__, 'requested'),
        requested_by=pulumi.get(__response__, 'requested_by'),
        requested_for=pulumi.get(__response__, 'requested_for'),
        status=pulumi.get(__response__, 'status')))
