# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReviewResult',
    'AwaitableGetReviewResult',
    'get_review',
    'get_review_output',
]

@pulumi.output_type
class GetReviewResult:
    """
    A collection of values returned by getReview.
    """
    def __init__(__self__, all_reviewer_levels=None, campaign_id=None, created=None, created_by=None, current_reviewer_level=None, decided=None, decision=None, entitlement_bundle=None, entitlement_value=None, id=None, last_updated=None, last_updated_by=None, links=None, note=None, principal_profile=None, remediation_status=None, resource_id=None, reviewer_profile=None, reviewer_type=None):
        if all_reviewer_levels and not isinstance(all_reviewer_levels, list):
            raise TypeError("Expected argument 'all_reviewer_levels' to be a list")
        pulumi.set(__self__, "all_reviewer_levels", all_reviewer_levels)
        if campaign_id and not isinstance(campaign_id, str):
            raise TypeError("Expected argument 'campaign_id' to be a str")
        pulumi.set(__self__, "campaign_id", campaign_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if current_reviewer_level and not isinstance(current_reviewer_level, str):
            raise TypeError("Expected argument 'current_reviewer_level' to be a str")
        pulumi.set(__self__, "current_reviewer_level", current_reviewer_level)
        if decided and not isinstance(decided, str):
            raise TypeError("Expected argument 'decided' to be a str")
        pulumi.set(__self__, "decided", decided)
        if decision and not isinstance(decision, str):
            raise TypeError("Expected argument 'decision' to be a str")
        pulumi.set(__self__, "decision", decision)
        if entitlement_bundle and not isinstance(entitlement_bundle, dict):
            raise TypeError("Expected argument 'entitlement_bundle' to be a dict")
        pulumi.set(__self__, "entitlement_bundle", entitlement_bundle)
        if entitlement_value and not isinstance(entitlement_value, dict):
            raise TypeError("Expected argument 'entitlement_value' to be a dict")
        pulumi.set(__self__, "entitlement_value", entitlement_value)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if links and not isinstance(links, dict):
            raise TypeError("Expected argument 'links' to be a dict")
        pulumi.set(__self__, "links", links)
        if note and not isinstance(note, dict):
            raise TypeError("Expected argument 'note' to be a dict")
        pulumi.set(__self__, "note", note)
        if principal_profile and not isinstance(principal_profile, dict):
            raise TypeError("Expected argument 'principal_profile' to be a dict")
        pulumi.set(__self__, "principal_profile", principal_profile)
        if remediation_status and not isinstance(remediation_status, str):
            raise TypeError("Expected argument 'remediation_status' to be a str")
        pulumi.set(__self__, "remediation_status", remediation_status)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if reviewer_profile and not isinstance(reviewer_profile, dict):
            raise TypeError("Expected argument 'reviewer_profile' to be a dict")
        pulumi.set(__self__, "reviewer_profile", reviewer_profile)
        if reviewer_type and not isinstance(reviewer_type, str):
            raise TypeError("Expected argument 'reviewer_type' to be a str")
        pulumi.set(__self__, "reviewer_type", reviewer_type)

    @_builtins.property
    @pulumi.getter(name="allReviewerLevels")
    def all_reviewer_levels(self) -> Optional[Sequence['outputs.GetReviewAllReviewerLevelResult']]:
        return pulumi.get(self, "all_reviewer_levels")

    @_builtins.property
    @pulumi.getter(name="campaignId")
    def campaign_id(self) -> _builtins.str:
        """
        ID of the Campaign.
        """
        return pulumi.get(self, "campaign_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The ISO 8601 formatted date and time when the resource was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of user who created the resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="currentReviewerLevel")
    def current_reviewer_level(self) -> _builtins.str:
        """
        Identifies the reviewer level of each reviews during access certification.
        """
        return pulumi.get(self, "current_reviewer_level")

    @_builtins.property
    @pulumi.getter
    def decided(self) -> _builtins.str:
        """
        The ISO 8601 formatted date and time when the object status was decided.
        """
        return pulumi.get(self, "decided")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> _builtins.str:
        """
        The decision taken by the reviewer. Will be `UNASSIGNED` if no decision is made.
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter(name="entitlementBundle")
    def entitlement_bundle(self) -> Optional['outputs.GetReviewEntitlementBundleResult']:
        return pulumi.get(self, "entitlement_bundle")

    @_builtins.property
    @pulumi.getter(name="entitlementValue")
    def entitlement_value(self) -> Optional['outputs.GetReviewEntitlementValueResult']:
        return pulumi.get(self, "entitlement_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The ISO 8601 formatted date and time when the object was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The id of user who last updated the object.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional['outputs.GetReviewLinksResult']:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional['outputs.GetReviewNoteResult']:
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="principalProfile")
    def principal_profile(self) -> Optional['outputs.GetReviewPrincipalProfileResult']:
        """
        A limited set of properties from the user profile who created the review.
        """
        return pulumi.get(self, "principal_profile")

    @_builtins.property
    @pulumi.getter(name="remediationStatus")
    def remediation_status(self) -> _builtins.str:
        """
        Enum: `ERROR`, `MANUAL`, `NONE`, `OPEN`, `SUCCESS`.
        """
        return pulumi.get(self, "remediation_status")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        Resource ID for the Review.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="reviewerProfile")
    def reviewer_profile(self) -> Optional['outputs.GetReviewReviewerProfileResult']:
        return pulumi.get(self, "reviewer_profile")

    @_builtins.property
    @pulumi.getter(name="reviewerType")
    def reviewer_type(self) -> _builtins.str:
        """
        The type of reviewer to which the review is assigned.
        """
        return pulumi.get(self, "reviewer_type")


class AwaitableGetReviewResult(GetReviewResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReviewResult(
            all_reviewer_levels=self.all_reviewer_levels,
            campaign_id=self.campaign_id,
            created=self.created,
            created_by=self.created_by,
            current_reviewer_level=self.current_reviewer_level,
            decided=self.decided,
            decision=self.decision,
            entitlement_bundle=self.entitlement_bundle,
            entitlement_value=self.entitlement_value,
            id=self.id,
            last_updated=self.last_updated,
            last_updated_by=self.last_updated_by,
            links=self.links,
            note=self.note,
            principal_profile=self.principal_profile,
            remediation_status=self.remediation_status,
            resource_id=self.resource_id,
            reviewer_profile=self.reviewer_profile,
            reviewer_type=self.reviewer_type)


def get_review(all_reviewer_levels: Optional[Sequence[Union['GetReviewAllReviewerLevelArgs', 'GetReviewAllReviewerLevelArgsDict']]] = None,
               entitlement_bundle: Optional[Union['GetReviewEntitlementBundleArgs', 'GetReviewEntitlementBundleArgsDict']] = None,
               entitlement_value: Optional[Union['GetReviewEntitlementValueArgs', 'GetReviewEntitlementValueArgsDict']] = None,
               id: Optional[_builtins.str] = None,
               links: Optional[Union['GetReviewLinksArgs', 'GetReviewLinksArgsDict']] = None,
               note: Optional[Union['GetReviewNoteArgs', 'GetReviewNoteArgsDict']] = None,
               principal_profile: Optional[Union['GetReviewPrincipalProfileArgs', 'GetReviewPrincipalProfileArgsDict']] = None,
               reviewer_profile: Optional[Union['GetReviewReviewerProfileArgs', 'GetReviewReviewerProfileArgsDict']] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReviewResult:
    """
    Get the reviews belonging to a campaign

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_review()
    ```

    ## Required:

    - `email` (String) The Okta user's email address.
    - `id` (String) The Okta user id.
    - `status` (String) The status of the principal's profile. Enum: `INACTIVE`, `ACTIVE`.

    ## Optional:

    - `first_name` (String) The Okta user's first name.
    - `lastName` (String) The Okta user's last name
    - `login` (String) The Okta user's login


    :param _builtins.str id: The ID of  review.
    :param Union['GetReviewPrincipalProfileArgs', 'GetReviewPrincipalProfileArgsDict'] principal_profile: A limited set of properties from the user profile who created the review.
    """
    __args__ = dict()
    __args__['allReviewerLevels'] = all_reviewer_levels
    __args__['entitlementBundle'] = entitlement_bundle
    __args__['entitlementValue'] = entitlement_value
    __args__['id'] = id
    __args__['links'] = links
    __args__['note'] = note
    __args__['principalProfile'] = principal_profile
    __args__['reviewerProfile'] = reviewer_profile
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getReview:getReview', __args__, opts=opts, typ=GetReviewResult).value

    return AwaitableGetReviewResult(
        all_reviewer_levels=pulumi.get(__ret__, 'all_reviewer_levels'),
        campaign_id=pulumi.get(__ret__, 'campaign_id'),
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        current_reviewer_level=pulumi.get(__ret__, 'current_reviewer_level'),
        decided=pulumi.get(__ret__, 'decided'),
        decision=pulumi.get(__ret__, 'decision'),
        entitlement_bundle=pulumi.get(__ret__, 'entitlement_bundle'),
        entitlement_value=pulumi.get(__ret__, 'entitlement_value'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        links=pulumi.get(__ret__, 'links'),
        note=pulumi.get(__ret__, 'note'),
        principal_profile=pulumi.get(__ret__, 'principal_profile'),
        remediation_status=pulumi.get(__ret__, 'remediation_status'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        reviewer_profile=pulumi.get(__ret__, 'reviewer_profile'),
        reviewer_type=pulumi.get(__ret__, 'reviewer_type'))
def get_review_output(all_reviewer_levels: Optional[pulumi.Input[Optional[Sequence[Union['GetReviewAllReviewerLevelArgs', 'GetReviewAllReviewerLevelArgsDict']]]]] = None,
                      entitlement_bundle: Optional[pulumi.Input[Optional[Union['GetReviewEntitlementBundleArgs', 'GetReviewEntitlementBundleArgsDict']]]] = None,
                      entitlement_value: Optional[pulumi.Input[Optional[Union['GetReviewEntitlementValueArgs', 'GetReviewEntitlementValueArgsDict']]]] = None,
                      id: Optional[pulumi.Input[_builtins.str]] = None,
                      links: Optional[pulumi.Input[Optional[Union['GetReviewLinksArgs', 'GetReviewLinksArgsDict']]]] = None,
                      note: Optional[pulumi.Input[Optional[Union['GetReviewNoteArgs', 'GetReviewNoteArgsDict']]]] = None,
                      principal_profile: Optional[pulumi.Input[Optional[Union['GetReviewPrincipalProfileArgs', 'GetReviewPrincipalProfileArgsDict']]]] = None,
                      reviewer_profile: Optional[pulumi.Input[Optional[Union['GetReviewReviewerProfileArgs', 'GetReviewReviewerProfileArgsDict']]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReviewResult]:
    """
    Get the reviews belonging to a campaign

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_review()
    ```

    ## Required:

    - `email` (String) The Okta user's email address.
    - `id` (String) The Okta user id.
    - `status` (String) The status of the principal's profile. Enum: `INACTIVE`, `ACTIVE`.

    ## Optional:

    - `first_name` (String) The Okta user's first name.
    - `lastName` (String) The Okta user's last name
    - `login` (String) The Okta user's login


    :param _builtins.str id: The ID of  review.
    :param Union['GetReviewPrincipalProfileArgs', 'GetReviewPrincipalProfileArgsDict'] principal_profile: A limited set of properties from the user profile who created the review.
    """
    __args__ = dict()
    __args__['allReviewerLevels'] = all_reviewer_levels
    __args__['entitlementBundle'] = entitlement_bundle
    __args__['entitlementValue'] = entitlement_value
    __args__['id'] = id
    __args__['links'] = links
    __args__['note'] = note
    __args__['principalProfile'] = principal_profile
    __args__['reviewerProfile'] = reviewer_profile
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getReview:getReview', __args__, opts=opts, typ=GetReviewResult)
    return __ret__.apply(lambda __response__: GetReviewResult(
        all_reviewer_levels=pulumi.get(__response__, 'all_reviewer_levels'),
        campaign_id=pulumi.get(__response__, 'campaign_id'),
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        current_reviewer_level=pulumi.get(__response__, 'current_reviewer_level'),
        decided=pulumi.get(__response__, 'decided'),
        decision=pulumi.get(__response__, 'decision'),
        entitlement_bundle=pulumi.get(__response__, 'entitlement_bundle'),
        entitlement_value=pulumi.get(__response__, 'entitlement_value'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        links=pulumi.get(__response__, 'links'),
        note=pulumi.get(__response__, 'note'),
        principal_profile=pulumi.get(__response__, 'principal_profile'),
        remediation_status=pulumi.get(__response__, 'remediation_status'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        reviewer_profile=pulumi.get(__response__, 'reviewer_profile'),
        reviewer_type=pulumi.get(__response__, 'reviewer_type')))
