# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetThemesResult',
    'AwaitableGetThemesResult',
    'get_themes',
    'get_themes_output',
]

@pulumi.output_type
class GetThemesResult:
    """
    A collection of values returned by getThemes.
    """
    def __init__(__self__, brand_id=None, id=None, themes=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if themes and not isinstance(themes, list):
            raise TypeError("Expected argument 'themes' to be a list")
        pulumi.set(__self__, "themes", themes)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def themes(self) -> Sequence['outputs.GetThemesThemeResult']:
        """
        List of `okta_them` belonging to the brand in the organization
        """
        return pulumi.get(self, "themes")


class AwaitableGetThemesResult(GetThemesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThemesResult(
            brand_id=self.brand_id,
            id=self.id,
            themes=self.themes)


def get_themes(brand_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThemesResult:
    """
    Get Themes of a Brand of an Okta Organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    example = okta.get_themes(brand_id=test.brands[0].id)
    ```


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getThemes:getThemes', __args__, opts=opts, typ=GetThemesResult).value

    return AwaitableGetThemesResult(
        brand_id=pulumi.get(__ret__, 'brand_id'),
        id=pulumi.get(__ret__, 'id'),
        themes=pulumi.get(__ret__, 'themes'))
def get_themes_output(brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetThemesResult]:
    """
    Get Themes of a Brand of an Okta Organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_brands()
    example = okta.get_themes(brand_id=test.brands[0].id)
    ```


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getThemes:getThemes', __args__, opts=opts, typ=GetThemesResult)
    return __ret__.apply(lambda __response__: GetThemesResult(
        brand_id=pulumi.get(__response__, 'brand_id'),
        id=pulumi.get(__response__, 'id'),
        themes=pulumi.get(__response__, 'themes')))
