# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuleResult',
    'AwaitableGetRuleResult',
    'get_rule',
    'get_rule_output',
]

@pulumi.output_type
class GetRuleResult:
    """
    A collection of values returned by getRule.
    """
    def __init__(__self__, expression_type=None, expression_value=None, group_assignments=None, id=None, name=None, status=None, users_excludeds=None):
        if expression_type and not isinstance(expression_type, str):
            raise TypeError("Expected argument 'expression_type' to be a str")
        pulumi.set(__self__, "expression_type", expression_type)
        if expression_value and not isinstance(expression_value, str):
            raise TypeError("Expected argument 'expression_value' to be a str")
        pulumi.set(__self__, "expression_value", expression_value)
        if group_assignments and not isinstance(group_assignments, list):
            raise TypeError("Expected argument 'group_assignments' to be a list")
        pulumi.set(__self__, "group_assignments", group_assignments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users_excludeds and not isinstance(users_excludeds, list):
            raise TypeError("Expected argument 'users_excludeds' to be a list")
        pulumi.set(__self__, "users_excludeds", users_excludeds)

    @_builtins.property
    @pulumi.getter(name="expressionType")
    def expression_type(self) -> _builtins.str:
        """
        The expression type to use to invoke the rule.
        """
        return pulumi.get(self, "expression_type")

    @_builtins.property
    @pulumi.getter(name="expressionValue")
    def expression_value(self) -> _builtins.str:
        """
        The expression value.
        """
        return pulumi.get(self, "expression_value")

    @_builtins.property
    @pulumi.getter(name="groupAssignments")
    def group_assignments(self) -> Sequence[_builtins.str]:
        """
        The list of group ids to assign the users to.
        """
        return pulumi.get(self, "group_assignments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Group Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Group Rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Sequence[_builtins.str]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")


class AwaitableGetRuleResult(GetRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleResult(
            expression_type=self.expression_type,
            expression_value=self.expression_value,
            group_assignments=self.group_assignments,
            id=self.id,
            name=self.name,
            status=self.status,
            users_excludeds=self.users_excludeds)


def get_rule(id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             status: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleResult:
    """
    Get a group rule from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.group.get_rule(id=example["id"])
    ```


    :param _builtins.str id: The ID of the Group Rule.
    :param _builtins.str name: The name of the Group Rule.
    :param _builtins.str status: Default to `ACTIVE`
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:group/getRule:getRule', __args__, opts=opts, typ=GetRuleResult).value

    return AwaitableGetRuleResult(
        expression_type=pulumi.get(__ret__, 'expression_type'),
        expression_value=pulumi.get(__ret__, 'expression_value'),
        group_assignments=pulumi.get(__ret__, 'group_assignments'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        users_excludeds=pulumi.get(__ret__, 'users_excludeds'))
def get_rule_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleResult]:
    """
    Get a group rule from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.group.get_rule(id=example["id"])
    ```


    :param _builtins.str id: The ID of the Group Rule.
    :param _builtins.str name: The name of the Group Rule.
    :param _builtins.str status: Default to `ACTIVE`
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:group/getRule:getRule', __args__, opts=opts, typ=GetRuleResult)
    return __ret__.apply(lambda __response__: GetRuleResult(
        expression_type=pulumi.get(__response__, 'expression_type'),
        expression_value=pulumi.get(__response__, 'expression_value'),
        group_assignments=pulumi.get(__response__, 'group_assignments'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        users_excludeds=pulumi.get(__response__, 'users_excludeds')))
