# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AppGroupAssignmentsGroup',
    'AppSignonPolicyRulePlatformInclude',
    'AppUserSchemaPropertyArrayOneOf',
    'AppUserSchemaPropertyOneOf',
    'CampaignNotificationSettings',
    'CampaignPrincipalScopeSettings',
    'CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope',
    'CampaignRemediationSettings',
    'CampaignRemediationSettingsAutoRemediationSettings',
    'CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly',
    'CampaignResourceSettings',
    'CampaignResourceSettingsExcludedResource',
    'CampaignResourceSettingsTargetResource',
    'CampaignResourceSettingsTargetResourceEntitlement',
    'CampaignResourceSettingsTargetResourceEntitlementBundle',
    'CampaignResourceSettingsTargetResourceEntitlementValue',
    'CampaignReviewerSettings',
    'CampaignReviewerSettingsReviewerLevel',
    'CampaignReviewerSettingsReviewerLevelStartReview',
    'CampaignScheduleSettings',
    'CampaignScheduleSettingsRecurrence',
    'CustomizedSigninPageContentSecurityPolicySetting',
    'CustomizedSigninPageWidgetCustomizations',
    'DomainDnsRecord',
    'EmailDomainDnsValidationRecord',
    'EmailSenderDnsRecord',
    'EndUserMyRequestsRequesterFieldValue',
    'EntitlementBundleEntitlement',
    'EntitlementBundleEntitlementValue',
    'EntitlementBundleTarget',
    'EntitlementParent',
    'EntitlementValue',
    'EventHookHeader',
    'FeatureStage',
    'GroupSchemaPropertyArrayOneOf',
    'GroupSchemaPropertyMasterOverridePriority',
    'GroupSchemaPropertyOneOf',
    'LogStreamSettings',
    'PolicyRuleProfileEnrollmentProfileAttribute',
    'PreviewSigninPageContentSecurityPolicySetting',
    'PreviewSigninPageWidgetCustomizations',
    'RateLimitingUseCaseModeOverrides',
    'RequestConditionAccessDurationSettings',
    'RequestConditionAccessScopeSettings',
    'RequestConditionAccessScopeSettingsId',
    'RequestConditionRequesterSettings',
    'RequestConditionRequesterSettingsId',
    'RequestSettingResourceRequestOnBehalfOfSettings',
    'RequestSettingResourceRequestOnBehalfOfSettingsOnlyFor',
    'RequestSettingResourceRiskSettings',
    'RequestSettingResourceRiskSettingsDefaultSetting',
    'RequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettings',
    'RequestV2Requested',
    'RequestV2RequestedFor',
    'RequestV2RequesterFieldValue',
    'RequestV2RequesterFieldValueValue',
    'TemplateSmsTranslation',
    'UserSchemaPropertyArrayOneOf',
    'UserSchemaPropertyMasterOverridePriority',
    'UserSchemaPropertyOneOf',
    'GetAppsAppResult',
    'GetAppsAppVisibilityResult',
    'GetAppsAppVisibilityHideResult',
    'GetAuthServerClaimsClaimResult',
    'GetBehavioursBehaviorResult',
    'GetBrandsBrandResult',
    'GetCampaignNotificationSettingsResult',
    'GetCampaignPrincipalScopeSettingsResult',
    'GetCampaignPrincipalScopeSettingsPredefinedInactiveUsersScopeResult',
    'GetCampaignRemediationSettingsResult',
    'GetCampaignRemediationSettingsAutoRemediationSettingsResult',
    'GetCampaignRemediationSettingsAutoRemediationSettingsIncludeOnlyResult',
    'GetCampaignResourceSettingsResult',
    'GetCampaignResourceSettingsExcludedResourceResult',
    'GetCampaignResourceSettingsTargetResourceResult',
    'GetCampaignResourceSettingsTargetResourceEntitlementResult',
    'GetCampaignResourceSettingsTargetResourceEntitlementBundleResult',
    'GetCampaignResourceSettingsTargetResourceEntitlementValueResult',
    'GetCampaignReviewerSettingsResult',
    'GetCampaignReviewerSettingsReviewerLevelResult',
    'GetCampaignReviewerSettingsReviewerLevelStartReviewResult',
    'GetCampaignScheduleSettingsResult',
    'GetCampaignScheduleSettingsRecurrenceResult',
    'GetCatalogEntryDefaultCountsResult',
    'GetCatalogEntryDefaultCountsResourceCountsResult',
    'GetCatalogEntryDefaultLinksResult',
    'GetCatalogEntryDefaultLinksSelfResult',
    'GetCatalogEntryUserAccessRequestFieldsDataResult',
    'GetCatalogEntryUserAccessRequestFieldsDataChoiceResult',
    'GetDefaultSigninPageContentSecurityPolicySettingResult',
    'GetDefaultSigninPageWidgetCustomizationsResult',
    'GetDeviceAssurancePolicyDiskEncryptionTypeResult',
    'GetDeviceAssurancePolicyOsVersionResult',
    'GetDeviceAssurancePolicyOsVersionConstraintResult',
    'GetDeviceAssurancePolicyOsVersionConstraintDynamicVersionRequirementResult',
    'GetDeviceAssurancePolicyOsVersionDynamicVersionRequirementResult',
    'GetDeviceAssurancePolicyScreenlockTypeResult',
    'GetDeviceAssurancePolicyThirdPartySignalProviderResult',
    'GetDeviceAssurancePolicyThirdPartySignalProviderDtcResult',
    'GetDeviceAssurancePolicyThirdPartySignalProviderDtcBrowserVersionResult',
    'GetDeviceAssurancePolicyThirdPartySignalProviderDtcOsVersionResult',
    'GetDomainDnsRecordResult',
    'GetEmailCustomizationsEmailCustomizationResult',
    'GetEndUserMyRequestsRequestedResult',
    'GetEndUserMyRequestsRequestedByResult',
    'GetEndUserMyRequestsRequestedForResult',
    'GetEndUserMyRequestsRequesterFieldValueResult',
    'GetEndUserMyRequestsRiskAssessmentResult',
    'GetEndUserMyRequestsRiskAssessmentRiskRuleResult',
    'GetEntitlementBundleEntitlementResult',
    'GetEntitlementBundleEntitlementValueResult',
    'GetEntitlementBundleTargetResult',
    'GetEntitlementParentResult',
    'GetEntitlementValueResult',
    'GetFeaturesFeatureResult',
    'GetFeaturesFeatureStageResult',
    'GetGroupsGroupResult',
    'GetLogStreamSettingsResult',
    'GetOrgMetadataDomainsResult',
    'GetOrgMetadataSettingsResult',
    'GetPrincipalEntitlementsDataResult',
    'GetPrincipalEntitlementsDataParentResult',
    'GetPrincipalEntitlementsDataTargetPrincipalResult',
    'GetPrincipalEntitlementsDataValueResult',
    'GetPrincipalEntitlementsParentResult',
    'GetPrincipalEntitlementsTargetPrincipalResult',
    'GetRequestConditionAccessScopeSettingsResult',
    'GetRequestConditionAccessScopeSettingsIdResult',
    'GetRequestConditionRequesterSettingsResult',
    'GetRequestConditionRequesterSettingsIdResult',
    'GetRequestSettingOrganizationRequestExperienceResult',
    'GetRequestSettingResourceRequestOnBehalfOfSettingsResult',
    'GetRequestSettingResourceRequestOnBehalfOfSettingsOnlyForResult',
    'GetRequestSettingResourceRiskSettingsResult',
    'GetRequestSettingResourceRiskSettingsDefaultSettingResult',
    'GetRequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettingsResult',
    'GetRequestSettingResourceValidAccessDurationSettingsResult',
    'GetRequestSettingResourceValidAccessDurationSettingsSupportedTypeResult',
    'GetRequestSettingResourceValidAccessScopeSettingResult',
    'GetRequestSettingResourceValidRequesterSettingResult',
    'GetRequestV2RequestedResult',
    'GetRequestV2RequestedByResult',
    'GetRequestV2RequestedForResult',
    'GetReviewAllReviewerLevelResult',
    'GetReviewAllReviewerLevelReviewerGroupProfileResult',
    'GetReviewAllReviewerLevelReviewerProfileResult',
    'GetReviewEntitlementBundleResult',
    'GetReviewEntitlementValueResult',
    'GetReviewLinksResult',
    'GetReviewNoteResult',
    'GetReviewPrincipalProfileResult',
    'GetReviewReviewerProfileResult',
    'GetTemplatesEmailTemplateResult',
    'GetThemesThemeResult',
    'GetTrustedOriginsTrustedOriginResult',
    'GetUserSecurityQuestionsQuestionResult',
]

@pulumi.output_type
class AppGroupAssignmentsGroup(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 profile: _builtins.str,
                 priority: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: A group to associate with the application
        :param _builtins.str profile: JSON document containing [application profile](https://developer.okta.com/docs/reference/api/apps/#profile-object)
        :param _builtins.int priority: Priority of group assignment
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "profile", profile)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A group to associate with the application
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> _builtins.str:
        """
        JSON document containing [application profile](https://developer.okta.com/docs/reference/api/apps/#profile-object)
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority of group assignment
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class AppSignonPolicyRulePlatformInclude(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osExpression":
            suggest = "os_expression"
        elif key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSignonPolicyRulePlatformInclude. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSignonPolicyRulePlatformInclude.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSignonPolicyRulePlatformInclude.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_expression: Optional[_builtins.str] = None,
                 os_type: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str os_expression: Only available with OTHER OS type
        """
        if os_expression is not None:
            pulumi.set(__self__, "os_expression", os_expression)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="osExpression")
    def os_expression(self) -> Optional[_builtins.str]:
        """
        Only available with OTHER OS type
        """
        return pulumi.get(self, "os_expression")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class AppUserSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Value mapping to member of `array_enum`
        :param _builtins.str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AppUserSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Enum value
        :param _builtins.str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CampaignNotificationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyReviewPeriodEnd":
            suggest = "notify_review_period_end"
        elif key == "notifyReviewerAtCampaignEnd":
            suggest = "notify_reviewer_at_campaign_end"
        elif key == "notifyReviewerDuringMidpointOfReview":
            suggest = "notify_reviewer_during_midpoint_of_review"
        elif key == "notifyReviewerWhenOverdue":
            suggest = "notify_reviewer_when_overdue"
        elif key == "notifyReviewerWhenReviewAssigned":
            suggest = "notify_reviewer_when_review_assigned"
        elif key == "remindersReviewerBeforeCampaignCloseInSecs":
            suggest = "reminders_reviewer_before_campaign_close_in_secs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignNotificationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignNotificationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignNotificationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notify_review_period_end: _builtins.bool,
                 notify_reviewer_at_campaign_end: _builtins.bool,
                 notify_reviewer_during_midpoint_of_review: _builtins.bool,
                 notify_reviewer_when_overdue: _builtins.bool,
                 notify_reviewer_when_review_assigned: _builtins.bool,
                 reminders_reviewer_before_campaign_close_in_secs: Optional[Sequence[_builtins.int]] = None):
        """
        :param _builtins.bool notify_review_period_end: To indicate whether a notification should be sent to the reviewer when a given reviewer level period is about to end.
        :param _builtins.bool notify_reviewer_at_campaign_end: To indicate whether a notification should be sent to the reviewers when campaign has come to an end.
        :param _builtins.bool notify_reviewer_during_midpoint_of_review: To indicate whether a notification should be sent to the reviewer during the midpoint of the review process.
        :param _builtins.bool notify_reviewer_when_overdue: To indicate whether a notification should be sent to the reviewer when the review is overdue.
        :param _builtins.bool notify_reviewer_when_review_assigned: To indicate whether a notification should be sent to the reviewer when actionable reviews are assigned.
        :param Sequence[_builtins.int] reminders_reviewer_before_campaign_close_in_secs: Specifies times (in seconds) to send reminders to reviewers before the campaign closes. Max 3 values. Example: [86400, 172800, 604800]
        """
        pulumi.set(__self__, "notify_review_period_end", notify_review_period_end)
        pulumi.set(__self__, "notify_reviewer_at_campaign_end", notify_reviewer_at_campaign_end)
        pulumi.set(__self__, "notify_reviewer_during_midpoint_of_review", notify_reviewer_during_midpoint_of_review)
        pulumi.set(__self__, "notify_reviewer_when_overdue", notify_reviewer_when_overdue)
        pulumi.set(__self__, "notify_reviewer_when_review_assigned", notify_reviewer_when_review_assigned)
        if reminders_reviewer_before_campaign_close_in_secs is not None:
            pulumi.set(__self__, "reminders_reviewer_before_campaign_close_in_secs", reminders_reviewer_before_campaign_close_in_secs)

    @_builtins.property
    @pulumi.getter(name="notifyReviewPeriodEnd")
    def notify_review_period_end(self) -> _builtins.bool:
        """
        To indicate whether a notification should be sent to the reviewer when a given reviewer level period is about to end.
        """
        return pulumi.get(self, "notify_review_period_end")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerAtCampaignEnd")
    def notify_reviewer_at_campaign_end(self) -> _builtins.bool:
        """
        To indicate whether a notification should be sent to the reviewers when campaign has come to an end.
        """
        return pulumi.get(self, "notify_reviewer_at_campaign_end")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerDuringMidpointOfReview")
    def notify_reviewer_during_midpoint_of_review(self) -> _builtins.bool:
        """
        To indicate whether a notification should be sent to the reviewer during the midpoint of the review process.
        """
        return pulumi.get(self, "notify_reviewer_during_midpoint_of_review")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerWhenOverdue")
    def notify_reviewer_when_overdue(self) -> _builtins.bool:
        """
        To indicate whether a notification should be sent to the reviewer when the review is overdue.
        """
        return pulumi.get(self, "notify_reviewer_when_overdue")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerWhenReviewAssigned")
    def notify_reviewer_when_review_assigned(self) -> _builtins.bool:
        """
        To indicate whether a notification should be sent to the reviewer when actionable reviews are assigned.
        """
        return pulumi.get(self, "notify_reviewer_when_review_assigned")

    @_builtins.property
    @pulumi.getter(name="remindersReviewerBeforeCampaignCloseInSecs")
    def reminders_reviewer_before_campaign_close_in_secs(self) -> Optional[Sequence[_builtins.int]]:
        """
        Specifies times (in seconds) to send reminders to reviewers before the campaign closes. Max 3 values. Example: [86400, 172800, 604800]
        """
        return pulumi.get(self, "reminders_reviewer_before_campaign_close_in_secs")


@pulumi.output_type
class CampaignPrincipalScopeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedUserIds":
            suggest = "excluded_user_ids"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "includeOnlyActiveUsers":
            suggest = "include_only_active_users"
        elif key == "onlyIncludeUsersWithSodConflicts":
            suggest = "only_include_users_with_sod_conflicts"
        elif key == "predefinedInactiveUsersScopes":
            suggest = "predefined_inactive_users_scopes"
        elif key == "userIds":
            suggest = "user_ids"
        elif key == "userScopeExpression":
            suggest = "user_scope_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignPrincipalScopeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignPrincipalScopeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignPrincipalScopeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 excluded_user_ids: Optional[Sequence[_builtins.str]] = None,
                 group_ids: Optional[Sequence[_builtins.str]] = None,
                 include_only_active_users: Optional[_builtins.bool] = None,
                 only_include_users_with_sod_conflicts: Optional[_builtins.bool] = None,
                 predefined_inactive_users_scopes: Optional[Sequence['outputs.CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope']] = None,
                 user_ids: Optional[Sequence[_builtins.str]] = None,
                 user_scope_expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type for principal_scope_settings.
        :param Sequence[_builtins.str] excluded_user_ids: An array of Okta user IDs excluded from access certification or the campaign. This field is optional. A maximum of 50 users can be specified in the array.
        :param Sequence[_builtins.str] group_ids: An array of Okta group IDs included from access certification or the campaign. userIds, groupIds or userScopeExpression is required if campaign type is USER. A maximum of 5 groups can be specified in the array.
        :param _builtins.bool include_only_active_users: If set to true, only active Okta users are included in the campaign.
        :param _builtins.bool only_include_users_with_sod_conflicts: If set to true, only includes users that have at least one SOD conflict that was caused due to entitlement(s) within Campaign scope.
        :param Sequence[_builtins.str] user_ids: An array of Okta user IDs included from access certification or the campaign. userIds, groupIds or userScopeExpression is required if campaign type is USER. A maximum of 100 users can be specified in the array.
        :param _builtins.str user_scope_expression: The Okta expression language user expression on the resourceSettings to include users in the campaign.
        """
        pulumi.set(__self__, "type", type)
        if excluded_user_ids is not None:
            pulumi.set(__self__, "excluded_user_ids", excluded_user_ids)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if include_only_active_users is not None:
            pulumi.set(__self__, "include_only_active_users", include_only_active_users)
        if only_include_users_with_sod_conflicts is not None:
            pulumi.set(__self__, "only_include_users_with_sod_conflicts", only_include_users_with_sod_conflicts)
        if predefined_inactive_users_scopes is not None:
            pulumi.set(__self__, "predefined_inactive_users_scopes", predefined_inactive_users_scopes)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)
        if user_scope_expression is not None:
            pulumi.set(__self__, "user_scope_expression", user_scope_expression)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type for principal_scope_settings.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="excludedUserIds")
    def excluded_user_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of Okta user IDs excluded from access certification or the campaign. This field is optional. A maximum of 50 users can be specified in the array.
        """
        return pulumi.get(self, "excluded_user_ids")

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of Okta group IDs included from access certification or the campaign. userIds, groupIds or userScopeExpression is required if campaign type is USER. A maximum of 5 groups can be specified in the array.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter(name="includeOnlyActiveUsers")
    def include_only_active_users(self) -> Optional[_builtins.bool]:
        """
        If set to true, only active Okta users are included in the campaign.
        """
        return pulumi.get(self, "include_only_active_users")

    @_builtins.property
    @pulumi.getter(name="onlyIncludeUsersWithSodConflicts")
    def only_include_users_with_sod_conflicts(self) -> Optional[_builtins.bool]:
        """
        If set to true, only includes users that have at least one SOD conflict that was caused due to entitlement(s) within Campaign scope.
        """
        return pulumi.get(self, "only_include_users_with_sod_conflicts")

    @_builtins.property
    @pulumi.getter(name="predefinedInactiveUsersScopes")
    def predefined_inactive_users_scopes(self) -> Optional[Sequence['outputs.CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope']]:
        return pulumi.get(self, "predefined_inactive_users_scopes")

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of Okta user IDs included from access certification or the campaign. userIds, groupIds or userScopeExpression is required if campaign type is USER. A maximum of 100 users can be specified in the array.
        """
        return pulumi.get(self, "user_ids")

    @_builtins.property
    @pulumi.getter(name="userScopeExpression")
    def user_scope_expression(self) -> Optional[_builtins.str]:
        """
        The Okta expression language user expression on the resourceSettings to include users in the campaign.
        """
        return pulumi.get(self, "user_scope_expression")


@pulumi.output_type
class CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inactiveDays":
            suggest = "inactive_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignPrincipalScopeSettingsPredefinedInactiveUsersScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inactive_days: Optional[_builtins.int] = None):
        """
        :param _builtins.int inactive_days: The duration the users have not used single sign on (SSO) to access their account within the specific time frame. Minimum 30 days and maximum 365 days are supported.
        """
        if inactive_days is not None:
            pulumi.set(__self__, "inactive_days", inactive_days)

    @_builtins.property
    @pulumi.getter(name="inactiveDays")
    def inactive_days(self) -> Optional[_builtins.int]:
        """
        The duration the users have not used single sign on (SSO) to access their account within the specific time frame. Minimum 30 days and maximum 365 days are supported.
        """
        return pulumi.get(self, "inactive_days")


@pulumi.output_type
class CampaignRemediationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessApproved":
            suggest = "access_approved"
        elif key == "accessRevoked":
            suggest = "access_revoked"
        elif key == "noResponse":
            suggest = "no_response"
        elif key == "autoRemediationSettings":
            suggest = "auto_remediation_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignRemediationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignRemediationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignRemediationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_approved: _builtins.str,
                 access_revoked: _builtins.str,
                 no_response: _builtins.str,
                 auto_remediation_settings: Optional['outputs.CampaignRemediationSettingsAutoRemediationSettings'] = None):
        """
        :param _builtins.str access_approved: Specifies the action by default if the reviewer approves access. NO_ACTION indicates there is no remediation action and the user retains access.
        :param _builtins.str access_revoked: Specifies the action if the reviewer revokes access. NO_ACTION indicates the user retains the same access. DENY indicates the user will have their access revoked as long as they are not assigned to a group through Group Rules.
        :param _builtins.str no_response: Specifies the action if the reviewer doesn't respond to the request or if the campaign is closed before an action is taken.
        """
        pulumi.set(__self__, "access_approved", access_approved)
        pulumi.set(__self__, "access_revoked", access_revoked)
        pulumi.set(__self__, "no_response", no_response)
        if auto_remediation_settings is not None:
            pulumi.set(__self__, "auto_remediation_settings", auto_remediation_settings)

    @_builtins.property
    @pulumi.getter(name="accessApproved")
    def access_approved(self) -> _builtins.str:
        """
        Specifies the action by default if the reviewer approves access. NO_ACTION indicates there is no remediation action and the user retains access.
        """
        return pulumi.get(self, "access_approved")

    @_builtins.property
    @pulumi.getter(name="accessRevoked")
    def access_revoked(self) -> _builtins.str:
        """
        Specifies the action if the reviewer revokes access. NO_ACTION indicates the user retains the same access. DENY indicates the user will have their access revoked as long as they are not assigned to a group through Group Rules.
        """
        return pulumi.get(self, "access_revoked")

    @_builtins.property
    @pulumi.getter(name="noResponse")
    def no_response(self) -> _builtins.str:
        """
        Specifies the action if the reviewer doesn't respond to the request or if the campaign is closed before an action is taken.
        """
        return pulumi.get(self, "no_response")

    @_builtins.property
    @pulumi.getter(name="autoRemediationSettings")
    def auto_remediation_settings(self) -> Optional['outputs.CampaignRemediationSettingsAutoRemediationSettings']:
        return pulumi.get(self, "auto_remediation_settings")


@pulumi.output_type
class CampaignRemediationSettingsAutoRemediationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeAllIndirectAssignments":
            suggest = "include_all_indirect_assignments"
        elif key == "includeOnlies":
            suggest = "include_onlies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignRemediationSettingsAutoRemediationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignRemediationSettingsAutoRemediationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignRemediationSettingsAutoRemediationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_all_indirect_assignments: Optional[_builtins.bool] = None,
                 include_onlies: Optional[Sequence['outputs.CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly']] = None):
        """
        :param _builtins.bool include_all_indirect_assignments: If true, all indirect assignments will be included in the campaign. If false, only direct assignments will be included.
        """
        if include_all_indirect_assignments is not None:
            pulumi.set(__self__, "include_all_indirect_assignments", include_all_indirect_assignments)
        if include_onlies is not None:
            pulumi.set(__self__, "include_onlies", include_onlies)

    @_builtins.property
    @pulumi.getter(name="includeAllIndirectAssignments")
    def include_all_indirect_assignments(self) -> Optional[_builtins.bool]:
        """
        If true, all indirect assignments will be included in the campaign. If false, only direct assignments will be included.
        """
        return pulumi.get(self, "include_all_indirect_assignments")

    @_builtins.property
    @pulumi.getter(name="includeOnlies")
    def include_onlies(self) -> Optional[Sequence['outputs.CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly']]:
        return pulumi.get(self, "include_onlies")


@pulumi.output_type
class CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignRemediationSettingsAutoRemediationSettingsIncludeOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_id: The ID of the resource to include in the campaign.
        :param _builtins.str resource_type: The type of the resource to include in the campaign. Valid values are 'APPLICATION', 'GROUP', 'ENTITLEMENT', 'ENTITLEMENT_BUNDLE'.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource to include in the campaign.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of the resource to include in the campaign. Valid values are 'APPLICATION', 'GROUP', 'ENTITLEMENT', 'ENTITLEMENT_BUNDLE'.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class CampaignResourceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedResources":
            suggest = "excluded_resources"
        elif key == "includeAdminRoles":
            suggest = "include_admin_roles"
        elif key == "includeEntitlements":
            suggest = "include_entitlements"
        elif key == "individuallyAssignedAppsOnly":
            suggest = "individually_assigned_apps_only"
        elif key == "individuallyAssignedGroupsOnly":
            suggest = "individually_assigned_groups_only"
        elif key == "onlyIncludeOutOfPolicyEntitlements":
            suggest = "only_include_out_of_policy_entitlements"
        elif key == "targetResources":
            suggest = "target_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignResourceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignResourceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignResourceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 excluded_resources: Optional[Sequence['outputs.CampaignResourceSettingsExcludedResource']] = None,
                 include_admin_roles: Optional[_builtins.bool] = None,
                 include_entitlements: Optional[_builtins.bool] = None,
                 individually_assigned_apps_only: Optional[_builtins.bool] = None,
                 individually_assigned_groups_only: Optional[_builtins.bool] = None,
                 only_include_out_of_policy_entitlements: Optional[_builtins.bool] = None,
                 target_resources: Optional[Sequence['outputs.CampaignResourceSettingsTargetResource']] = None):
        """
        :param _builtins.str type: The type of Okta resource.
        :param Sequence['CampaignResourceSettingsExcludedResourceArgs'] excluded_resources: An array of resources that are excluded from the review.
        :param _builtins.bool include_admin_roles: Include admin roles.
        :param _builtins.bool include_entitlements: Include entitlements for this application. This property is only applicable if resource_type = APPLICATION and Entitlement Management is enabled.
        :param _builtins.bool individually_assigned_apps_only: Only include individually assigned apps. This is only applicable if campaign type is USER.
        :param _builtins.bool individually_assigned_groups_only: Only include individually assigned groups. This is only applicable if campaign type is USER.
        :param _builtins.bool only_include_out_of_policy_entitlements: Only include out-of-policy entitlements. Only applicable if resource_type = APPLICATION and Entitlement Management is enabled.
        :param Sequence['CampaignResourceSettingsTargetResourceArgs'] target_resources: Represents a resource that will be part of Access certifications. If the app is enabled for Access Certifications, it's possible to review entitlements and entitlement bundles.
        """
        pulumi.set(__self__, "type", type)
        if excluded_resources is not None:
            pulumi.set(__self__, "excluded_resources", excluded_resources)
        if include_admin_roles is not None:
            pulumi.set(__self__, "include_admin_roles", include_admin_roles)
        if include_entitlements is not None:
            pulumi.set(__self__, "include_entitlements", include_entitlements)
        if individually_assigned_apps_only is not None:
            pulumi.set(__self__, "individually_assigned_apps_only", individually_assigned_apps_only)
        if individually_assigned_groups_only is not None:
            pulumi.set(__self__, "individually_assigned_groups_only", individually_assigned_groups_only)
        if only_include_out_of_policy_entitlements is not None:
            pulumi.set(__self__, "only_include_out_of_policy_entitlements", only_include_out_of_policy_entitlements)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Okta resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="excludedResources")
    def excluded_resources(self) -> Optional[Sequence['outputs.CampaignResourceSettingsExcludedResource']]:
        """
        An array of resources that are excluded from the review.
        """
        return pulumi.get(self, "excluded_resources")

    @_builtins.property
    @pulumi.getter(name="includeAdminRoles")
    def include_admin_roles(self) -> Optional[_builtins.bool]:
        """
        Include admin roles.
        """
        return pulumi.get(self, "include_admin_roles")

    @_builtins.property
    @pulumi.getter(name="includeEntitlements")
    def include_entitlements(self) -> Optional[_builtins.bool]:
        """
        Include entitlements for this application. This property is only applicable if resource_type = APPLICATION and Entitlement Management is enabled.
        """
        return pulumi.get(self, "include_entitlements")

    @_builtins.property
    @pulumi.getter(name="individuallyAssignedAppsOnly")
    def individually_assigned_apps_only(self) -> Optional[_builtins.bool]:
        """
        Only include individually assigned apps. This is only applicable if campaign type is USER.
        """
        return pulumi.get(self, "individually_assigned_apps_only")

    @_builtins.property
    @pulumi.getter(name="individuallyAssignedGroupsOnly")
    def individually_assigned_groups_only(self) -> Optional[_builtins.bool]:
        """
        Only include individually assigned groups. This is only applicable if campaign type is USER.
        """
        return pulumi.get(self, "individually_assigned_groups_only")

    @_builtins.property
    @pulumi.getter(name="onlyIncludeOutOfPolicyEntitlements")
    def only_include_out_of_policy_entitlements(self) -> Optional[_builtins.bool]:
        """
        Only include out-of-policy entitlements. Only applicable if resource_type = APPLICATION and Entitlement Management is enabled.
        """
        return pulumi.get(self, "only_include_out_of_policy_entitlements")

    @_builtins.property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[Sequence['outputs.CampaignResourceSettingsTargetResource']]:
        """
        Represents a resource that will be part of Access certifications. If the app is enabled for Access Certifications, it's possible to review entitlements and entitlement bundles.
        """
        return pulumi.get(self, "target_resources")


@pulumi.output_type
class CampaignResourceSettingsExcludedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignResourceSettingsExcludedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignResourceSettingsExcludedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignResourceSettingsExcludedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_id: The ID of the resource to exclude in the campaign.
        :param _builtins.str resource_type: The type of resource to exclude in the campaign.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource to exclude in the campaign.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of resource to exclude in the campaign.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class CampaignResourceSettingsTargetResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "entitlementBundles":
            suggest = "entitlement_bundles"
        elif key == "includeAllEntitlementsAndBundles":
            suggest = "include_all_entitlements_and_bundles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignResourceSettingsTargetResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignResourceSettingsTargetResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignResourceSettingsTargetResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 entitlement_bundles: Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlementBundle']] = None,
                 entitlements: Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlement']] = None,
                 include_all_entitlements_and_bundles: Optional[_builtins.bool] = None):
        """
        :param _builtins.str resource_id: The resource ID that is being reviewed.
        :param _builtins.str resource_type: The type of Okta resource.
        :param Sequence['CampaignResourceSettingsTargetResourceEntitlementBundleArgs'] entitlement_bundles: An array of entitlement bundles for this application.
        :param Sequence['CampaignResourceSettingsTargetResourceEntitlementArgs'] entitlements: An array of entitlements associated with resourceId that should be chosen as target when creating reviews
        :param _builtins.bool include_all_entitlements_and_bundles: Include all entitlements and entitlement bundles for this application. Only applicable if the resourcetype = APPLICATION and Entitlement Management is enabled.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if entitlement_bundles is not None:
            pulumi.set(__self__, "entitlement_bundles", entitlement_bundles)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if include_all_entitlements_and_bundles is not None:
            pulumi.set(__self__, "include_all_entitlements_and_bundles", include_all_entitlements_and_bundles)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource ID that is being reviewed.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of Okta resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="entitlementBundles")
    def entitlement_bundles(self) -> Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlementBundle']]:
        """
        An array of entitlement bundles for this application.
        """
        return pulumi.get(self, "entitlement_bundles")

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlement']]:
        """
        An array of entitlements associated with resourceId that should be chosen as target when creating reviews
        """
        return pulumi.get(self, "entitlements")

    @_builtins.property
    @pulumi.getter(name="includeAllEntitlementsAndBundles")
    def include_all_entitlements_and_bundles(self) -> Optional[_builtins.bool]:
        """
        Include all entitlements and entitlement bundles for this application. Only applicable if the resourcetype = APPLICATION and Entitlement Management is enabled.
        """
        return pulumi.get(self, "include_all_entitlements_and_bundles")


@pulumi.output_type
class CampaignResourceSettingsTargetResourceEntitlement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeAllValues":
            suggest = "include_all_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignResourceSettingsTargetResourceEntitlement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignResourceSettingsTargetResourceEntitlement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignResourceSettingsTargetResourceEntitlement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 include_all_values: Optional[_builtins.bool] = None,
                 values: Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlementValue']] = None):
        """
        :param _builtins.str id: Campaign id
        :param _builtins.bool include_all_values: Whether to include all entitlement values. If false we must provide the values property.
        """
        pulumi.set(__self__, "id", id)
        if include_all_values is not None:
            pulumi.set(__self__, "include_all_values", include_all_values)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Campaign id
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeAllValues")
    def include_all_values(self) -> Optional[_builtins.bool]:
        """
        Whether to include all entitlement values. If false we must provide the values property.
        """
        return pulumi.get(self, "include_all_values")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.CampaignResourceSettingsTargetResourceEntitlementValue']]:
        return pulumi.get(self, "values")


@pulumi.output_type
class CampaignResourceSettingsTargetResourceEntitlementBundle(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Campaign id
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Campaign id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class CampaignResourceSettingsTargetResourceEntitlementValue(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Campaign id
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Campaign id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class CampaignReviewerSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bulkDecisionDisabled":
            suggest = "bulk_decision_disabled"
        elif key == "fallbackReviewerId":
            suggest = "fallback_reviewer_id"
        elif key == "justificationRequired":
            suggest = "justification_required"
        elif key == "reassignmentDisabled":
            suggest = "reassignment_disabled"
        elif key == "reviewerGroupId":
            suggest = "reviewer_group_id"
        elif key == "reviewerId":
            suggest = "reviewer_id"
        elif key == "reviewerLevels":
            suggest = "reviewer_levels"
        elif key == "reviewerScopeExpression":
            suggest = "reviewer_scope_expression"
        elif key == "selfReviewDisabled":
            suggest = "self_review_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignReviewerSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignReviewerSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignReviewerSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 bulk_decision_disabled: Optional[_builtins.bool] = None,
                 fallback_reviewer_id: Optional[_builtins.str] = None,
                 justification_required: Optional[_builtins.bool] = None,
                 reassignment_disabled: Optional[_builtins.bool] = None,
                 reviewer_group_id: Optional[_builtins.str] = None,
                 reviewer_id: Optional[_builtins.str] = None,
                 reviewer_levels: Optional[Sequence['outputs.CampaignReviewerSettingsReviewerLevel']] = None,
                 reviewer_scope_expression: Optional[_builtins.str] = None,
                 self_review_disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: Identifies the kind of reviewer for Access Certification.
        :param _builtins.bool bulk_decision_disabled: When approving or revoking review items, bulk actions are disabled if true.
        :param _builtins.str fallback_reviewer_id: The ID of the fallback reviewer. Required when the type=`REVIEWER_EXPRESSION` or type=`RESOURCE_OWNER`
        :param _builtins.bool justification_required: When approving or revoking review items, a justification is required if true.
        :param _builtins.bool reassignment_disabled: Reassignment is disabled for reviewers if true.
        :param _builtins.str reviewer_group_id: The ID of the reviewer group to which the reviewer is assigned.
        :param Sequence['CampaignReviewerSettingsReviewerLevelArgs'] reviewer_levels: Definition of reviewer level for a given campaign. Each reviewer level defines the kind of reviewer who is going to review.
        :param _builtins.str reviewer_scope_expression: This property is required when type=`USER`
        :param _builtins.bool self_review_disabled: This property is required to be true for resource-centric campaigns when the Okta Admin Console is one of the resources.
        """
        pulumi.set(__self__, "type", type)
        if bulk_decision_disabled is not None:
            pulumi.set(__self__, "bulk_decision_disabled", bulk_decision_disabled)
        if fallback_reviewer_id is not None:
            pulumi.set(__self__, "fallback_reviewer_id", fallback_reviewer_id)
        if justification_required is not None:
            pulumi.set(__self__, "justification_required", justification_required)
        if reassignment_disabled is not None:
            pulumi.set(__self__, "reassignment_disabled", reassignment_disabled)
        if reviewer_group_id is not None:
            pulumi.set(__self__, "reviewer_group_id", reviewer_group_id)
        if reviewer_id is not None:
            pulumi.set(__self__, "reviewer_id", reviewer_id)
        if reviewer_levels is not None:
            pulumi.set(__self__, "reviewer_levels", reviewer_levels)
        if reviewer_scope_expression is not None:
            pulumi.set(__self__, "reviewer_scope_expression", reviewer_scope_expression)
        if self_review_disabled is not None:
            pulumi.set(__self__, "self_review_disabled", self_review_disabled)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Identifies the kind of reviewer for Access Certification.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="bulkDecisionDisabled")
    def bulk_decision_disabled(self) -> Optional[_builtins.bool]:
        """
        When approving or revoking review items, bulk actions are disabled if true.
        """
        return pulumi.get(self, "bulk_decision_disabled")

    @_builtins.property
    @pulumi.getter(name="fallbackReviewerId")
    def fallback_reviewer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the fallback reviewer. Required when the type=`REVIEWER_EXPRESSION` or type=`RESOURCE_OWNER`
        """
        return pulumi.get(self, "fallback_reviewer_id")

    @_builtins.property
    @pulumi.getter(name="justificationRequired")
    def justification_required(self) -> Optional[_builtins.bool]:
        """
        When approving or revoking review items, a justification is required if true.
        """
        return pulumi.get(self, "justification_required")

    @_builtins.property
    @pulumi.getter(name="reassignmentDisabled")
    def reassignment_disabled(self) -> Optional[_builtins.bool]:
        """
        Reassignment is disabled for reviewers if true.
        """
        return pulumi.get(self, "reassignment_disabled")

    @_builtins.property
    @pulumi.getter(name="reviewerGroupId")
    def reviewer_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the reviewer group to which the reviewer is assigned.
        """
        return pulumi.get(self, "reviewer_group_id")

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerLevels")
    def reviewer_levels(self) -> Optional[Sequence['outputs.CampaignReviewerSettingsReviewerLevel']]:
        """
        Definition of reviewer level for a given campaign. Each reviewer level defines the kind of reviewer who is going to review.
        """
        return pulumi.get(self, "reviewer_levels")

    @_builtins.property
    @pulumi.getter(name="reviewerScopeExpression")
    def reviewer_scope_expression(self) -> Optional[_builtins.str]:
        """
        This property is required when type=`USER`
        """
        return pulumi.get(self, "reviewer_scope_expression")

    @_builtins.property
    @pulumi.getter(name="selfReviewDisabled")
    def self_review_disabled(self) -> Optional[_builtins.bool]:
        """
        This property is required to be true for resource-centric campaigns when the Okta Admin Console is one of the resources.
        """
        return pulumi.get(self, "self_review_disabled")


@pulumi.output_type
class CampaignReviewerSettingsReviewerLevel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackReviewerId":
            suggest = "fallback_reviewer_id"
        elif key == "reviewerGroupId":
            suggest = "reviewer_group_id"
        elif key == "reviewerId":
            suggest = "reviewer_id"
        elif key == "reviewerScopeExpression":
            suggest = "reviewer_scope_expression"
        elif key == "selfReviewDisabled":
            suggest = "self_review_disabled"
        elif key == "startReviews":
            suggest = "start_reviews"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignReviewerSettingsReviewerLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignReviewerSettingsReviewerLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignReviewerSettingsReviewerLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 fallback_reviewer_id: Optional[_builtins.str] = None,
                 reviewer_group_id: Optional[_builtins.str] = None,
                 reviewer_id: Optional[_builtins.str] = None,
                 reviewer_scope_expression: Optional[_builtins.str] = None,
                 self_review_disabled: Optional[_builtins.bool] = None,
                 start_reviews: Optional[Sequence['outputs.CampaignReviewerSettingsReviewerLevelStartReview']] = None):
        """
        :param _builtins.str type: Identifies the kind of reviewer.
        :param _builtins.str fallback_reviewer_id: Required when the type=`REVIEWER_EXPRESSION` or type=`RESOURCE_OWNER`
        :param _builtins.str reviewer_group_id: The ID of the reviewer group to which the reviewer is assigned.This property is required when type=`GROUP`
        :param _builtins.str reviewer_id: The ID of the reviewer to which the reviewer is assigned.This property is required when type=`USER`.
        :param _builtins.str reviewer_scope_expression: This property is required when type=`REVIEWER_EXPRESSION`
        :param _builtins.bool self_review_disabled: This property is used to prevent self review.
        :param Sequence['CampaignReviewerSettingsReviewerLevelStartReviewArgs'] start_reviews: The rules for which the reviews can move to that level.
        """
        pulumi.set(__self__, "type", type)
        if fallback_reviewer_id is not None:
            pulumi.set(__self__, "fallback_reviewer_id", fallback_reviewer_id)
        if reviewer_group_id is not None:
            pulumi.set(__self__, "reviewer_group_id", reviewer_group_id)
        if reviewer_id is not None:
            pulumi.set(__self__, "reviewer_id", reviewer_id)
        if reviewer_scope_expression is not None:
            pulumi.set(__self__, "reviewer_scope_expression", reviewer_scope_expression)
        if self_review_disabled is not None:
            pulumi.set(__self__, "self_review_disabled", self_review_disabled)
        if start_reviews is not None:
            pulumi.set(__self__, "start_reviews", start_reviews)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Identifies the kind of reviewer.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fallbackReviewerId")
    def fallback_reviewer_id(self) -> Optional[_builtins.str]:
        """
        Required when the type=`REVIEWER_EXPRESSION` or type=`RESOURCE_OWNER`
        """
        return pulumi.get(self, "fallback_reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerGroupId")
    def reviewer_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the reviewer group to which the reviewer is assigned.This property is required when type=`GROUP`
        """
        return pulumi.get(self, "reviewer_group_id")

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the reviewer to which the reviewer is assigned.This property is required when type=`USER`.
        """
        return pulumi.get(self, "reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerScopeExpression")
    def reviewer_scope_expression(self) -> Optional[_builtins.str]:
        """
        This property is required when type=`REVIEWER_EXPRESSION`
        """
        return pulumi.get(self, "reviewer_scope_expression")

    @_builtins.property
    @pulumi.getter(name="selfReviewDisabled")
    def self_review_disabled(self) -> Optional[_builtins.bool]:
        """
        This property is used to prevent self review.
        """
        return pulumi.get(self, "self_review_disabled")

    @_builtins.property
    @pulumi.getter(name="startReviews")
    def start_reviews(self) -> Optional[Sequence['outputs.CampaignReviewerSettingsReviewerLevelStartReview']]:
        """
        The rules for which the reviews can move to that level.
        """
        return pulumi.get(self, "start_reviews")


@pulumi.output_type
class CampaignReviewerSettingsReviewerLevelStartReview(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDay":
            suggest = "on_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignReviewerSettingsReviewerLevelStartReview. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignReviewerSettingsReviewerLevelStartReview.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignReviewerSettingsReviewerLevelStartReview.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_day: Optional[_builtins.int] = None,
                 when: Optional[_builtins.str] = None):
        """
        :param _builtins.int on_day: The day of the campaign when the review starts. 0 means the first day of the campaign.
        :param _builtins.str when: The condition for which, the lower level reviews will move to that level for further review.
        """
        if on_day is not None:
            pulumi.set(__self__, "on_day", on_day)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @_builtins.property
    @pulumi.getter(name="onDay")
    def on_day(self) -> Optional[_builtins.int]:
        """
        The day of the campaign when the review starts. 0 means the first day of the campaign.
        """
        return pulumi.get(self, "on_day")

    @_builtins.property
    @pulumi.getter
    def when(self) -> Optional[_builtins.str]:
        """
        The condition for which, the lower level reviews will move to that level for further review.
        """
        return pulumi.get(self, "when")


@pulumi.output_type
class CampaignScheduleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInDays":
            suggest = "duration_in_days"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "endDate":
            suggest = "end_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignScheduleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignScheduleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignScheduleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_days: _builtins.int,
                 start_date: _builtins.str,
                 time_zone: _builtins.str,
                 type: _builtins.str,
                 end_date: Optional[_builtins.str] = None,
                 recurrences: Optional[Sequence['outputs.CampaignScheduleSettingsRecurrence']] = None):
        """
        :param _builtins.int duration_in_days: The duration (in days) that the campaign is active.
        :param _builtins.str start_date: The date on which the campaign is supposed to start. Accepts date in ISO 8601 format.
        :param _builtins.str time_zone: The time zone in which the campaign is active.
        :param _builtins.str type: The type of campaign being scheduled.
        """
        pulumi.set(__self__, "duration_in_days", duration_in_days)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if recurrences is not None:
            pulumi.set(__self__, "recurrences", recurrences)

    @_builtins.property
    @pulumi.getter(name="durationInDays")
    def duration_in_days(self) -> _builtins.int:
        """
        The duration (in days) that the campaign is active.
        """
        return pulumi.get(self, "duration_in_days")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The date on which the campaign is supposed to start. Accepts date in ISO 8601 format.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time zone in which the campaign is active.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of campaign being scheduled.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter
    def recurrences(self) -> Optional[Sequence['outputs.CampaignScheduleSettingsRecurrence']]:
        return pulumi.get(self, "recurrences")


@pulumi.output_type
class CampaignScheduleSettingsRecurrence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repeatOnType":
            suggest = "repeat_on_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignScheduleSettingsRecurrence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignScheduleSettingsRecurrence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignScheduleSettingsRecurrence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: _builtins.str,
                 ends: Optional[_builtins.str] = None,
                 repeat_on_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str interval: Recurrence interval specified according to ISO8061 notation for durations.
        :param _builtins.str ends: Specifies when the recurring schedule can have an end.
        :param _builtins.str repeat_on_type: Specifies when the recurring schedule can have an end.
        """
        pulumi.set(__self__, "interval", interval)
        if ends is not None:
            pulumi.set(__self__, "ends", ends)
        if repeat_on_type is not None:
            pulumi.set(__self__, "repeat_on_type", repeat_on_type)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Recurrence interval specified according to ISO8061 notation for durations.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def ends(self) -> Optional[_builtins.str]:
        """
        Specifies when the recurring schedule can have an end.
        """
        return pulumi.get(self, "ends")

    @_builtins.property
    @pulumi.getter(name="repeatOnType")
    def repeat_on_type(self) -> Optional[_builtins.str]:
        """
        Specifies when the recurring schedule can have an end.
        """
        return pulumi.get(self, "repeat_on_type")


@pulumi.output_type
class CustomizedSigninPageContentSecurityPolicySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUri":
            suggest = "report_uri"
        elif key == "srcLists":
            suggest = "src_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomizedSigninPageContentSecurityPolicySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomizedSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomizedSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None,
                 report_uri: Optional[_builtins.str] = None,
                 src_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str mode: enforced or report_only
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)
        if src_lists is not None:
            pulumi.set(__self__, "src_lists", src_lists)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "report_uri")

    @_builtins.property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class CustomizedSigninPageWidgetCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "widgetGeneration":
            suggest = "widget_generation"
        elif key == "authenticatorPageCustomLinkLabel":
            suggest = "authenticator_page_custom_link_label"
        elif key == "authenticatorPageCustomLinkUrl":
            suggest = "authenticator_page_custom_link_url"
        elif key == "classicRecoveryFlowEmailOrUsernameLabel":
            suggest = "classic_recovery_flow_email_or_username_label"
        elif key == "customLink1Label":
            suggest = "custom_link1_label"
        elif key == "customLink1Url":
            suggest = "custom_link1_url"
        elif key == "customLink2Label":
            suggest = "custom_link2_label"
        elif key == "customLink2Url":
            suggest = "custom_link2_url"
        elif key == "forgotPasswordLabel":
            suggest = "forgot_password_label"
        elif key == "forgotPasswordUrl":
            suggest = "forgot_password_url"
        elif key == "helpLabel":
            suggest = "help_label"
        elif key == "helpUrl":
            suggest = "help_url"
        elif key == "passwordInfoTip":
            suggest = "password_info_tip"
        elif key == "passwordLabel":
            suggest = "password_label"
        elif key == "showPasswordVisibilityToggle":
            suggest = "show_password_visibility_toggle"
        elif key == "showUserIdentifier":
            suggest = "show_user_identifier"
        elif key == "signInLabel":
            suggest = "sign_in_label"
        elif key == "unlockAccountLabel":
            suggest = "unlock_account_label"
        elif key == "unlockAccountUrl":
            suggest = "unlock_account_url"
        elif key == "usernameInfoTip":
            suggest = "username_info_tip"
        elif key == "usernameLabel":
            suggest = "username_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomizedSigninPageWidgetCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomizedSigninPageWidgetCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomizedSigninPageWidgetCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 widget_generation: _builtins.str,
                 authenticator_page_custom_link_label: Optional[_builtins.str] = None,
                 authenticator_page_custom_link_url: Optional[_builtins.str] = None,
                 classic_recovery_flow_email_or_username_label: Optional[_builtins.str] = None,
                 custom_link1_label: Optional[_builtins.str] = None,
                 custom_link1_url: Optional[_builtins.str] = None,
                 custom_link2_label: Optional[_builtins.str] = None,
                 custom_link2_url: Optional[_builtins.str] = None,
                 forgot_password_label: Optional[_builtins.str] = None,
                 forgot_password_url: Optional[_builtins.str] = None,
                 help_label: Optional[_builtins.str] = None,
                 help_url: Optional[_builtins.str] = None,
                 password_info_tip: Optional[_builtins.str] = None,
                 password_label: Optional[_builtins.str] = None,
                 show_password_visibility_toggle: Optional[_builtins.bool] = None,
                 show_user_identifier: Optional[_builtins.bool] = None,
                 sign_in_label: Optional[_builtins.str] = None,
                 unlock_account_label: Optional[_builtins.str] = None,
                 unlock_account_url: Optional[_builtins.str] = None,
                 username_info_tip: Optional[_builtins.str] = None,
                 username_label: Optional[_builtins.str] = None):
        pulumi.set(__self__, "widget_generation", widget_generation)
        if authenticator_page_custom_link_label is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        if authenticator_page_custom_link_url is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        if classic_recovery_flow_email_or_username_label is not None:
            pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        if custom_link1_label is not None:
            pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        if custom_link1_url is not None:
            pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        if custom_link2_label is not None:
            pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        if custom_link2_url is not None:
            pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        if forgot_password_label is not None:
            pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        if forgot_password_url is not None:
            pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        if help_label is not None:
            pulumi.set(__self__, "help_label", help_label)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if password_info_tip is not None:
            pulumi.set(__self__, "password_info_tip", password_info_tip)
        if password_label is not None:
            pulumi.set(__self__, "password_label", password_label)
        if show_password_visibility_toggle is not None:
            pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        if show_user_identifier is not None:
            pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        if sign_in_label is not None:
            pulumi.set(__self__, "sign_in_label", sign_in_label)
        if unlock_account_label is not None:
            pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        if unlock_account_url is not None:
            pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        if username_info_tip is not None:
            pulumi.set(__self__, "username_info_tip", username_info_tip)
        if username_label is not None:
            pulumi.set(__self__, "username_label", username_label)

    @_builtins.property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> _builtins.str:
        return pulumi.get(self, "widget_generation")

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @_builtins.property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link1_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link1_url")

    @_builtins.property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link2_label")

    @_builtins.property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link2_url")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "forgot_password_label")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "forgot_password_url")

    @_builtins.property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "help_label")

    @_builtins.property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "help_url")

    @_builtins.property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password_info_tip")

    @_builtins.property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password_label")

    @_builtins.property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "show_password_visibility_toggle")

    @_builtins.property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "show_user_identifier")

    @_builtins.property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sign_in_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unlock_account_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unlock_account_url")

    @_builtins.property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username_info_tip")

    @_builtins.property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username_label")


@pulumi.output_type
class DomainDnsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDnsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDnsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDnsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional[_builtins.str] = None,
                 fqdn: Optional[_builtins.str] = None,
                 record_type: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str expiration: TXT record expiration
        :param _builtins.str fqdn: DNS record name
        :param _builtins.str record_type: Record type can be TXT or CNAME
        :param Sequence[_builtins.str] values: DNS verification value
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[_builtins.str]:
        """
        TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[_builtins.str]:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        DNS verification value
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EmailDomainDnsValidationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailDomainDnsValidationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailDomainDnsValidationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailDomainDnsValidationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional[_builtins.str] = None,
                 fqdn: Optional[_builtins.str] = None,
                 record_type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str expiration: DNS TXT record expiration
        :param _builtins.str fqdn: DNS record name
        :param _builtins.str record_type: Record type can be TXT or cname
        :param _builtins.str value: DNS record value
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field has been removed in the newest go sdk version and has become noop""")
    def expiration(self) -> Optional[_builtins.str]:
        """
        DNS TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[_builtins.str]:
        """
        Record type can be TXT or cname
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        DNS record value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EmailSenderDnsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailSenderDnsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailSenderDnsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailSenderDnsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[_builtins.str] = None,
                 record_type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str fqdn: DNS record name
        :param _builtins.str record_type: Record type can be TXT or CNAME
        :param _builtins.str value: DNS verification value
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[_builtins.str]:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        DNS verification value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EndUserMyRequestsRequesterFieldValue(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 label: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: The ID of a requesterField. This identifies the specific field in the approval system.
        :param _builtins.str label: A human-readable description of requesterField. It's used for display purposes and is optional.
        :param _builtins.str type: Type of value for the requester field. Valid values: `DURATION`, `ISO_DATE`, `MULTISELECT`, `OKTA_USER_ID`, `SELECT`, `TEXT`.
        :param _builtins.str value: The value of requesterField, which depends on the type of the field. Used for single-value fields.
        :param Sequence[_builtins.str] values: The values of requesterField with the type MULTISELECT. If the field type is MULTISELECT, this property is required instead of `value`.
        """
        pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of a requesterField. This identifies the specific field in the approval system.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        A human-readable description of requesterField. It's used for display purposes and is optional.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of value for the requester field. Valid values: `DURATION`, `ISO_DATE`, `MULTISELECT`, `OKTA_USER_ID`, `SELECT`, `TEXT`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of requesterField, which depends on the type of the field. Used for single-value fields.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The values of requesterField with the type MULTISELECT. If the field type is MULTISELECT, this property is required instead of `value`.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EntitlementBundleEntitlement(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 values: Optional[Sequence['outputs.EntitlementBundleEntitlementValue']] = None):
        """
        :param _builtins.str id: The ID of the entitlement.
        """
        pulumi.set(__self__, "id", id)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entitlement.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.EntitlementBundleEntitlementValue']]:
        return pulumi.get(self, "values")


@pulumi.output_type
class EntitlementBundleEntitlementValue(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the entitlement value.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entitlement value.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class EntitlementBundleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementBundleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementBundleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementBundleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta app ID of the resource.
        :param _builtins.str type: The type of resource.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta app ID of the resource.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EntitlementParent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementParent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementParent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementParent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta app ID of the resource.
        :param _builtins.str type: The type of resource.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta app ID of the resource.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EntitlementValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 external_value: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The description of an entitlement value.
        :param _builtins.str external_value: The value of an entitlement property value.
        :param _builtins.str id: Collection of entitlement values.
        :param _builtins.str name: The display name for an entitlement value.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of an entitlement value.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[_builtins.str]:
        """
        The value of an entitlement property value.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Collection of entitlement values.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The display name for an entitlement value.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EventHookHeader(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class FeatureStage(dict):
    def __init__(__self__, *,
                 state: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GroupSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Value mapping to member of `array_enum`
        :param _builtins.str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GroupSchemaPropertyMasterOverridePriority(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 type: Optional[_builtins.str] = None):
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class GroupSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Enum value
        :param _builtins.str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class LogStreamSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "eventSourceName":
            suggest = "event_source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogStreamSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogStreamSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogStreamSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[_builtins.str] = None,
                 edition: Optional[_builtins.str] = None,
                 event_source_name: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_id: AWS account ID. Required only for 'aws_eventbridge' type
        :param _builtins.str edition: Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        :param _builtins.str event_source_name: An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        :param _builtins.str host: The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        :param _builtins.str region: The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        :param _builtins.str token: The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if event_source_name is not None:
            pulumi.set(__self__, "event_source_name", event_source_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        AWS account ID. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[_builtins.str]:
        """
        Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> Optional[_builtins.str]:
        """
        An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "event_source_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class PolicyRuleProfileEnrollmentProfileAttribute(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 name: _builtins.str,
                 required: Optional[_builtins.bool] = None):
        """
        :param _builtins.str label: A display-friendly label for this property
        :param _builtins.str name: The name of a User Profile property
        :param _builtins.bool required: Indicates if this property is required for enrollment
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        A display-friendly label for this property
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a User Profile property
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[_builtins.bool]:
        """
        Indicates if this property is required for enrollment
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class PreviewSigninPageContentSecurityPolicySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUri":
            suggest = "report_uri"
        elif key == "srcLists":
            suggest = "src_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreviewSigninPageContentSecurityPolicySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreviewSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreviewSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None,
                 report_uri: Optional[_builtins.str] = None,
                 src_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str mode: enforced or report_only
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)
        if src_lists is not None:
            pulumi.set(__self__, "src_lists", src_lists)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "report_uri")

    @_builtins.property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class PreviewSigninPageWidgetCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "widgetGeneration":
            suggest = "widget_generation"
        elif key == "authenticatorPageCustomLinkLabel":
            suggest = "authenticator_page_custom_link_label"
        elif key == "authenticatorPageCustomLinkUrl":
            suggest = "authenticator_page_custom_link_url"
        elif key == "classicRecoveryFlowEmailOrUsernameLabel":
            suggest = "classic_recovery_flow_email_or_username_label"
        elif key == "customLink1Label":
            suggest = "custom_link1_label"
        elif key == "customLink1Url":
            suggest = "custom_link1_url"
        elif key == "customLink2Label":
            suggest = "custom_link2_label"
        elif key == "customLink2Url":
            suggest = "custom_link2_url"
        elif key == "forgotPasswordLabel":
            suggest = "forgot_password_label"
        elif key == "forgotPasswordUrl":
            suggest = "forgot_password_url"
        elif key == "helpLabel":
            suggest = "help_label"
        elif key == "helpUrl":
            suggest = "help_url"
        elif key == "passwordInfoTip":
            suggest = "password_info_tip"
        elif key == "passwordLabel":
            suggest = "password_label"
        elif key == "showPasswordVisibilityToggle":
            suggest = "show_password_visibility_toggle"
        elif key == "showUserIdentifier":
            suggest = "show_user_identifier"
        elif key == "signInLabel":
            suggest = "sign_in_label"
        elif key == "unlockAccountLabel":
            suggest = "unlock_account_label"
        elif key == "unlockAccountUrl":
            suggest = "unlock_account_url"
        elif key == "usernameInfoTip":
            suggest = "username_info_tip"
        elif key == "usernameLabel":
            suggest = "username_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreviewSigninPageWidgetCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreviewSigninPageWidgetCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreviewSigninPageWidgetCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 widget_generation: _builtins.str,
                 authenticator_page_custom_link_label: Optional[_builtins.str] = None,
                 authenticator_page_custom_link_url: Optional[_builtins.str] = None,
                 classic_recovery_flow_email_or_username_label: Optional[_builtins.str] = None,
                 custom_link1_label: Optional[_builtins.str] = None,
                 custom_link1_url: Optional[_builtins.str] = None,
                 custom_link2_label: Optional[_builtins.str] = None,
                 custom_link2_url: Optional[_builtins.str] = None,
                 forgot_password_label: Optional[_builtins.str] = None,
                 forgot_password_url: Optional[_builtins.str] = None,
                 help_label: Optional[_builtins.str] = None,
                 help_url: Optional[_builtins.str] = None,
                 password_info_tip: Optional[_builtins.str] = None,
                 password_label: Optional[_builtins.str] = None,
                 show_password_visibility_toggle: Optional[_builtins.bool] = None,
                 show_user_identifier: Optional[_builtins.bool] = None,
                 sign_in_label: Optional[_builtins.str] = None,
                 unlock_account_label: Optional[_builtins.str] = None,
                 unlock_account_url: Optional[_builtins.str] = None,
                 username_info_tip: Optional[_builtins.str] = None,
                 username_label: Optional[_builtins.str] = None):
        pulumi.set(__self__, "widget_generation", widget_generation)
        if authenticator_page_custom_link_label is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        if authenticator_page_custom_link_url is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        if classic_recovery_flow_email_or_username_label is not None:
            pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        if custom_link1_label is not None:
            pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        if custom_link1_url is not None:
            pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        if custom_link2_label is not None:
            pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        if custom_link2_url is not None:
            pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        if forgot_password_label is not None:
            pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        if forgot_password_url is not None:
            pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        if help_label is not None:
            pulumi.set(__self__, "help_label", help_label)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if password_info_tip is not None:
            pulumi.set(__self__, "password_info_tip", password_info_tip)
        if password_label is not None:
            pulumi.set(__self__, "password_label", password_label)
        if show_password_visibility_toggle is not None:
            pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        if show_user_identifier is not None:
            pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        if sign_in_label is not None:
            pulumi.set(__self__, "sign_in_label", sign_in_label)
        if unlock_account_label is not None:
            pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        if unlock_account_url is not None:
            pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        if username_info_tip is not None:
            pulumi.set(__self__, "username_info_tip", username_info_tip)
        if username_label is not None:
            pulumi.set(__self__, "username_label", username_label)

    @_builtins.property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> _builtins.str:
        return pulumi.get(self, "widget_generation")

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @_builtins.property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link1_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link1_url")

    @_builtins.property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link2_label")

    @_builtins.property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "custom_link2_url")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "forgot_password_label")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "forgot_password_url")

    @_builtins.property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "help_label")

    @_builtins.property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "help_url")

    @_builtins.property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password_info_tip")

    @_builtins.property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password_label")

    @_builtins.property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "show_password_visibility_toggle")

    @_builtins.property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "show_user_identifier")

    @_builtins.property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sign_in_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unlock_account_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unlock_account_url")

    @_builtins.property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username_info_tip")

    @_builtins.property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username_label")


@pulumi.output_type
class RateLimitingUseCaseModeOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginPage":
            suggest = "login_page"
        elif key == "oauth2Authorize":
            suggest = "oauth2_authorize"
        elif key == "oieAppIntent":
            suggest = "oie_app_intent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RateLimitingUseCaseModeOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RateLimitingUseCaseModeOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RateLimitingUseCaseModeOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_page: Optional[_builtins.str] = None,
                 oauth2_authorize: Optional[_builtins.str] = None,
                 oie_app_intent: Optional[_builtins.str] = None):
        if login_page is not None:
            pulumi.set(__self__, "login_page", login_page)
        if oauth2_authorize is not None:
            pulumi.set(__self__, "oauth2_authorize", oauth2_authorize)
        if oie_app_intent is not None:
            pulumi.set(__self__, "oie_app_intent", oie_app_intent)

    @_builtins.property
    @pulumi.getter(name="loginPage")
    def login_page(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "login_page")

    @_builtins.property
    @pulumi.getter(name="oauth2Authorize")
    def oauth2_authorize(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oauth2_authorize")

    @_builtins.property
    @pulumi.getter(name="oieAppIntent")
    def oie_app_intent(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oie_app_intent")


@pulumi.output_type
class RequestConditionAccessDurationSettings(dict):
    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str duration: The duration set by the admin for access durations. Use ISO8061 notation for duration values.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The duration set by the admin for access durations. Use ISO8061 notation for duration values.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class RequestConditionAccessScopeSettings(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 ids: Optional[Sequence['outputs.RequestConditionAccessScopeSettingsId']] = None):
        """
        :param Sequence['RequestConditionAccessScopeSettingsIdArgs'] ids: Block list of groups/entitlement bundles ids.
        """
        pulumi.set(__self__, "type", type)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.RequestConditionAccessScopeSettingsId']]:
        """
        Block list of groups/entitlement bundles ids.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class RequestConditionAccessScopeSettingsId(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Request condition id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RequestConditionRequesterSettings(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 ids: Optional[Sequence['outputs.RequestConditionRequesterSettingsId']] = None):
        """
        :param Sequence['RequestConditionRequesterSettingsIdArgs'] ids: Block list of teams/groups ids.
        """
        pulumi.set(__self__, "type", type)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.RequestConditionRequesterSettingsId']]:
        """
        Block list of teams/groups ids.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class RequestConditionRequesterSettingsId(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Request condition id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RequestSettingResourceRequestOnBehalfOfSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onlyFors":
            suggest = "only_fors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestSettingResourceRequestOnBehalfOfSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestSettingResourceRequestOnBehalfOfSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestSettingResourceRequestOnBehalfOfSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed: Optional[_builtins.bool] = None,
                 only_fors: Optional[Sequence['outputs.RequestSettingResourceRequestOnBehalfOfSettingsOnlyFor']] = None):
        """
        :param _builtins.bool allowed: Indicates that users who can request this resource could also request for another requester of the same resource. This property can only be true.
        :param Sequence['RequestSettingResourceRequestOnBehalfOfSettingsOnlyForArgs'] only_fors: Which requesters the resource requester can request on behalf of. Enum: `DIRECT_REPORT`.
        """
        if allowed is not None:
            pulumi.set(__self__, "allowed", allowed)
        if only_fors is not None:
            pulumi.set(__self__, "only_fors", only_fors)

    @_builtins.property
    @pulumi.getter
    def allowed(self) -> Optional[_builtins.bool]:
        """
        Indicates that users who can request this resource could also request for another requester of the same resource. This property can only be true.
        """
        return pulumi.get(self, "allowed")

    @_builtins.property
    @pulumi.getter(name="onlyFors")
    def only_fors(self) -> Optional[Sequence['outputs.RequestSettingResourceRequestOnBehalfOfSettingsOnlyFor']]:
        """
        Which requesters the resource requester can request on behalf of. Enum: `DIRECT_REPORT`.
        """
        return pulumi.get(self, "only_fors")


@pulumi.output_type
class RequestSettingResourceRequestOnBehalfOfSettingsOnlyFor(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Which requesters the resource requester can request on behalf of. If onlyFor is not specified then any requester may request a resource on the behalf of any other user
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Which requesters the resource requester can request on behalf of. If onlyFor is not specified then any requester may request a resource on the behalf of any other user
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RequestSettingResourceRiskSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSetting":
            suggest = "default_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestSettingResourceRiskSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestSettingResourceRiskSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestSettingResourceRiskSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_setting: Optional['outputs.RequestSettingResourceRiskSettingsDefaultSetting'] = None):
        """
        :param 'RequestSettingResourceRiskSettingsDefaultSettingArgs' default_setting: Default risk settings that are valid for an access request when a risk has been detected for the resource and requesting user.
        """
        if default_setting is not None:
            pulumi.set(__self__, "default_setting", default_setting)

    @_builtins.property
    @pulumi.getter(name="defaultSetting")
    def default_setting(self) -> Optional['outputs.RequestSettingResourceRiskSettingsDefaultSetting']:
        """
        Default risk settings that are valid for an access request when a risk has been detected for the resource and requesting user.
        """
        return pulumi.get(self, "default_setting")


@pulumi.output_type
class RequestSettingResourceRiskSettingsDefaultSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessDurationSettings":
            suggest = "access_duration_settings"
        elif key == "approvalSequenceId":
            suggest = "approval_sequence_id"
        elif key == "requestSubmissionType":
            suggest = "request_submission_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestSettingResourceRiskSettingsDefaultSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestSettingResourceRiskSettingsDefaultSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestSettingResourceRiskSettingsDefaultSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_duration_settings: Optional['outputs.RequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettings'] = None,
                 approval_sequence_id: Optional[_builtins.str] = None,
                 errors: Optional[Sequence[_builtins.str]] = None,
                 request_submission_type: Optional[_builtins.str] = None):
        """
        :param 'RequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettingsArgs' access_duration_settings: Settings that control who may specify the access duration allowed by this request condition or risk settings, as well as what duration may be requested.
        :param _builtins.str approval_sequence_id: The ID of the approval sequence.
        """
        if access_duration_settings is not None:
            pulumi.set(__self__, "access_duration_settings", access_duration_settings)
        if approval_sequence_id is not None:
            pulumi.set(__self__, "approval_sequence_id", approval_sequence_id)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if request_submission_type is not None:
            pulumi.set(__self__, "request_submission_type", request_submission_type)

    @_builtins.property
    @pulumi.getter(name="accessDurationSettings")
    def access_duration_settings(self) -> Optional['outputs.RequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettings']:
        """
        Settings that control who may specify the access duration allowed by this request condition or risk settings, as well as what duration may be requested.
        """
        return pulumi.get(self, "access_duration_settings")

    @_builtins.property
    @pulumi.getter(name="approvalSequenceId")
    def approval_sequence_id(self) -> Optional[_builtins.str]:
        """
        The ID of the approval sequence.
        """
        return pulumi.get(self, "approval_sequence_id")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter(name="requestSubmissionType")
    def request_submission_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "request_submission_type")


@pulumi.output_type
class RequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettings(dict):
    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str duration: The duration set by the admin for access durations. Use ISO8061 notation for duration values.
        :param _builtins.str type: Enum: `ADMIN_FIXED_DURATION`, `REQUESTER_SPECIFIED_DURATION`.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The duration set by the admin for access durations. Use ISO8061 notation for duration values.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Enum: `ADMIN_FIXED_DURATION`, `REQUESTER_SPECIFIED_DURATION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RequestV2Requested(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryId":
            suggest = "entry_id"
        elif key == "accessScopeId":
            suggest = "access_scope_id"
        elif key == "accessScopeType":
            suggest = "access_scope_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestV2Requested. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestV2Requested.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestV2Requested.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_id: _builtins.str,
                 type: _builtins.str,
                 access_scope_id: Optional[_builtins.str] = None,
                 access_scope_type: Optional[_builtins.str] = None,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str entry_id: The ID of the resource catalog entry.
        :param _builtins.str type: The type of the resource.
        :param _builtins.str access_scope_id: The ID of the access scope associated with the resource.
        :param _builtins.str access_scope_type: The access scope type.
        :param _builtins.str resource_id: The ID of the requested resource.
        :param _builtins.str resource_type: The requested resource type.
        """
        pulumi.set(__self__, "entry_id", entry_id)
        pulumi.set(__self__, "type", type)
        if access_scope_id is not None:
            pulumi.set(__self__, "access_scope_id", access_scope_id)
        if access_scope_type is not None:
            pulumi.set(__self__, "access_scope_type", access_scope_type)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> _builtins.str:
        """
        The ID of the resource catalog entry.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="accessScopeId")
    def access_scope_id(self) -> Optional[_builtins.str]:
        """
        The ID of the access scope associated with the resource.
        """
        return pulumi.get(self, "access_scope_id")

    @_builtins.property
    @pulumi.getter(name="accessScopeType")
    def access_scope_type(self) -> Optional[_builtins.str]:
        """
        The access scope type.
        """
        return pulumi.get(self, "access_scope_type")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the requested resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The requested resource type.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class RequestV2RequestedFor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestV2RequestedFor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestV2RequestedFor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestV2RequestedFor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The ID of the Okta user.
        :param _builtins.str type: The type of principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The ID of the Okta user.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RequestV2RequesterFieldValue(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 values: Optional[Sequence['outputs.RequestV2RequesterFieldValueValue']] = None):
        """
        :param _builtins.str id: Request condition id.
        :param _builtins.str label: A human-readable description of requester field.
        :param _builtins.str type: Type of value for the requester field.
        :param _builtins.str value: The value of requester field, which depends on the type of the field.
        :param Sequence['RequestV2RequesterFieldValueValueArgs'] values: The values of requester field with the type MULTISELECT. If the field type is MULTISELECT, this property is required.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        A human-readable description of requester field.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of value for the requester field.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of requester field, which depends on the type of the field.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.RequestV2RequesterFieldValueValue']]:
        """
        The values of requester field with the type MULTISELECT. If the field type is MULTISELECT, this property is required.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RequestV2RequesterFieldValueValue(dict):
    def __init__(__self__, *,
                 value: Optional[_builtins.str] = None):
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TemplateSmsTranslation(dict):
    def __init__(__self__, *,
                 language: _builtins.str,
                 template: _builtins.str):
        """
        :param _builtins.str language: The language to map the template to.
        :param _builtins.str template: The SMS message.
        """
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The language to map the template to.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter
    def template(self) -> _builtins.str:
        """
        The SMS message.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class UserSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Value mapping to member of `array_enum`
        :param _builtins.str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class UserSchemaPropertyMasterOverridePriority(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 type: Optional[_builtins.str] = None):
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class UserSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str const: Enum value
        :param _builtins.str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def const(self) -> _builtins.str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetAppsAppResult(dict):
    def __init__(__self__, *,
                 admin_note: _builtins.str,
                 created: _builtins.str,
                 enduser_note: _builtins.str,
                 features: Sequence[_builtins.str],
                 id: _builtins.str,
                 label: _builtins.str,
                 last_updated: _builtins.str,
                 name: _builtins.str,
                 sign_on_mode: _builtins.str,
                 status: _builtins.str,
                 visibility: 'outputs.GetAppsAppVisibilityResult'):
        pulumi.set(__self__, "admin_note", admin_note)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "enduser_note", enduser_note)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> _builtins.str:
        return pulumi.get(self, "admin_note")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> _builtins.str:
        return pulumi.get(self, "enduser_note")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> _builtins.str:
        return pulumi.get(self, "sign_on_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> 'outputs.GetAppsAppVisibilityResult':
        return pulumi.get(self, "visibility")


@pulumi.output_type
class GetAppsAppVisibilityResult(dict):
    def __init__(__self__, *,
                 auto_launch: _builtins.bool,
                 auto_submit_toolbar: _builtins.bool,
                 hide: 'outputs.GetAppsAppVisibilityHideResult'):
        pulumi.set(__self__, "auto_launch", auto_launch)
        pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        pulumi.set(__self__, "hide", hide)

    @_builtins.property
    @pulumi.getter(name="autoLaunch")
    def auto_launch(self) -> _builtins.bool:
        return pulumi.get(self, "auto_launch")

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> _builtins.bool:
        return pulumi.get(self, "auto_submit_toolbar")

    @_builtins.property
    @pulumi.getter
    def hide(self) -> 'outputs.GetAppsAppVisibilityHideResult':
        return pulumi.get(self, "hide")


@pulumi.output_type
class GetAppsAppVisibilityHideResult(dict):
    def __init__(__self__, *,
                 ios: _builtins.bool,
                 web: _builtins.bool):
        pulumi.set(__self__, "ios", ios)
        pulumi.set(__self__, "web", web)

    @_builtins.property
    @pulumi.getter
    def ios(self) -> _builtins.bool:
        return pulumi.get(self, "ios")

    @_builtins.property
    @pulumi.getter
    def web(self) -> _builtins.bool:
        return pulumi.get(self, "web")


@pulumi.output_type
class GetAuthServerClaimsClaimResult(dict):
    def __init__(__self__, *,
                 always_include_in_token: _builtins.bool,
                 claim_type: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 scopes: Sequence[_builtins.str],
                 status: _builtins.str,
                 value: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.bool always_include_in_token: Specifies whether to include Claims in the token.
        :param _builtins.str claim_type: Specifies whether the Claim is for an access token (`RESOURCE`) or ID token (`IDENTITY`).
        :param _builtins.str id: ID of the claim.
        :param _builtins.str name: Name of the claim.
        :param Sequence[_builtins.str] scopes: Specifies the scopes for this Claim.
        :param _builtins.str status: Status of the claim.
        :param _builtins.str value: Value of the claim.
        :param _builtins.str value_type: Specifies whether the Claim is an Okta EL expression (`EXPRESSION`), a set of groups (`GROUPS`), or a system claim (`SYSTEM`)
        """
        pulumi.set(__self__, "always_include_in_token", always_include_in_token)
        pulumi.set(__self__, "claim_type", claim_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="alwaysIncludeInToken")
    def always_include_in_token(self) -> _builtins.bool:
        """
        Specifies whether to include Claims in the token.
        """
        return pulumi.get(self, "always_include_in_token")

    @_builtins.property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> _builtins.str:
        """
        Specifies whether the Claim is for an access token (`RESOURCE`) or ID token (`IDENTITY`).
        """
        return pulumi.get(self, "claim_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the claim.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the claim.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Sequence[_builtins.str]:
        """
        Specifies the scopes for this Claim.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the claim.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the claim.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        Specifies whether the Claim is an Okta EL expression (`EXPRESSION`), a set of groups (`GROUPS`), or a system claim (`SYSTEM`)
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetBehavioursBehaviorResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 settings: Mapping[str, _builtins.str],
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: Behavior ID.
        :param _builtins.str name: Behavior name.
        :param Mapping[str, _builtins.str] settings: Map of behavior settings.
        :param _builtins.str status: Behavior status.
        :param _builtins.str type: Behavior type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Behavior ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Behavior name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Mapping[str, _builtins.str]:
        """
        Map of behavior settings.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Behavior status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Behavior type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBrandsBrandResult(dict):
    def __init__(__self__, *,
                 custom_privacy_policy_url: _builtins.str,
                 id: _builtins.str,
                 links: _builtins.str,
                 name: _builtins.str,
                 remove_powered_by_okta: _builtins.bool):
        """
        :param _builtins.str custom_privacy_policy_url: Custom privacy policy URL
        :param _builtins.str id: The ID of the Brand
        :param _builtins.str links: Link relations for this object - JSON HAL - Discoverable resources related to the brand
        :param _builtins.str name: Brand name
        :param _builtins.bool remove_powered_by_okta: Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
        """
        pulumi.set(__self__, "custom_privacy_policy_url", custom_privacy_policy_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remove_powered_by_okta", remove_powered_by_okta)

    @_builtins.property
    @pulumi.getter(name="customPrivacyPolicyUrl")
    def custom_privacy_policy_url(self) -> _builtins.str:
        """
        Custom privacy policy URL
        """
        return pulumi.get(self, "custom_privacy_policy_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Brand
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the brand
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Brand name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="removePoweredByOkta")
    def remove_powered_by_okta(self) -> _builtins.bool:
        """
        Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
        """
        return pulumi.get(self, "remove_powered_by_okta")


@pulumi.output_type
class GetCampaignNotificationSettingsResult(dict):
    def __init__(__self__, *,
                 notify_review_period_end: _builtins.bool,
                 notify_reviewer_at_campaign_end: _builtins.bool,
                 notify_reviewer_during_midpoint_of_review: _builtins.bool,
                 notify_reviewer_when_overdue: _builtins.bool,
                 notify_reviewer_when_review_assigned: _builtins.bool,
                 reminders_reviewer_before_campaign_close_in_secs: Sequence[_builtins.int]):
        pulumi.set(__self__, "notify_review_period_end", notify_review_period_end)
        pulumi.set(__self__, "notify_reviewer_at_campaign_end", notify_reviewer_at_campaign_end)
        pulumi.set(__self__, "notify_reviewer_during_midpoint_of_review", notify_reviewer_during_midpoint_of_review)
        pulumi.set(__self__, "notify_reviewer_when_overdue", notify_reviewer_when_overdue)
        pulumi.set(__self__, "notify_reviewer_when_review_assigned", notify_reviewer_when_review_assigned)
        pulumi.set(__self__, "reminders_reviewer_before_campaign_close_in_secs", reminders_reviewer_before_campaign_close_in_secs)

    @_builtins.property
    @pulumi.getter(name="notifyReviewPeriodEnd")
    def notify_review_period_end(self) -> _builtins.bool:
        return pulumi.get(self, "notify_review_period_end")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerAtCampaignEnd")
    def notify_reviewer_at_campaign_end(self) -> _builtins.bool:
        return pulumi.get(self, "notify_reviewer_at_campaign_end")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerDuringMidpointOfReview")
    def notify_reviewer_during_midpoint_of_review(self) -> _builtins.bool:
        return pulumi.get(self, "notify_reviewer_during_midpoint_of_review")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerWhenOverdue")
    def notify_reviewer_when_overdue(self) -> _builtins.bool:
        return pulumi.get(self, "notify_reviewer_when_overdue")

    @_builtins.property
    @pulumi.getter(name="notifyReviewerWhenReviewAssigned")
    def notify_reviewer_when_review_assigned(self) -> _builtins.bool:
        return pulumi.get(self, "notify_reviewer_when_review_assigned")

    @_builtins.property
    @pulumi.getter(name="remindersReviewerBeforeCampaignCloseInSecs")
    def reminders_reviewer_before_campaign_close_in_secs(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "reminders_reviewer_before_campaign_close_in_secs")


@pulumi.output_type
class GetCampaignPrincipalScopeSettingsResult(dict):
    def __init__(__self__, *,
                 excluded_user_ids: Sequence[_builtins.str],
                 group_ids: Sequence[_builtins.str],
                 include_only_active_users: _builtins.bool,
                 only_include_users_with_sod_conflicts: _builtins.bool,
                 type: _builtins.str,
                 user_ids: Sequence[_builtins.str],
                 user_scope_expression: _builtins.str,
                 predefined_inactive_users_scopes: Optional[Sequence['outputs.GetCampaignPrincipalScopeSettingsPredefinedInactiveUsersScopeResult']] = None):
        pulumi.set(__self__, "excluded_user_ids", excluded_user_ids)
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "include_only_active_users", include_only_active_users)
        pulumi.set(__self__, "only_include_users_with_sod_conflicts", only_include_users_with_sod_conflicts)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_ids", user_ids)
        pulumi.set(__self__, "user_scope_expression", user_scope_expression)
        if predefined_inactive_users_scopes is not None:
            pulumi.set(__self__, "predefined_inactive_users_scopes", predefined_inactive_users_scopes)

    @_builtins.property
    @pulumi.getter(name="excludedUserIds")
    def excluded_user_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "excluded_user_ids")

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter(name="includeOnlyActiveUsers")
    def include_only_active_users(self) -> _builtins.bool:
        return pulumi.get(self, "include_only_active_users")

    @_builtins.property
    @pulumi.getter(name="onlyIncludeUsersWithSodConflicts")
    def only_include_users_with_sod_conflicts(self) -> _builtins.bool:
        return pulumi.get(self, "only_include_users_with_sod_conflicts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "user_ids")

    @_builtins.property
    @pulumi.getter(name="userScopeExpression")
    def user_scope_expression(self) -> _builtins.str:
        return pulumi.get(self, "user_scope_expression")

    @_builtins.property
    @pulumi.getter(name="predefinedInactiveUsersScopes")
    def predefined_inactive_users_scopes(self) -> Optional[Sequence['outputs.GetCampaignPrincipalScopeSettingsPredefinedInactiveUsersScopeResult']]:
        return pulumi.get(self, "predefined_inactive_users_scopes")


@pulumi.output_type
class GetCampaignPrincipalScopeSettingsPredefinedInactiveUsersScopeResult(dict):
    def __init__(__self__, *,
                 inactive_days: _builtins.int):
        pulumi.set(__self__, "inactive_days", inactive_days)

    @_builtins.property
    @pulumi.getter(name="inactiveDays")
    def inactive_days(self) -> _builtins.int:
        return pulumi.get(self, "inactive_days")


@pulumi.output_type
class GetCampaignRemediationSettingsResult(dict):
    def __init__(__self__, *,
                 access_approved: _builtins.str,
                 access_revoked: _builtins.str,
                 no_response: _builtins.str,
                 auto_remediation_settings: Optional['outputs.GetCampaignRemediationSettingsAutoRemediationSettingsResult'] = None):
        """
        :param _builtins.str access_approved: Specifies the action by default if the reviewer approves access. NO_ACTION indicates there is no remediation action and the user retains access.
        :param _builtins.str access_revoked: Specifies the action if the reviewer revokes access. NO_ACTION indicates the user retains the same access. DENY indicates the user will have their access revoked as long as they are not assigned to a group through Group Rules.
        :param _builtins.str no_response: Specifies the action if the reviewer doesn't respond to the request.
        """
        pulumi.set(__self__, "access_approved", access_approved)
        pulumi.set(__self__, "access_revoked", access_revoked)
        pulumi.set(__self__, "no_response", no_response)
        if auto_remediation_settings is not None:
            pulumi.set(__self__, "auto_remediation_settings", auto_remediation_settings)

    @_builtins.property
    @pulumi.getter(name="accessApproved")
    def access_approved(self) -> _builtins.str:
        """
        Specifies the action by default if the reviewer approves access. NO_ACTION indicates there is no remediation action and the user retains access.
        """
        return pulumi.get(self, "access_approved")

    @_builtins.property
    @pulumi.getter(name="accessRevoked")
    def access_revoked(self) -> _builtins.str:
        """
        Specifies the action if the reviewer revokes access. NO_ACTION indicates the user retains the same access. DENY indicates the user will have their access revoked as long as they are not assigned to a group through Group Rules.
        """
        return pulumi.get(self, "access_revoked")

    @_builtins.property
    @pulumi.getter(name="noResponse")
    def no_response(self) -> _builtins.str:
        """
        Specifies the action if the reviewer doesn't respond to the request.
        """
        return pulumi.get(self, "no_response")

    @_builtins.property
    @pulumi.getter(name="autoRemediationSettings")
    def auto_remediation_settings(self) -> Optional['outputs.GetCampaignRemediationSettingsAutoRemediationSettingsResult']:
        return pulumi.get(self, "auto_remediation_settings")


@pulumi.output_type
class GetCampaignRemediationSettingsAutoRemediationSettingsResult(dict):
    def __init__(__self__, *,
                 include_all_indirect_assignments: _builtins.bool,
                 include_onlies: Optional[Sequence['outputs.GetCampaignRemediationSettingsAutoRemediationSettingsIncludeOnlyResult']] = None):
        """
        :param _builtins.bool include_all_indirect_assignments: When a group is selected to be automatically remediated.
        :param Sequence['GetCampaignRemediationSettingsAutoRemediationSettingsIncludeOnlyArgs'] include_onlies: An array of resources to be automatically remediated.
        """
        pulumi.set(__self__, "include_all_indirect_assignments", include_all_indirect_assignments)
        if include_onlies is not None:
            pulumi.set(__self__, "include_onlies", include_onlies)

    @_builtins.property
    @pulumi.getter(name="includeAllIndirectAssignments")
    def include_all_indirect_assignments(self) -> _builtins.bool:
        """
        When a group is selected to be automatically remediated.
        """
        return pulumi.get(self, "include_all_indirect_assignments")

    @_builtins.property
    @pulumi.getter(name="includeOnlies")
    def include_onlies(self) -> Optional[Sequence['outputs.GetCampaignRemediationSettingsAutoRemediationSettingsIncludeOnlyResult']]:
        """
        An array of resources to be automatically remediated.
        """
        return pulumi.get(self, "include_onlies")


@pulumi.output_type
class GetCampaignRemediationSettingsAutoRemediationSettingsIncludeOnlyResult(dict):
    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str resource_id: The resource ID of the target resource When type = GROUP, it will point to the group ID.
        :param _builtins.str resource_type: The type of the resource to be automatically remediated. Only GROUP is supported.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource ID of the target resource When type = GROUP, it will point to the group ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the resource to be automatically remediated. Only GROUP is supported.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetCampaignResourceSettingsResult(dict):
    def __init__(__self__, *,
                 include_admin_roles: _builtins.bool,
                 include_entitlements: _builtins.bool,
                 individually_assigned_apps_only: _builtins.bool,
                 individually_assigned_groups_only: _builtins.bool,
                 only_include_out_of_policy_entitlements: _builtins.bool,
                 type: _builtins.str,
                 excluded_resources: Optional[Sequence['outputs.GetCampaignResourceSettingsExcludedResourceResult']] = None,
                 target_resources: Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceResult']] = None):
        """
        :param _builtins.bool include_admin_roles: Include admin roles.
        :param _builtins.bool include_entitlements: Include entitlements for this application.
        :param _builtins.bool individually_assigned_apps_only: Only include individually assigned groups.
        :param _builtins.bool individually_assigned_groups_only: Only include individually assigned groups.
        :param _builtins.bool only_include_out_of_policy_entitlements: Only include out-of-policy entitlements.
        :param _builtins.str type: The type of Okta resource.
        :param Sequence['GetCampaignResourceSettingsExcludedResourceArgs'] excluded_resources: An array of resources that are excluded from the review.
        :param Sequence['GetCampaignResourceSettingsTargetResourceArgs'] target_resources: Represents a resource that will be part of Access certifications.
        """
        pulumi.set(__self__, "include_admin_roles", include_admin_roles)
        pulumi.set(__self__, "include_entitlements", include_entitlements)
        pulumi.set(__self__, "individually_assigned_apps_only", individually_assigned_apps_only)
        pulumi.set(__self__, "individually_assigned_groups_only", individually_assigned_groups_only)
        pulumi.set(__self__, "only_include_out_of_policy_entitlements", only_include_out_of_policy_entitlements)
        pulumi.set(__self__, "type", type)
        if excluded_resources is not None:
            pulumi.set(__self__, "excluded_resources", excluded_resources)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)

    @_builtins.property
    @pulumi.getter(name="includeAdminRoles")
    def include_admin_roles(self) -> _builtins.bool:
        """
        Include admin roles.
        """
        return pulumi.get(self, "include_admin_roles")

    @_builtins.property
    @pulumi.getter(name="includeEntitlements")
    def include_entitlements(self) -> _builtins.bool:
        """
        Include entitlements for this application.
        """
        return pulumi.get(self, "include_entitlements")

    @_builtins.property
    @pulumi.getter(name="individuallyAssignedAppsOnly")
    def individually_assigned_apps_only(self) -> _builtins.bool:
        """
        Only include individually assigned groups.
        """
        return pulumi.get(self, "individually_assigned_apps_only")

    @_builtins.property
    @pulumi.getter(name="individuallyAssignedGroupsOnly")
    def individually_assigned_groups_only(self) -> _builtins.bool:
        """
        Only include individually assigned groups.
        """
        return pulumi.get(self, "individually_assigned_groups_only")

    @_builtins.property
    @pulumi.getter(name="onlyIncludeOutOfPolicyEntitlements")
    def only_include_out_of_policy_entitlements(self) -> _builtins.bool:
        """
        Only include out-of-policy entitlements.
        """
        return pulumi.get(self, "only_include_out_of_policy_entitlements")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Okta resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="excludedResources")
    def excluded_resources(self) -> Optional[Sequence['outputs.GetCampaignResourceSettingsExcludedResourceResult']]:
        """
        An array of resources that are excluded from the review.
        """
        return pulumi.get(self, "excluded_resources")

    @_builtins.property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceResult']]:
        """
        Represents a resource that will be part of Access certifications.
        """
        return pulumi.get(self, "target_resources")


@pulumi.output_type
class GetCampaignResourceSettingsExcludedResourceResult(dict):
    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str resource_id: Okta specific resource ID.
        :param _builtins.str resource_type: The type of Okta resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        Okta specific resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of Okta resource.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetCampaignResourceSettingsTargetResourceResult(dict):
    def __init__(__self__, *,
                 include_all_entitlements_and_bundles: _builtins.bool,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 entitlement_bundles: Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementBundleResult']] = None,
                 entitlements: Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementResult']] = None):
        """
        :param _builtins.bool include_all_entitlements_and_bundles: Include all entitlements and entitlement bundles for this application.
        :param _builtins.str resource_id: The resource ID that is being reviewed.
        :param _builtins.str resource_type: The type of Okta resource.
        :param Sequence['GetCampaignResourceSettingsTargetResourceEntitlementBundleArgs'] entitlement_bundles: An array of entitlement bundles associated with resourceId that should be chosen as target when creating reviews.
        """
        pulumi.set(__self__, "include_all_entitlements_and_bundles", include_all_entitlements_and_bundles)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if entitlement_bundles is not None:
            pulumi.set(__self__, "entitlement_bundles", entitlement_bundles)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)

    @_builtins.property
    @pulumi.getter(name="includeAllEntitlementsAndBundles")
    def include_all_entitlements_and_bundles(self) -> _builtins.bool:
        """
        Include all entitlements and entitlement bundles for this application.
        """
        return pulumi.get(self, "include_all_entitlements_and_bundles")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource ID that is being reviewed.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of Okta resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="entitlementBundles")
    def entitlement_bundles(self) -> Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementBundleResult']]:
        """
        An array of entitlement bundles associated with resourceId that should be chosen as target when creating reviews.
        """
        return pulumi.get(self, "entitlement_bundles")

    @_builtins.property
    @pulumi.getter
    def entitlements(self) -> Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementResult']]:
        return pulumi.get(self, "entitlements")


@pulumi.output_type
class GetCampaignResourceSettingsTargetResourceEntitlementResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 include_all_values: _builtins.bool,
                 values: Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementValueResult']] = None):
        """
        :param _builtins.str id: The ID of this resource.
        :param _builtins.bool include_all_values: Whether to include all values for this entitlement.
        :param Sequence['GetCampaignResourceSettingsTargetResourceEntitlementValueArgs'] values: Entitlement value ids
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include_all_values", include_all_values)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeAllValues")
    def include_all_values(self) -> _builtins.bool:
        """
        Whether to include all values for this entitlement.
        """
        return pulumi.get(self, "include_all_values")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.GetCampaignResourceSettingsTargetResourceEntitlementValueResult']]:
        """
        Entitlement value ids
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetCampaignResourceSettingsTargetResourceEntitlementBundleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of this resource.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetCampaignResourceSettingsTargetResourceEntitlementValueResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of this resource.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetCampaignReviewerSettingsResult(dict):
    def __init__(__self__, *,
                 bulk_decision_disabled: _builtins.bool,
                 fallback_reviewer_id: _builtins.str,
                 justification_required: _builtins.bool,
                 reassignment_disabled: _builtins.bool,
                 reviewer_group_id: _builtins.str,
                 reviewer_id: _builtins.str,
                 reviewer_scope_expression: _builtins.str,
                 self_review_disabled: _builtins.bool,
                 type: _builtins.str,
                 reviewer_levels: Optional[Sequence['outputs.GetCampaignReviewerSettingsReviewerLevelResult']] = None):
        pulumi.set(__self__, "bulk_decision_disabled", bulk_decision_disabled)
        pulumi.set(__self__, "fallback_reviewer_id", fallback_reviewer_id)
        pulumi.set(__self__, "justification_required", justification_required)
        pulumi.set(__self__, "reassignment_disabled", reassignment_disabled)
        pulumi.set(__self__, "reviewer_group_id", reviewer_group_id)
        pulumi.set(__self__, "reviewer_id", reviewer_id)
        pulumi.set(__self__, "reviewer_scope_expression", reviewer_scope_expression)
        pulumi.set(__self__, "self_review_disabled", self_review_disabled)
        pulumi.set(__self__, "type", type)
        if reviewer_levels is not None:
            pulumi.set(__self__, "reviewer_levels", reviewer_levels)

    @_builtins.property
    @pulumi.getter(name="bulkDecisionDisabled")
    def bulk_decision_disabled(self) -> _builtins.bool:
        return pulumi.get(self, "bulk_decision_disabled")

    @_builtins.property
    @pulumi.getter(name="fallbackReviewerId")
    def fallback_reviewer_id(self) -> _builtins.str:
        return pulumi.get(self, "fallback_reviewer_id")

    @_builtins.property
    @pulumi.getter(name="justificationRequired")
    def justification_required(self) -> _builtins.bool:
        return pulumi.get(self, "justification_required")

    @_builtins.property
    @pulumi.getter(name="reassignmentDisabled")
    def reassignment_disabled(self) -> _builtins.bool:
        return pulumi.get(self, "reassignment_disabled")

    @_builtins.property
    @pulumi.getter(name="reviewerGroupId")
    def reviewer_group_id(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_group_id")

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerScopeExpression")
    def reviewer_scope_expression(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_scope_expression")

    @_builtins.property
    @pulumi.getter(name="selfReviewDisabled")
    def self_review_disabled(self) -> _builtins.bool:
        return pulumi.get(self, "self_review_disabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="reviewerLevels")
    def reviewer_levels(self) -> Optional[Sequence['outputs.GetCampaignReviewerSettingsReviewerLevelResult']]:
        return pulumi.get(self, "reviewer_levels")


@pulumi.output_type
class GetCampaignReviewerSettingsReviewerLevelResult(dict):
    def __init__(__self__, *,
                 fallback_reviewer_id: _builtins.str,
                 reviewer_group_id: _builtins.str,
                 reviewer_id: _builtins.str,
                 reviewer_scope_expression: _builtins.str,
                 self_review_disabled: _builtins.bool,
                 type: _builtins.str,
                 start_reviews: Optional[Sequence['outputs.GetCampaignReviewerSettingsReviewerLevelStartReviewResult']] = None):
        pulumi.set(__self__, "fallback_reviewer_id", fallback_reviewer_id)
        pulumi.set(__self__, "reviewer_group_id", reviewer_group_id)
        pulumi.set(__self__, "reviewer_id", reviewer_id)
        pulumi.set(__self__, "reviewer_scope_expression", reviewer_scope_expression)
        pulumi.set(__self__, "self_review_disabled", self_review_disabled)
        pulumi.set(__self__, "type", type)
        if start_reviews is not None:
            pulumi.set(__self__, "start_reviews", start_reviews)

    @_builtins.property
    @pulumi.getter(name="fallbackReviewerId")
    def fallback_reviewer_id(self) -> _builtins.str:
        return pulumi.get(self, "fallback_reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerGroupId")
    def reviewer_group_id(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_group_id")

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerScopeExpression")
    def reviewer_scope_expression(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_scope_expression")

    @_builtins.property
    @pulumi.getter(name="selfReviewDisabled")
    def self_review_disabled(self) -> _builtins.bool:
        return pulumi.get(self, "self_review_disabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="startReviews")
    def start_reviews(self) -> Optional[Sequence['outputs.GetCampaignReviewerSettingsReviewerLevelStartReviewResult']]:
        return pulumi.get(self, "start_reviews")


@pulumi.output_type
class GetCampaignReviewerSettingsReviewerLevelStartReviewResult(dict):
    def __init__(__self__, *,
                 on_day: _builtins.int,
                 when: _builtins.str):
        pulumi.set(__self__, "on_day", on_day)
        pulumi.set(__self__, "when", when)

    @_builtins.property
    @pulumi.getter(name="onDay")
    def on_day(self) -> _builtins.int:
        return pulumi.get(self, "on_day")

    @_builtins.property
    @pulumi.getter
    def when(self) -> _builtins.str:
        return pulumi.get(self, "when")


@pulumi.output_type
class GetCampaignScheduleSettingsResult(dict):
    def __init__(__self__, *,
                 duration_in_days: _builtins.int,
                 end_date: _builtins.str,
                 start_date: _builtins.str,
                 time_zone: _builtins.str,
                 type: _builtins.str,
                 recurrences: Optional[Sequence['outputs.GetCampaignScheduleSettingsRecurrenceResult']] = None):
        pulumi.set(__self__, "duration_in_days", duration_in_days)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)
        if recurrences is not None:
            pulumi.set(__self__, "recurrences", recurrences)

    @_builtins.property
    @pulumi.getter(name="durationInDays")
    def duration_in_days(self) -> _builtins.int:
        return pulumi.get(self, "duration_in_days")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def recurrences(self) -> Optional[Sequence['outputs.GetCampaignScheduleSettingsRecurrenceResult']]:
        return pulumi.get(self, "recurrences")


@pulumi.output_type
class GetCampaignScheduleSettingsRecurrenceResult(dict):
    def __init__(__self__, *,
                 ends: _builtins.str,
                 interval: _builtins.str,
                 repeat_on_type: _builtins.str):
        pulumi.set(__self__, "ends", ends)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "repeat_on_type", repeat_on_type)

    @_builtins.property
    @pulumi.getter
    def ends(self) -> _builtins.str:
        return pulumi.get(self, "ends")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="repeatOnType")
    def repeat_on_type(self) -> _builtins.str:
        return pulumi.get(self, "repeat_on_type")


@pulumi.output_type
class GetCatalogEntryDefaultCountsResult(dict):
    def __init__(__self__, *,
                 resource_counts: Optional['outputs.GetCatalogEntryDefaultCountsResourceCountsResult'] = None):
        """
        :param 'GetCatalogEntryDefaultCountsResourceCountsArgs' resource_counts: Collection resource counts.
        """
        if resource_counts is not None:
            pulumi.set(__self__, "resource_counts", resource_counts)

    @_builtins.property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Optional['outputs.GetCatalogEntryDefaultCountsResourceCountsResult']:
        """
        Collection resource counts.
        """
        return pulumi.get(self, "resource_counts")


@pulumi.output_type
class GetCatalogEntryDefaultCountsResourceCountsResult(dict):
    def __init__(__self__, *,
                 applications: _builtins.int):
        """
        :param _builtins.int applications: Number of app resources in a collection.
        """
        pulumi.set(__self__, "applications", applications)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> _builtins.int:
        """
        Number of app resources in a collection.
        """
        return pulumi.get(self, "applications")


@pulumi.output_type
class GetCatalogEntryDefaultLinksResult(dict):
    def __init__(__self__, *,
                 self: Optional['outputs.GetCatalogEntryDefaultLinksSelfResult'] = None):
        """
        :param 'GetCatalogEntryDefaultLinksSelfArgs' self: A link to the catalog entry itself.
        """
        if self is not None:
            pulumi.set(__self__, "self", self)

    @_builtins.property
    @pulumi.getter
    def self(self) -> Optional['outputs.GetCatalogEntryDefaultLinksSelfResult']:
        """
        A link to the catalog entry itself.
        """
        return pulumi.get(self, "self")


@pulumi.output_type
class GetCatalogEntryDefaultLinksSelfResult(dict):
    def __init__(__self__, *,
                 href: _builtins.str):
        """
        :param _builtins.str href: Contains the absolute API URL for retrieving this catalog entry resource.
        """
        pulumi.set(__self__, "href", href)

    @_builtins.property
    @pulumi.getter
    def href(self) -> _builtins.str:
        """
        Contains the absolute API URL for retrieving this catalog entry resource.
        """
        return pulumi.get(self, "href")


@pulumi.output_type
class GetCatalogEntryUserAccessRequestFieldsDataResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 label: _builtins.str,
                 maximum_value: _builtins.str,
                 read_only: _builtins.bool,
                 required: _builtins.bool,
                 type: _builtins.str,
                 value: _builtins.str,
                 choices: Optional[Sequence['outputs.GetCatalogEntryUserAccessRequestFieldsDataChoiceResult']] = None):
        """
        :param _builtins.str label: Label of the requester field.
        :param _builtins.str maximum_value: The maximum value allowed for this field. Only applies to DURATION fields.
        :param _builtins.bool read_only: Indicates this field is immutable.
        :param _builtins.bool required: Indicates whether a value to this field is required to advance the request.
        :param _builtins.str type: Type of value for the requester field.
        :param _builtins.str value: An admin configured value for this field. Only applies to DURATION fields.
        :param Sequence['GetCatalogEntryUserAccessRequestFieldsDataChoiceArgs'] choices: Valid choices when type is SELECT or MULTISELECT.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "maximum_value", maximum_value)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if choices is not None:
            pulumi.set(__self__, "choices", choices)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label of the requester field.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="maximumValue")
    def maximum_value(self) -> _builtins.str:
        """
        The maximum value allowed for this field. Only applies to DURATION fields.
        """
        return pulumi.get(self, "maximum_value")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        Indicates this field is immutable.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        Indicates whether a value to this field is required to advance the request.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of value for the requester field.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        An admin configured value for this field. Only applies to DURATION fields.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def choices(self) -> Optional[Sequence['outputs.GetCatalogEntryUserAccessRequestFieldsDataChoiceResult']]:
        """
        Valid choices when type is SELECT or MULTISELECT.
        """
        return pulumi.get(self, "choices")


@pulumi.output_type
class GetCatalogEntryUserAccessRequestFieldsDataChoiceResult(dict):
    def __init__(__self__, *,
                 choice: _builtins.str):
        """
        :param _builtins.str choice: Valid choice.
        """
        pulumi.set(__self__, "choice", choice)

    @_builtins.property
    @pulumi.getter
    def choice(self) -> _builtins.str:
        """
        Valid choice.
        """
        return pulumi.get(self, "choice")


@pulumi.output_type
class GetDefaultSigninPageContentSecurityPolicySettingResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 report_uri: _builtins.str,
                 src_lists: Sequence[_builtins.str]):
        """
        :param _builtins.str mode: enforced or report_only
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "report_uri", report_uri)
        pulumi.set(__self__, "src_lists", src_lists)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> _builtins.str:
        return pulumi.get(self, "report_uri")

    @_builtins.property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class GetDefaultSigninPageWidgetCustomizationsResult(dict):
    def __init__(__self__, *,
                 authenticator_page_custom_link_label: _builtins.str,
                 authenticator_page_custom_link_url: _builtins.str,
                 classic_recovery_flow_email_or_username_label: _builtins.str,
                 custom_link1_label: _builtins.str,
                 custom_link1_url: _builtins.str,
                 custom_link2_label: _builtins.str,
                 custom_link2_url: _builtins.str,
                 forgot_password_label: _builtins.str,
                 forgot_password_url: _builtins.str,
                 help_label: _builtins.str,
                 help_url: _builtins.str,
                 password_info_tip: _builtins.str,
                 password_label: _builtins.str,
                 show_password_visibility_toggle: _builtins.bool,
                 show_user_identifier: _builtins.bool,
                 sign_in_label: _builtins.str,
                 unlock_account_label: _builtins.str,
                 unlock_account_url: _builtins.str,
                 username_info_tip: _builtins.str,
                 username_label: _builtins.str,
                 widget_generation: _builtins.str):
        pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        pulumi.set(__self__, "help_label", help_label)
        pulumi.set(__self__, "help_url", help_url)
        pulumi.set(__self__, "password_info_tip", password_info_tip)
        pulumi.set(__self__, "password_label", password_label)
        pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        pulumi.set(__self__, "sign_in_label", sign_in_label)
        pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        pulumi.set(__self__, "username_info_tip", username_info_tip)
        pulumi.set(__self__, "username_label", username_label)
        pulumi.set(__self__, "widget_generation", widget_generation)

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> _builtins.str:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @_builtins.property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> _builtins.str:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @_builtins.property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> _builtins.str:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> _builtins.str:
        return pulumi.get(self, "custom_link1_label")

    @_builtins.property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> _builtins.str:
        return pulumi.get(self, "custom_link1_url")

    @_builtins.property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> _builtins.str:
        return pulumi.get(self, "custom_link2_label")

    @_builtins.property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> _builtins.str:
        return pulumi.get(self, "custom_link2_url")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> _builtins.str:
        return pulumi.get(self, "forgot_password_label")

    @_builtins.property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> _builtins.str:
        return pulumi.get(self, "forgot_password_url")

    @_builtins.property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> _builtins.str:
        return pulumi.get(self, "help_label")

    @_builtins.property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> _builtins.str:
        return pulumi.get(self, "help_url")

    @_builtins.property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> _builtins.str:
        return pulumi.get(self, "password_info_tip")

    @_builtins.property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> _builtins.str:
        return pulumi.get(self, "password_label")

    @_builtins.property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> _builtins.bool:
        return pulumi.get(self, "show_password_visibility_toggle")

    @_builtins.property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> _builtins.bool:
        return pulumi.get(self, "show_user_identifier")

    @_builtins.property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> _builtins.str:
        return pulumi.get(self, "sign_in_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> _builtins.str:
        return pulumi.get(self, "unlock_account_label")

    @_builtins.property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> _builtins.str:
        return pulumi.get(self, "unlock_account_url")

    @_builtins.property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> _builtins.str:
        return pulumi.get(self, "username_info_tip")

    @_builtins.property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> _builtins.str:
        return pulumi.get(self, "username_label")

    @_builtins.property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> _builtins.str:
        return pulumi.get(self, "widget_generation")


@pulumi.output_type
class GetDeviceAssurancePolicyDiskEncryptionTypeResult(dict):
    def __init__(__self__, *,
                 includes: Sequence[_builtins.str]):
        pulumi.set(__self__, "includes", includes)

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetDeviceAssurancePolicyOsVersionResult(dict):
    def __init__(__self__, *,
                 dynamic_version_requirement: 'outputs.GetDeviceAssurancePolicyOsVersionDynamicVersionRequirementResult',
                 minimum: _builtins.str):
        pulumi.set(__self__, "dynamic_version_requirement", dynamic_version_requirement)
        pulumi.set(__self__, "minimum", minimum)

    @_builtins.property
    @pulumi.getter(name="dynamicVersionRequirement")
    def dynamic_version_requirement(self) -> 'outputs.GetDeviceAssurancePolicyOsVersionDynamicVersionRequirementResult':
        return pulumi.get(self, "dynamic_version_requirement")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> _builtins.str:
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GetDeviceAssurancePolicyOsVersionConstraintResult(dict):
    def __init__(__self__, *,
                 dynamic_version_requirement: 'outputs.GetDeviceAssurancePolicyOsVersionConstraintDynamicVersionRequirementResult',
                 major_version_constraint: _builtins.str):
        pulumi.set(__self__, "dynamic_version_requirement", dynamic_version_requirement)
        pulumi.set(__self__, "major_version_constraint", major_version_constraint)

    @_builtins.property
    @pulumi.getter(name="dynamicVersionRequirement")
    def dynamic_version_requirement(self) -> 'outputs.GetDeviceAssurancePolicyOsVersionConstraintDynamicVersionRequirementResult':
        return pulumi.get(self, "dynamic_version_requirement")

    @_builtins.property
    @pulumi.getter(name="majorVersionConstraint")
    def major_version_constraint(self) -> _builtins.str:
        return pulumi.get(self, "major_version_constraint")


@pulumi.output_type
class GetDeviceAssurancePolicyOsVersionConstraintDynamicVersionRequirementResult(dict):
    def __init__(__self__, *,
                 distance_from_latest_major: _builtins.int,
                 latest_security_patch: _builtins.bool,
                 type: _builtins.str):
        pulumi.set(__self__, "distance_from_latest_major", distance_from_latest_major)
        pulumi.set(__self__, "latest_security_patch", latest_security_patch)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="distanceFromLatestMajor")
    def distance_from_latest_major(self) -> _builtins.int:
        return pulumi.get(self, "distance_from_latest_major")

    @_builtins.property
    @pulumi.getter(name="latestSecurityPatch")
    def latest_security_patch(self) -> _builtins.bool:
        return pulumi.get(self, "latest_security_patch")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDeviceAssurancePolicyOsVersionDynamicVersionRequirementResult(dict):
    def __init__(__self__, *,
                 distance_from_latest_major: _builtins.int,
                 latest_security_patch: _builtins.bool,
                 type: _builtins.str):
        pulumi.set(__self__, "distance_from_latest_major", distance_from_latest_major)
        pulumi.set(__self__, "latest_security_patch", latest_security_patch)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="distanceFromLatestMajor")
    def distance_from_latest_major(self) -> _builtins.int:
        return pulumi.get(self, "distance_from_latest_major")

    @_builtins.property
    @pulumi.getter(name="latestSecurityPatch")
    def latest_security_patch(self) -> _builtins.bool:
        return pulumi.get(self, "latest_security_patch")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDeviceAssurancePolicyScreenlockTypeResult(dict):
    def __init__(__self__, *,
                 includes: Sequence[_builtins.str]):
        pulumi.set(__self__, "includes", includes)

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetDeviceAssurancePolicyThirdPartySignalProviderResult(dict):
    def __init__(__self__, *,
                 dtc: 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcResult'):
        pulumi.set(__self__, "dtc", dtc)

    @_builtins.property
    @pulumi.getter
    def dtc(self) -> 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcResult':
        return pulumi.get(self, "dtc")


@pulumi.output_type
class GetDeviceAssurancePolicyThirdPartySignalProviderDtcResult(dict):
    def __init__(__self__, *,
                 allow_screen_lock: _builtins.bool,
                 browser_version: 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcBrowserVersionResult',
                 built_in_dns_client_enabled: _builtins.bool,
                 chrome_remote_desktop_app_blocked: _builtins.bool,
                 crowd_strike_agent_id: _builtins.str,
                 crowd_strike_customer_id: _builtins.str,
                 device_enrollment_domain: _builtins.str,
                 disk_encrypted: _builtins.bool,
                 key_trust_level: _builtins.str,
                 managed_device: _builtins.bool,
                 os_firewall: _builtins.bool,
                 os_version: 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcOsVersionResult',
                 password_protection_warning_trigger: _builtins.str,
                 realtime_url_check_mode: _builtins.bool,
                 safe_browsing_protection_level: _builtins.str,
                 screen_lock_secured: _builtins.bool,
                 site_isolation_enabled: _builtins.bool,
                 third_party_blocking_enabled: _builtins.bool,
                 windows_machine_domain: _builtins.str,
                 windows_user_domain: _builtins.str):
        pulumi.set(__self__, "allow_screen_lock", allow_screen_lock)
        pulumi.set(__self__, "browser_version", browser_version)
        pulumi.set(__self__, "built_in_dns_client_enabled", built_in_dns_client_enabled)
        pulumi.set(__self__, "chrome_remote_desktop_app_blocked", chrome_remote_desktop_app_blocked)
        pulumi.set(__self__, "crowd_strike_agent_id", crowd_strike_agent_id)
        pulumi.set(__self__, "crowd_strike_customer_id", crowd_strike_customer_id)
        pulumi.set(__self__, "device_enrollment_domain", device_enrollment_domain)
        pulumi.set(__self__, "disk_encrypted", disk_encrypted)
        pulumi.set(__self__, "key_trust_level", key_trust_level)
        pulumi.set(__self__, "managed_device", managed_device)
        pulumi.set(__self__, "os_firewall", os_firewall)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "password_protection_warning_trigger", password_protection_warning_trigger)
        pulumi.set(__self__, "realtime_url_check_mode", realtime_url_check_mode)
        pulumi.set(__self__, "safe_browsing_protection_level", safe_browsing_protection_level)
        pulumi.set(__self__, "screen_lock_secured", screen_lock_secured)
        pulumi.set(__self__, "site_isolation_enabled", site_isolation_enabled)
        pulumi.set(__self__, "third_party_blocking_enabled", third_party_blocking_enabled)
        pulumi.set(__self__, "windows_machine_domain", windows_machine_domain)
        pulumi.set(__self__, "windows_user_domain", windows_user_domain)

    @_builtins.property
    @pulumi.getter(name="allowScreenLock")
    def allow_screen_lock(self) -> _builtins.bool:
        return pulumi.get(self, "allow_screen_lock")

    @_builtins.property
    @pulumi.getter(name="browserVersion")
    def browser_version(self) -> 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcBrowserVersionResult':
        return pulumi.get(self, "browser_version")

    @_builtins.property
    @pulumi.getter(name="builtInDnsClientEnabled")
    def built_in_dns_client_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "built_in_dns_client_enabled")

    @_builtins.property
    @pulumi.getter(name="chromeRemoteDesktopAppBlocked")
    def chrome_remote_desktop_app_blocked(self) -> _builtins.bool:
        return pulumi.get(self, "chrome_remote_desktop_app_blocked")

    @_builtins.property
    @pulumi.getter(name="crowdStrikeAgentId")
    def crowd_strike_agent_id(self) -> _builtins.str:
        return pulumi.get(self, "crowd_strike_agent_id")

    @_builtins.property
    @pulumi.getter(name="crowdStrikeCustomerId")
    def crowd_strike_customer_id(self) -> _builtins.str:
        return pulumi.get(self, "crowd_strike_customer_id")

    @_builtins.property
    @pulumi.getter(name="deviceEnrollmentDomain")
    def device_enrollment_domain(self) -> _builtins.str:
        return pulumi.get(self, "device_enrollment_domain")

    @_builtins.property
    @pulumi.getter(name="diskEncrypted")
    def disk_encrypted(self) -> _builtins.bool:
        return pulumi.get(self, "disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="keyTrustLevel")
    def key_trust_level(self) -> _builtins.str:
        return pulumi.get(self, "key_trust_level")

    @_builtins.property
    @pulumi.getter(name="managedDevice")
    def managed_device(self) -> _builtins.bool:
        return pulumi.get(self, "managed_device")

    @_builtins.property
    @pulumi.getter(name="osFirewall")
    def os_firewall(self) -> _builtins.bool:
        return pulumi.get(self, "os_firewall")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> 'outputs.GetDeviceAssurancePolicyThirdPartySignalProviderDtcOsVersionResult':
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="passwordProtectionWarningTrigger")
    def password_protection_warning_trigger(self) -> _builtins.str:
        return pulumi.get(self, "password_protection_warning_trigger")

    @_builtins.property
    @pulumi.getter(name="realtimeUrlCheckMode")
    def realtime_url_check_mode(self) -> _builtins.bool:
        return pulumi.get(self, "realtime_url_check_mode")

    @_builtins.property
    @pulumi.getter(name="safeBrowsingProtectionLevel")
    def safe_browsing_protection_level(self) -> _builtins.str:
        return pulumi.get(self, "safe_browsing_protection_level")

    @_builtins.property
    @pulumi.getter(name="screenLockSecured")
    def screen_lock_secured(self) -> _builtins.bool:
        return pulumi.get(self, "screen_lock_secured")

    @_builtins.property
    @pulumi.getter(name="siteIsolationEnabled")
    def site_isolation_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "site_isolation_enabled")

    @_builtins.property
    @pulumi.getter(name="thirdPartyBlockingEnabled")
    def third_party_blocking_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "third_party_blocking_enabled")

    @_builtins.property
    @pulumi.getter(name="windowsMachineDomain")
    def windows_machine_domain(self) -> _builtins.str:
        return pulumi.get(self, "windows_machine_domain")

    @_builtins.property
    @pulumi.getter(name="windowsUserDomain")
    def windows_user_domain(self) -> _builtins.str:
        return pulumi.get(self, "windows_user_domain")


@pulumi.output_type
class GetDeviceAssurancePolicyThirdPartySignalProviderDtcBrowserVersionResult(dict):
    def __init__(__self__, *,
                 minimum: _builtins.str):
        pulumi.set(__self__, "minimum", minimum)

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> _builtins.str:
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GetDeviceAssurancePolicyThirdPartySignalProviderDtcOsVersionResult(dict):
    def __init__(__self__, *,
                 minimum: _builtins.str):
        pulumi.set(__self__, "minimum", minimum)

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> _builtins.str:
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GetDomainDnsRecordResult(dict):
    def __init__(__self__, *,
                 expiration: _builtins.str,
                 fqdn: _builtins.str,
                 record_type: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str expiration: TXT record expiration
        :param _builtins.str fqdn: DNS record name
        :param _builtins.str record_type: Record type can be TXT or CNAME
        :param Sequence[_builtins.str] values: DNS verification value
        """
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> _builtins.str:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        DNS verification value
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetEmailCustomizationsEmailCustomizationResult(dict):
    def __init__(__self__, *,
                 body: _builtins.str,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 language: _builtins.str,
                 links: _builtins.str,
                 subject: _builtins.str):
        """
        :param _builtins.str body: The body of the customization
        :param _builtins.str id: The ID of the customization
        :param _builtins.bool is_default: Whether the customization is the default
        :param _builtins.str language: The language supported by the customization
        :param _builtins.str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param _builtins.str subject: The subject of the customization
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def body(self) -> _builtins.str:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the customization
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether the customization is the default
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetEndUserMyRequestsRequestedResult(dict):
    def __init__(__self__, *,
                 access_scope_id: _builtins.str,
                 access_scope_type: _builtins.str,
                 entry_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str access_scope_id: ID of the access scope
        :param _builtins.str access_scope_type: The access scope type
        :param _builtins.str entry_id: The ID of the catalog entry for which the request was made.
        :param _builtins.str resource_id: The requested resource ID
        :param _builtins.str resource_type: The requested resource type.
        """
        pulumi.set(__self__, "access_scope_id", access_scope_id)
        pulumi.set(__self__, "access_scope_type", access_scope_type)
        pulumi.set(__self__, "entry_id", entry_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="accessScopeId")
    def access_scope_id(self) -> _builtins.str:
        """
        ID of the access scope
        """
        return pulumi.get(self, "access_scope_id")

    @_builtins.property
    @pulumi.getter(name="accessScopeType")
    def access_scope_type(self) -> _builtins.str:
        """
        The access scope type
        """
        return pulumi.get(self, "access_scope_type")

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> _builtins.str:
        """
        The ID of the catalog entry for which the request was made.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The requested resource ID
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The requested resource type.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetEndUserMyRequestsRequestedByResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta user id
        :param _builtins.str type: The type of principal
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta user id
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEndUserMyRequestsRequestedForResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta user id
        :param _builtins.str type: The type of principal
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta user id
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEndUserMyRequestsRequesterFieldValueResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 label: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: The ID of the requester field.
        :param _builtins.str label: A human-readable description of the requester field.
        :param _builtins.str type: Type of value for the requester field. Valid values: `DURATION`, `ISO_DATE`, `MULTISELECT`, `OKTA_USER_ID`, `SELECT`, `TEXT`.
        :param _builtins.str value: The value of the requester field (for single-value fields).
        :param Sequence[_builtins.str] values: The values of the requester field (for MULTISELECT type fields).
        """
        pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the requester field.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        A human-readable description of the requester field.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of value for the requester field. Valid values: `DURATION`, `ISO_DATE`, `MULTISELECT`, `OKTA_USER_ID`, `SELECT`, `TEXT`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the requester field (for single-value fields).
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The values of the requester field (for MULTISELECT type fields).
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetEndUserMyRequestsRiskAssessmentResult(dict):
    def __init__(__self__, *,
                 request_submission_type: Optional[_builtins.str] = None,
                 risk_rules: Optional[Sequence['outputs.GetEndUserMyRequestsRiskAssessmentRiskRuleResult']] = None):
        """
        :param _builtins.str request_submission_type: Whether request submission is allowed or restricted in the risk settings.
        :param Sequence['GetEndUserMyRequestsRiskAssessmentRiskRuleArgs'] risk_rules: An array of resources that are excluded from the review.
        """
        if request_submission_type is not None:
            pulumi.set(__self__, "request_submission_type", request_submission_type)
        if risk_rules is not None:
            pulumi.set(__self__, "risk_rules", risk_rules)

    @_builtins.property
    @pulumi.getter(name="requestSubmissionType")
    def request_submission_type(self) -> Optional[_builtins.str]:
        """
        Whether request submission is allowed or restricted in the risk settings.
        """
        return pulumi.get(self, "request_submission_type")

    @_builtins.property
    @pulumi.getter(name="riskRules")
    def risk_rules(self) -> Optional[Sequence['outputs.GetEndUserMyRequestsRiskAssessmentRiskRuleResult']]:
        """
        An array of resources that are excluded from the review.
        """
        return pulumi.get(self, "risk_rules")


@pulumi.output_type
class GetEndUserMyRequestsRiskAssessmentRiskRuleResult(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 resource_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The human readable description.
        :param _builtins.str name: The name of a resource rule causing a conflict.
        :param _builtins.str resource_name: Human readable name of the resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The human readable description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of a resource rule causing a conflict.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        Human readable name of the resource.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetEntitlementBundleEntitlementResult(dict):
    def __init__(__self__, *,
                 data_type: _builtins.str,
                 description: _builtins.str,
                 external_value: _builtins.str,
                 id: _builtins.str,
                 multi_value: _builtins.bool,
                 name: _builtins.str,
                 required: _builtins.bool,
                 values: Optional[Sequence['outputs.GetEntitlementBundleEntitlementValueResult']] = None):
        """
        :param _builtins.str data_type: The data type of the entitlement property.
        :param _builtins.str description: The description of an entitlement property.
        :param _builtins.str external_value: The value of an entitlement property.
        :param _builtins.str id: The ID of this resource.
        :param _builtins.bool multi_value: The property that determines if the entitlement property can hold multiple values.
        :param _builtins.str name: The display name for an entitlement bundle.
        :param _builtins.bool required: The property that determines if the entitlement property is a required attribute.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_value", multi_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> _builtins.str:
        """
        The data type of the entitlement property.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> _builtins.str:
        """
        The value of an entitlement property.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiValue")
    def multi_value(self) -> _builtins.bool:
        """
        The property that determines if the entitlement property can hold multiple values.
        """
        return pulumi.get(self, "multi_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        The property that determines if the entitlement property is a required attribute.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.GetEntitlementBundleEntitlementValueResult']]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetEntitlementBundleEntitlementValueResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 external_id: _builtins.str,
                 external_value: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: The description of an entitlement property.
        :param _builtins.str external_id: The read-only id of an entitlement property value in the downstream application.
        :param _builtins.str external_value: The value of an entitlement property value.
        :param _builtins.str id: The ID of this resource.
        :param _builtins.str name: The display name for an entitlement bundle.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The read-only id of an entitlement property value in the downstream application.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> _builtins.str:
        """
        The value of an entitlement property value.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The display name for an entitlement bundle.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetEntitlementBundleTargetResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta app.id of the resource.
        :param _builtins.str type: The type of the resource.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta app.id of the resource.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEntitlementParentResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta app.id of the resource.
        :param _builtins.str type: The type of resource.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta app.id of the resource.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEntitlementValueResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 external_id: _builtins.str,
                 external_value: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: The description of an entitlement value.
        :param _builtins.str external_id: The id of the entitlement value.
        :param _builtins.str external_value: The value of an entitlement property value.
        :param _builtins.str id: The ID of this resource.
        :param _builtins.str name: The name of the entitlement value.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement value.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The id of the entitlement value.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> _builtins.str:
        """
        The value of an entitlement property value.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the entitlement value.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetFeaturesFeatureResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 stage: 'outputs.GetFeaturesFeatureStageResult',
                 status: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> 'outputs.GetFeaturesFeatureStageResult':
        return pulumi.get(self, "stage")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFeaturesFeatureStageResult(dict):
    def __init__(__self__, *,
                 state: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 custom_profile_attributes: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 source: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str custom_profile_attributes: Raw JSON containing all custom profile attributes. Likely only useful on groups of type
        :param _builtins.str description: Group description.
        :param _builtins.str id: Group ID.
        :param _builtins.str name: Group name.
        :param _builtins.str source: The ID of the application the Group is sourced/imported from (only present for groups of type APP_GROUP).
        :param _builtins.str type: Group type, either 'APP_GROUP' or 'OKTA_GROUP'.
        """
        pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> _builtins.str:
        """
        Raw JSON containing all custom profile attributes. Likely only useful on groups of type
        """
        return pulumi.get(self, "custom_profile_attributes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The ID of the application the Group is sourced/imported from (only present for groups of type APP_GROUP).
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Group type, either 'APP_GROUP' or 'OKTA_GROUP'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLogStreamSettingsResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 edition: _builtins.str,
                 event_source_name: _builtins.str,
                 host: _builtins.str,
                 region: _builtins.str,
                 token: _builtins.str):
        """
        :param _builtins.str account_id: AWS account ID. Required only for 'aws_eventbridge' type
        :param _builtins.str edition: Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        :param _builtins.str event_source_name: An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        :param _builtins.str host: The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        :param _builtins.str region: The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        :param _builtins.str token: The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "event_source_name", event_source_name)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        AWS account ID. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> _builtins.str:
        """
        An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "event_source_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetOrgMetadataDomainsResult(dict):
    def __init__(__self__, *,
                 alternate: _builtins.str,
                 organization: _builtins.str):
        """
        :param _builtins.str alternate: Custom Domain Org URI
        :param _builtins.str organization: Standard Org URI
        """
        pulumi.set(__self__, "alternate", alternate)
        pulumi.set(__self__, "organization", organization)

    @_builtins.property
    @pulumi.getter
    def alternate(self) -> _builtins.str:
        """
        Custom Domain Org URI
        """
        return pulumi.get(self, "alternate")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> _builtins.str:
        """
        Standard Org URI
        """
        return pulumi.get(self, "organization")


@pulumi.output_type
class GetOrgMetadataSettingsResult(dict):
    def __init__(__self__, *,
                 analytics_collection_enabled: _builtins.bool,
                 bug_reporting_enabled: _builtins.bool,
                 om_enabled: _builtins.bool):
        """
        :param _builtins.bool om_enabled: Whether the legacy Okta Mobile application is enabled for the org
        """
        pulumi.set(__self__, "analytics_collection_enabled", analytics_collection_enabled)
        pulumi.set(__self__, "bug_reporting_enabled", bug_reporting_enabled)
        pulumi.set(__self__, "om_enabled", om_enabled)

    @_builtins.property
    @pulumi.getter(name="analyticsCollectionEnabled")
    def analytics_collection_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "analytics_collection_enabled")

    @_builtins.property
    @pulumi.getter(name="bugReportingEnabled")
    def bug_reporting_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "bug_reporting_enabled")

    @_builtins.property
    @pulumi.getter(name="omEnabled")
    def om_enabled(self) -> _builtins.bool:
        """
        Whether the legacy Okta Mobile application is enabled for the org
        """
        return pulumi.get(self, "om_enabled")


@pulumi.output_type
class GetPrincipalEntitlementsDataResult(dict):
    def __init__(__self__, *,
                 data_type: _builtins.str,
                 description: _builtins.str,
                 external_value: _builtins.str,
                 id: _builtins.str,
                 multi_value: _builtins.bool,
                 name: _builtins.str,
                 parent_resource_orn: _builtins.str,
                 required: _builtins.bool,
                 target_principal_orn: _builtins.str,
                 parent: Optional['outputs.GetPrincipalEntitlementsDataParentResult'] = None,
                 target_principal: Optional['outputs.GetPrincipalEntitlementsDataTargetPrincipalResult'] = None,
                 values: Optional[Sequence['outputs.GetPrincipalEntitlementsDataValueResult']] = None):
        """
        :param _builtins.str data_type: The data type of the entitlement property.
        :param _builtins.str description: The description of an entitlement property.
        :param _builtins.str external_value: The value of an entitlement property.
        :param _builtins.str id: The id property of an entitlement.
        :param _builtins.bool multi_value: The property that determines if the entitlement property can hold multiple values.
        :param _builtins.str name: The display name for an entitlement property.
        :param _builtins.str parent_resource_orn: The Okta app instance, in ORN format.
        :param _builtins.bool required: The property that determines if the entitlement property is a required attribute
        :param _builtins.str target_principal_orn: The Okta user id in ORN format.
        :param 'GetPrincipalEntitlementsDataParentArgs' parent: Representation of a resource.
        :param 'GetPrincipalEntitlementsDataTargetPrincipalArgs' target_principal: Representation of a principal.
        :param Sequence['GetPrincipalEntitlementsDataValueArgs'] values: Collection of entitlement values.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_value", multi_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent_resource_orn", parent_resource_orn)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "target_principal_orn", target_principal_orn)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if target_principal is not None:
            pulumi.set(__self__, "target_principal", target_principal)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> _builtins.str:
        """
        The data type of the entitlement property.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> _builtins.str:
        """
        The value of an entitlement property.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id property of an entitlement.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiValue")
    def multi_value(self) -> _builtins.bool:
        """
        The property that determines if the entitlement property can hold multiple values.
        """
        return pulumi.get(self, "multi_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The display name for an entitlement property.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentResourceOrn")
    def parent_resource_orn(self) -> _builtins.str:
        """
        The Okta app instance, in ORN format.
        """
        return pulumi.get(self, "parent_resource_orn")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        The property that determines if the entitlement property is a required attribute
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter(name="targetPrincipalOrn")
    def target_principal_orn(self) -> _builtins.str:
        """
        The Okta user id in ORN format.
        """
        return pulumi.get(self, "target_principal_orn")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional['outputs.GetPrincipalEntitlementsDataParentResult']:
        """
        Representation of a resource.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="targetPrincipal")
    def target_principal(self) -> Optional['outputs.GetPrincipalEntitlementsDataTargetPrincipalResult']:
        """
        Representation of a principal.
        """
        return pulumi.get(self, "target_principal")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.GetPrincipalEntitlementsDataValueResult']]:
        """
        Collection of entitlement values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPrincipalEntitlementsDataParentResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta id of the resource.
        :param _builtins.str type: The type of the resource.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta id of the resource.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrincipalEntitlementsDataTargetPrincipalResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta user id.
        :param _builtins.str type: The type of principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta user id.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrincipalEntitlementsDataValueResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 external_value: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: The description of an entitlement property.
        :param _builtins.str external_value: The value of an entitlement property value.
        :param _builtins.str id: The id of an entitlement value.
        :param _builtins.str name: The name of an entitlement value.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_value", external_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an entitlement property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> _builtins.str:
        """
        The value of an entitlement property value.
        """
        return pulumi.get(self, "external_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of an entitlement value.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of an entitlement value.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPrincipalEntitlementsParentResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrincipalEntitlementsTargetPrincipalResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestConditionAccessScopeSettingsResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 ids: Optional[Sequence['outputs.GetRequestConditionAccessScopeSettingsIdResult']] = None):
        """
        :param Sequence['GetRequestConditionAccessScopeSettingsIdArgs'] ids: Block list of groups/entitlement bundles ids.
        """
        pulumi.set(__self__, "type", type)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GetRequestConditionAccessScopeSettingsIdResult']]:
        """
        Block list of groups/entitlement bundles ids.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class GetRequestConditionAccessScopeSettingsIdResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Request condition id.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRequestConditionRequesterSettingsResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 ids: Optional[Sequence['outputs.GetRequestConditionRequesterSettingsIdResult']] = None):
        """
        :param Sequence['GetRequestConditionRequesterSettingsIdArgs'] ids: Block list of teams/groups ids.
        """
        pulumi.set(__self__, "type", type)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GetRequestConditionRequesterSettingsIdResult']]:
        """
        Block list of teams/groups ids.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class GetRequestConditionRequesterSettingsIdResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Request condition id.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Request condition id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRequestSettingOrganizationRequestExperienceResult(dict):
    def __init__(__self__, *,
                 experience_type: _builtins.str):
        pulumi.set(__self__, "experience_type", experience_type)

    @_builtins.property
    @pulumi.getter(name="experienceType")
    def experience_type(self) -> _builtins.str:
        return pulumi.get(self, "experience_type")


@pulumi.output_type
class GetRequestSettingResourceRequestOnBehalfOfSettingsResult(dict):
    def __init__(__self__, *,
                 allowed: _builtins.bool,
                 only_fors: Optional[Sequence['outputs.GetRequestSettingResourceRequestOnBehalfOfSettingsOnlyForResult']] = None):
        pulumi.set(__self__, "allowed", allowed)
        if only_fors is not None:
            pulumi.set(__self__, "only_fors", only_fors)

    @_builtins.property
    @pulumi.getter
    def allowed(self) -> _builtins.bool:
        return pulumi.get(self, "allowed")

    @_builtins.property
    @pulumi.getter(name="onlyFors")
    def only_fors(self) -> Optional[Sequence['outputs.GetRequestSettingResourceRequestOnBehalfOfSettingsOnlyForResult']]:
        return pulumi.get(self, "only_fors")


@pulumi.output_type
class GetRequestSettingResourceRequestOnBehalfOfSettingsOnlyForResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestSettingResourceRiskSettingsResult(dict):
    def __init__(__self__, *,
                 default_setting: Optional['outputs.GetRequestSettingResourceRiskSettingsDefaultSettingResult'] = None):
        """
        :param 'GetRequestSettingResourceRiskSettingsDefaultSettingArgs' default_setting: Default risk settings that are valid for an access request when a risk has been detected for the resource and requesting user.
        """
        if default_setting is not None:
            pulumi.set(__self__, "default_setting", default_setting)

    @_builtins.property
    @pulumi.getter(name="defaultSetting")
    def default_setting(self) -> Optional['outputs.GetRequestSettingResourceRiskSettingsDefaultSettingResult']:
        """
        Default risk settings that are valid for an access request when a risk has been detected for the resource and requesting user.
        """
        return pulumi.get(self, "default_setting")


@pulumi.output_type
class GetRequestSettingResourceRiskSettingsDefaultSettingResult(dict):
    def __init__(__self__, *,
                 approval_sequence_id: _builtins.str,
                 errors: Sequence[_builtins.str],
                 request_submission_type: _builtins.str,
                 access_duration_settings: Optional['outputs.GetRequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettingsResult'] = None):
        pulumi.set(__self__, "approval_sequence_id", approval_sequence_id)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "request_submission_type", request_submission_type)
        if access_duration_settings is not None:
            pulumi.set(__self__, "access_duration_settings", access_duration_settings)

    @_builtins.property
    @pulumi.getter(name="approvalSequenceId")
    def approval_sequence_id(self) -> _builtins.str:
        return pulumi.get(self, "approval_sequence_id")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter(name="requestSubmissionType")
    def request_submission_type(self) -> _builtins.str:
        return pulumi.get(self, "request_submission_type")

    @_builtins.property
    @pulumi.getter(name="accessDurationSettings")
    def access_duration_settings(self) -> Optional['outputs.GetRequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettingsResult']:
        return pulumi.get(self, "access_duration_settings")


@pulumi.output_type
class GetRequestSettingResourceRiskSettingsDefaultSettingAccessDurationSettingsResult(dict):
    def __init__(__self__, *,
                 duration: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestSettingResourceValidAccessDurationSettingsResult(dict):
    def __init__(__self__, *,
                 maximum_days: _builtins.float,
                 maximum_hours: _builtins.float,
                 maximum_weeks: _builtins.float,
                 required: _builtins.bool,
                 supported_types: Optional[Sequence['outputs.GetRequestSettingResourceValidAccessDurationSettingsSupportedTypeResult']] = None):
        """
        :param _builtins.float maximum_days: The maximum value allowed for a request condition or risk setting.
        :param _builtins.float maximum_hours: The maximum value allowed for a request condition or risk setting.
        :param _builtins.float maximum_weeks: The maximum value allowed for a request condition or risk setting.
        :param _builtins.bool required: Whether accessDurationSetting must be included in the request conditions or risk settings for the specified resource.
        :param Sequence['GetRequestSettingResourceValidAccessDurationSettingsSupportedTypeArgs'] supported_types: Access duration settings that are eligible to be added to a request condition or risk settings for the specified resource.
        """
        pulumi.set(__self__, "maximum_days", maximum_days)
        pulumi.set(__self__, "maximum_hours", maximum_hours)
        pulumi.set(__self__, "maximum_weeks", maximum_weeks)
        pulumi.set(__self__, "required", required)
        if supported_types is not None:
            pulumi.set(__self__, "supported_types", supported_types)

    @_builtins.property
    @pulumi.getter(name="maximumDays")
    def maximum_days(self) -> _builtins.float:
        """
        The maximum value allowed for a request condition or risk setting.
        """
        return pulumi.get(self, "maximum_days")

    @_builtins.property
    @pulumi.getter(name="maximumHours")
    def maximum_hours(self) -> _builtins.float:
        """
        The maximum value allowed for a request condition or risk setting.
        """
        return pulumi.get(self, "maximum_hours")

    @_builtins.property
    @pulumi.getter(name="maximumWeeks")
    def maximum_weeks(self) -> _builtins.float:
        """
        The maximum value allowed for a request condition or risk setting.
        """
        return pulumi.get(self, "maximum_weeks")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        Whether accessDurationSetting must be included in the request conditions or risk settings for the specified resource.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter(name="supportedTypes")
    def supported_types(self) -> Optional[Sequence['outputs.GetRequestSettingResourceValidAccessDurationSettingsSupportedTypeResult']]:
        """
        Access duration settings that are eligible to be added to a request condition or risk settings for the specified resource.
        """
        return pulumi.get(self, "supported_types")


@pulumi.output_type
class GetRequestSettingResourceValidAccessDurationSettingsSupportedTypeResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestSettingResourceValidAccessScopeSettingResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestSettingResourceValidRequesterSettingResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestV2RequestedResult(dict):
    def __init__(__self__, *,
                 access_scope_id: _builtins.str,
                 access_scope_type: _builtins.str,
                 entry_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str access_scope_id: The ID of the access scope associated with the resource.
        :param _builtins.str access_scope_type: The access scope type.
        :param _builtins.str entry_id: The ID of the resource catalog entry.
        :param _builtins.str resource_id: The ID of the requested resource.
        :param _builtins.str resource_type: The requested resource type.
        :param _builtins.str type: The type of the resource.
        """
        pulumi.set(__self__, "access_scope_id", access_scope_id)
        pulumi.set(__self__, "access_scope_type", access_scope_type)
        pulumi.set(__self__, "entry_id", entry_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessScopeId")
    def access_scope_id(self) -> _builtins.str:
        """
        The ID of the access scope associated with the resource.
        """
        return pulumi.get(self, "access_scope_id")

    @_builtins.property
    @pulumi.getter(name="accessScopeType")
    def access_scope_type(self) -> _builtins.str:
        """
        The access scope type.
        """
        return pulumi.get(self, "access_scope_type")

    @_builtins.property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> _builtins.str:
        """
        The ID of the resource catalog entry.
        """
        return pulumi.get(self, "entry_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the requested resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The requested resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestV2RequestedByResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The Okta user id.
        :param _builtins.str type: The type of principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The Okta user id.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRequestV2RequestedForResult(dict):
    def __init__(__self__, *,
                 external_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str external_id: The ID of the Okta user.
        :param _builtins.str type: The type of principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The ID of the Okta user.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of principal.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetReviewAllReviewerLevelResult(dict):
    def __init__(__self__, *,
                 created: _builtins.str,
                 created_by: _builtins.str,
                 decision: _builtins.str,
                 id: _builtins.str,
                 last_updated: _builtins.str,
                 last_updated_by: _builtins.str,
                 reviewer_level: _builtins.str,
                 reviewer_type: _builtins.str,
                 reviewer_group_profile: Optional['outputs.GetReviewAllReviewerLevelReviewerGroupProfileResult'] = None,
                 reviewer_profile: Optional['outputs.GetReviewAllReviewerLevelReviewerProfileResult'] = None):
        """
        :param _builtins.str created: The ISO 8601 formatted date and time when the resource was created.
        :param _builtins.str created_by: The id of user who created the resource.
        :param _builtins.str decision: The decision taken by the reviewer. Will be `UNASSIGNED` if no decision is made.
        :param _builtins.str id: The ID of  review.
        :param _builtins.str last_updated: The ISO 8601 formatted date and time when the object was last updated.
        :param _builtins.str last_updated_by: The id of user who last updated the object.
        :param _builtins.str reviewer_type: The type of reviewer to which the review is assigned.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        pulumi.set(__self__, "reviewer_level", reviewer_level)
        pulumi.set(__self__, "reviewer_type", reviewer_type)
        if reviewer_group_profile is not None:
            pulumi.set(__self__, "reviewer_group_profile", reviewer_group_profile)
        if reviewer_profile is not None:
            pulumi.set(__self__, "reviewer_profile", reviewer_profile)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The ISO 8601 formatted date and time when the resource was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of user who created the resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> _builtins.str:
        """
        The decision taken by the reviewer. Will be `UNASSIGNED` if no decision is made.
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The ISO 8601 formatted date and time when the object was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        The id of user who last updated the object.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="reviewerLevel")
    def reviewer_level(self) -> _builtins.str:
        return pulumi.get(self, "reviewer_level")

    @_builtins.property
    @pulumi.getter(name="reviewerType")
    def reviewer_type(self) -> _builtins.str:
        """
        The type of reviewer to which the review is assigned.
        """
        return pulumi.get(self, "reviewer_type")

    @_builtins.property
    @pulumi.getter(name="reviewerGroupProfile")
    def reviewer_group_profile(self) -> Optional['outputs.GetReviewAllReviewerLevelReviewerGroupProfileResult']:
        return pulumi.get(self, "reviewer_group_profile")

    @_builtins.property
    @pulumi.getter(name="reviewerProfile")
    def reviewer_profile(self) -> Optional['outputs.GetReviewAllReviewerLevelReviewerProfileResult']:
        return pulumi.get(self, "reviewer_profile")


@pulumi.output_type
class GetReviewAllReviewerLevelReviewerGroupProfileResult(dict):
    def __init__(__self__, *,
                 global_name: _builtins.str,
                 group_id: _builtins.str,
                 group_type: _builtins.str,
                 name: _builtins.str):
        pulumi.set(__self__, "global_name", global_name)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="globalName")
    def global_name(self) -> _builtins.str:
        return pulumi.get(self, "global_name")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetReviewAllReviewerLevelReviewerProfileResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 first_name: _builtins.str,
                 id: _builtins.str,
                 last_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetReviewEntitlementBundleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetReviewEntitlementValueResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetReviewLinksResult(dict):
    def __init__(__self__, *,
                 reassign_review_href: _builtins.str,
                 self_href: _builtins.str):
        pulumi.set(__self__, "reassign_review_href", reassign_review_href)
        pulumi.set(__self__, "self_href", self_href)

    @_builtins.property
    @pulumi.getter(name="reassignReviewHref")
    def reassign_review_href(self) -> _builtins.str:
        return pulumi.get(self, "reassign_review_href")

    @_builtins.property
    @pulumi.getter(name="selfHref")
    def self_href(self) -> _builtins.str:
        return pulumi.get(self, "self_href")


@pulumi.output_type
class GetReviewNoteResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 note: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "note", note)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def note(self) -> _builtins.str:
        return pulumi.get(self, "note")


@pulumi.output_type
class GetReviewPrincipalProfileResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 first_name: _builtins.str,
                 id: _builtins.str,
                 last_name: _builtins.str,
                 login: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def login(self) -> _builtins.str:
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetReviewReviewerProfileResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 first_name: _builtins.str,
                 id: _builtins.str,
                 last_name: _builtins.str,
                 login: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of  review.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of  review.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def login(self) -> _builtins.str:
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetTemplatesEmailTemplateResult(dict):
    def __init__(__self__, *,
                 links: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param _builtins.str name: The name of the email template
        """
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the email template
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetThemesThemeResult(dict):
    def __init__(__self__, *,
                 background_image_url: _builtins.str,
                 email_template_touch_point_variant: _builtins.str,
                 end_user_dashboard_touch_point_variant: _builtins.str,
                 error_page_touch_point_variant: _builtins.str,
                 favicon_url: _builtins.str,
                 id: _builtins.str,
                 links: _builtins.str,
                 logo_url: _builtins.str,
                 primary_color_contrast_hex: _builtins.str,
                 primary_color_hex: _builtins.str,
                 secondary_color_contrast_hex: _builtins.str,
                 secondary_color_hex: _builtins.str,
                 sign_in_page_touch_point_variant: _builtins.str):
        """
        :param _builtins.str background_image_url: Background image URL
        :param _builtins.str email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param _builtins.str end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param _builtins.str error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param _builtins.str favicon_url: Favicon URL
        :param _builtins.str id: The ID of the theme
        :param _builtins.str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param _builtins.str logo_url: Logo URL
        :param _builtins.str primary_color_contrast_hex: Primary color contrast hex code
        :param _builtins.str primary_color_hex: Primary color hex code
        :param _builtins.str secondary_color_contrast_hex: Secondary color contrast hex code
        :param _builtins.str secondary_color_hex: Secondary color hex code
        :param _builtins.str sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        pulumi.set(__self__, "background_image_url", background_image_url)
        pulumi.set(__self__, "email_template_touch_point_variant", email_template_touch_point_variant)
        pulumi.set(__self__, "end_user_dashboard_touch_point_variant", end_user_dashboard_touch_point_variant)
        pulumi.set(__self__, "error_page_touch_point_variant", error_page_touch_point_variant)
        pulumi.set(__self__, "favicon_url", favicon_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "logo_url", logo_url)
        pulumi.set(__self__, "primary_color_contrast_hex", primary_color_contrast_hex)
        pulumi.set(__self__, "primary_color_hex", primary_color_hex)
        pulumi.set(__self__, "secondary_color_contrast_hex", secondary_color_contrast_hex)
        pulumi.set(__self__, "secondary_color_hex", secondary_color_hex)
        pulumi.set(__self__, "sign_in_page_touch_point_variant", sign_in_page_touch_point_variant)

    @_builtins.property
    @pulumi.getter(name="backgroundImageUrl")
    def background_image_url(self) -> _builtins.str:
        """
        Background image URL
        """
        return pulumi.get(self, "background_image_url")

    @_builtins.property
    @pulumi.getter(name="emailTemplateTouchPointVariant")
    def email_template_touch_point_variant(self) -> _builtins.str:
        """
        Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        """
        return pulumi.get(self, "email_template_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="endUserDashboardTouchPointVariant")
    def end_user_dashboard_touch_point_variant(self) -> _builtins.str:
        """
        Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        """
        return pulumi.get(self, "end_user_dashboard_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="errorPageTouchPointVariant")
    def error_page_touch_point_variant(self) -> _builtins.str:
        """
        Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "error_page_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="faviconUrl")
    def favicon_url(self) -> _builtins.str:
        """
        Favicon URL
        """
        return pulumi.get(self, "favicon_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the theme
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> _builtins.str:
        """
        Logo URL
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter(name="primaryColorContrastHex")
    def primary_color_contrast_hex(self) -> _builtins.str:
        """
        Primary color contrast hex code
        """
        return pulumi.get(self, "primary_color_contrast_hex")

    @_builtins.property
    @pulumi.getter(name="primaryColorHex")
    def primary_color_hex(self) -> _builtins.str:
        """
        Primary color hex code
        """
        return pulumi.get(self, "primary_color_hex")

    @_builtins.property
    @pulumi.getter(name="secondaryColorContrastHex")
    def secondary_color_contrast_hex(self) -> _builtins.str:
        """
        Secondary color contrast hex code
        """
        return pulumi.get(self, "secondary_color_contrast_hex")

    @_builtins.property
    @pulumi.getter(name="secondaryColorHex")
    def secondary_color_hex(self) -> _builtins.str:
        """
        Secondary color hex code
        """
        return pulumi.get(self, "secondary_color_hex")

    @_builtins.property
    @pulumi.getter(name="signInPageTouchPointVariant")
    def sign_in_page_touch_point_variant(self) -> _builtins.str:
        """
        Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "sign_in_page_touch_point_variant")


@pulumi.output_type
class GetTrustedOriginsTrustedOriginResult(dict):
    def __init__(__self__, *,
                 active: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 origin: _builtins.str,
                 scopes: Sequence[_builtins.str]):
        """
        :param _builtins.bool active: Whether the Trusted Origin is active or not - can only be issued post-creation
        :param _builtins.str id: Unique identifier
        :param _builtins.str name: Unique name for this trusted origin
        :param _builtins.str origin: Unique origin URL for this trusted origin
        :param Sequence[_builtins.str] scopes: Scopes of the Trusted Origin - can either be CORS or REDIRECT only
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        Whether the Trusted Origin is active or not - can only be issued post-creation
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for this trusted origin
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        Unique origin URL for this trusted origin
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Sequence[_builtins.str]:
        """
        Scopes of the Trusted Origin - can either be CORS or REDIRECT only
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class GetUserSecurityQuestionsQuestionResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 text: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "text", text)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def text(self) -> _builtins.str:
        return pulumi.get(self, "text")


