# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleIdpDiscoveryArgs', 'RuleIdpDiscovery']

@pulumi.input_type
class RuleIdpDiscoveryArgs:
    def __init__(__self__, *,
                 app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]] = None,
                 app_includes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]] = None,
                 idp_providers: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]] = None,
                 user_identifier_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RuleIdpDiscovery resource.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]] app_includes: Applications to include in discovery rule.
               - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
               - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
               - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]] platform_includes: Platform to include in discovery rule.
               - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
               - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
               - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        :param pulumi.Input[_builtins.str] policy_id: Policy ID of the Rule
        :param pulumi.Input[_builtins.int] priority: Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[_builtins.str] status: Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
               - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
               - 'value' - (Optional) The regex or simple match string to match against.
        :param pulumi.Input[_builtins.str] user_identifier_type: One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        if app_excludes is not None:
            pulumi.set(__self__, "app_excludes", app_excludes)
        if app_includes is not None:
            pulumi.set(__self__, "app_includes", app_includes)
        if idp_providers is not None:
            pulumi.set(__self__, "idp_providers", idp_providers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_identifier_attribute is not None:
            pulumi.set(__self__, "user_identifier_attribute", user_identifier_attribute)
        if user_identifier_patterns is not None:
            pulumi.set(__self__, "user_identifier_patterns", user_identifier_patterns)
        if user_identifier_type is not None:
            pulumi.set(__self__, "user_identifier_type", user_identifier_type)

    @_builtins.property
    @pulumi.getter(name="appExcludes")
    def app_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]]:
        """
        Applications to exclude in discovery. See `app_include` for details.
        """
        return pulumi.get(self, "app_excludes")

    @app_excludes.setter
    def app_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]]):
        pulumi.set(self, "app_excludes", value)

    @_builtins.property
    @pulumi.getter(name="appIncludes")
    def app_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]]:
        """
        Applications to include in discovery rule.
        - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
        - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
        - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        """
        return pulumi.get(self, "app_includes")

    @app_includes.setter
    def app_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]]):
        pulumi.set(self, "app_includes", value)

    @_builtins.property
    @pulumi.getter(name="idpProviders")
    def idp_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]]:
        return pulumi.get(self, "idp_providers")

    @idp_providers.setter
    def idp_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]]):
        pulumi.set(self, "idp_providers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connection", value)

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_excludes", value)

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_includes", value)

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]]:
        """
        Platform to include in discovery rule.
        - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
        - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
        - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        """
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierAttribute")
    def user_identifier_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        """
        return pulumi.get(self, "user_identifier_attribute")

    @user_identifier_attribute.setter
    def user_identifier_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_identifier_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierPatterns")
    def user_identifier_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]:
        """
        Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
        - 'value' - (Optional) The regex or simple match string to match against.
        """
        return pulumi.get(self, "user_identifier_patterns")

    @user_identifier_patterns.setter
    def user_identifier_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]):
        pulumi.set(self, "user_identifier_patterns", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierType")
    def user_identifier_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        return pulumi.get(self, "user_identifier_type")

    @user_identifier_type.setter
    def user_identifier_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_identifier_type", value)


@pulumi.input_type
class _RuleIdpDiscoveryState:
    def __init__(__self__, *,
                 app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]] = None,
                 app_includes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]] = None,
                 idp_providers: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]] = None,
                 user_identifier_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleIdpDiscovery resources.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]] app_includes: Applications to include in discovery rule.
               - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
               - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
               - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]] platform_includes: Platform to include in discovery rule.
               - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
               - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
               - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        :param pulumi.Input[_builtins.str] policy_id: Policy ID of the Rule
        :param pulumi.Input[_builtins.int] priority: Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[_builtins.str] status: Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
               - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
               - 'value' - (Optional) The regex or simple match string to match against.
        :param pulumi.Input[_builtins.str] user_identifier_type: One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        if app_excludes is not None:
            pulumi.set(__self__, "app_excludes", app_excludes)
        if app_includes is not None:
            pulumi.set(__self__, "app_includes", app_includes)
        if idp_providers is not None:
            pulumi.set(__self__, "idp_providers", idp_providers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_identifier_attribute is not None:
            pulumi.set(__self__, "user_identifier_attribute", user_identifier_attribute)
        if user_identifier_patterns is not None:
            pulumi.set(__self__, "user_identifier_patterns", user_identifier_patterns)
        if user_identifier_type is not None:
            pulumi.set(__self__, "user_identifier_type", user_identifier_type)

    @_builtins.property
    @pulumi.getter(name="appExcludes")
    def app_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]]:
        """
        Applications to exclude in discovery. See `app_include` for details.
        """
        return pulumi.get(self, "app_excludes")

    @app_excludes.setter
    def app_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppExcludeArgs']]]]):
        pulumi.set(self, "app_excludes", value)

    @_builtins.property
    @pulumi.getter(name="appIncludes")
    def app_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]]:
        """
        Applications to include in discovery rule.
        - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
        - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
        - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        """
        return pulumi.get(self, "app_includes")

    @app_includes.setter
    def app_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryAppIncludeArgs']]]]):
        pulumi.set(self, "app_includes", value)

    @_builtins.property
    @pulumi.getter(name="idpProviders")
    def idp_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]]:
        return pulumi.get(self, "idp_providers")

    @idp_providers.setter
    def idp_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryIdpProviderArgs']]]]):
        pulumi.set(self, "idp_providers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connection", value)

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_excludes", value)

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_includes", value)

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]]:
        """
        Platform to include in discovery rule.
        - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
        - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
        - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        """
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryPlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierAttribute")
    def user_identifier_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        """
        return pulumi.get(self, "user_identifier_attribute")

    @user_identifier_attribute.setter
    def user_identifier_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_identifier_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierPatterns")
    def user_identifier_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]:
        """
        Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
        - 'value' - (Optional) The regex or simple match string to match against.
        """
        return pulumi.get(self, "user_identifier_patterns")

    @user_identifier_patterns.setter
    def user_identifier_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]):
        pulumi.set(self, "user_identifier_patterns", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifierType")
    def user_identifier_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        return pulumi.get(self, "user_identifier_type")

    @user_identifier_type.setter
    def user_identifier_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_identifier_type", value)


@pulumi.type_token("okta:policy/ruleIdpDiscovery:RuleIdpDiscovery")
class RuleIdpDiscovery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppExcludeArgs', 'RuleIdpDiscoveryAppExcludeArgsDict']]]]] = None,
                 app_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppIncludeArgs', 'RuleIdpDiscoveryAppIncludeArgsDict']]]]] = None,
                 idp_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryIdpProviderArgs', 'RuleIdpDiscoveryIdpProviderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryPlatformIncludeArgs', 'RuleIdpDiscoveryPlatformIncludeArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryUserIdentifierPatternArgs', 'RuleIdpDiscoveryUserIdentifierPatternArgsDict']]]]] = None,
                 user_identifier_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an IdP Discovery Policy Rule.

        This resource allows you to create and configure an IdP Discovery Policy Rule.
        > If you receive the error 'You do not have permission to access the feature
        you are requesting' contact support and
        request feature flag 'ADVANCED_SSO' be applied to your org.

        ## Import

        ```sh
        $ pulumi import okta:policy/ruleIdpDiscovery:RuleIdpDiscovery example <policy_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppExcludeArgs', 'RuleIdpDiscoveryAppExcludeArgsDict']]]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppIncludeArgs', 'RuleIdpDiscoveryAppIncludeArgsDict']]]] app_includes: Applications to include in discovery rule.
               - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
               - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
               - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryPlatformIncludeArgs', 'RuleIdpDiscoveryPlatformIncludeArgsDict']]]] platform_includes: Platform to include in discovery rule.
               - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
               - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
               - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        :param pulumi.Input[_builtins.str] policy_id: Policy ID of the Rule
        :param pulumi.Input[_builtins.int] priority: Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[_builtins.str] status: Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryUserIdentifierPatternArgs', 'RuleIdpDiscoveryUserIdentifierPatternArgsDict']]]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
               - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
               - 'value' - (Optional) The regex or simple match string to match against.
        :param pulumi.Input[_builtins.str] user_identifier_type: One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RuleIdpDiscoveryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an IdP Discovery Policy Rule.

        This resource allows you to create and configure an IdP Discovery Policy Rule.
        > If you receive the error 'You do not have permission to access the feature
        you are requesting' contact support and
        request feature flag 'ADVANCED_SSO' be applied to your org.

        ## Import

        ```sh
        $ pulumi import okta:policy/ruleIdpDiscovery:RuleIdpDiscovery example <policy_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleIdpDiscoveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleIdpDiscoveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppExcludeArgs', 'RuleIdpDiscoveryAppExcludeArgsDict']]]]] = None,
                 app_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppIncludeArgs', 'RuleIdpDiscoveryAppIncludeArgsDict']]]]] = None,
                 idp_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryIdpProviderArgs', 'RuleIdpDiscoveryIdpProviderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryPlatformIncludeArgs', 'RuleIdpDiscoveryPlatformIncludeArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryUserIdentifierPatternArgs', 'RuleIdpDiscoveryUserIdentifierPatternArgsDict']]]]] = None,
                 user_identifier_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleIdpDiscoveryArgs.__new__(RuleIdpDiscoveryArgs)

            __props__.__dict__["app_excludes"] = app_excludes
            __props__.__dict__["app_includes"] = app_includes
            __props__.__dict__["idp_providers"] = idp_providers
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connection"] = network_connection
            __props__.__dict__["network_excludes"] = network_excludes
            __props__.__dict__["network_includes"] = network_includes
            __props__.__dict__["platform_includes"] = platform_includes
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["priority"] = priority
            __props__.__dict__["status"] = status
            __props__.__dict__["user_identifier_attribute"] = user_identifier_attribute
            __props__.__dict__["user_identifier_patterns"] = user_identifier_patterns
            __props__.__dict__["user_identifier_type"] = user_identifier_type
        super(RuleIdpDiscovery, __self__).__init__(
            'okta:policy/ruleIdpDiscovery:RuleIdpDiscovery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppExcludeArgs', 'RuleIdpDiscoveryAppExcludeArgsDict']]]]] = None,
            app_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppIncludeArgs', 'RuleIdpDiscoveryAppIncludeArgsDict']]]]] = None,
            idp_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryIdpProviderArgs', 'RuleIdpDiscoveryIdpProviderArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_connection: Optional[pulumi.Input[_builtins.str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryPlatformIncludeArgs', 'RuleIdpDiscoveryPlatformIncludeArgsDict']]]]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_identifier_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryUserIdentifierPatternArgs', 'RuleIdpDiscoveryUserIdentifierPatternArgsDict']]]]] = None,
            user_identifier_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RuleIdpDiscovery':
        """
        Get an existing RuleIdpDiscovery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppExcludeArgs', 'RuleIdpDiscoveryAppExcludeArgsDict']]]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryAppIncludeArgs', 'RuleIdpDiscoveryAppIncludeArgsDict']]]] app_includes: Applications to include in discovery rule.
               - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
               - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
               - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryPlatformIncludeArgs', 'RuleIdpDiscoveryPlatformIncludeArgsDict']]]] platform_includes: Platform to include in discovery rule.
               - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
               - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
               - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        :param pulumi.Input[_builtins.str] policy_id: Policy ID of the Rule
        :param pulumi.Input[_builtins.int] priority: Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[_builtins.str] status: Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleIdpDiscoveryUserIdentifierPatternArgs', 'RuleIdpDiscoveryUserIdentifierPatternArgsDict']]]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
               - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
               - 'value' - (Optional) The regex or simple match string to match against.
        :param pulumi.Input[_builtins.str] user_identifier_type: One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleIdpDiscoveryState.__new__(_RuleIdpDiscoveryState)

        __props__.__dict__["app_excludes"] = app_excludes
        __props__.__dict__["app_includes"] = app_includes
        __props__.__dict__["idp_providers"] = idp_providers
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connection"] = network_connection
        __props__.__dict__["network_excludes"] = network_excludes
        __props__.__dict__["network_includes"] = network_includes
        __props__.__dict__["platform_includes"] = platform_includes
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["status"] = status
        __props__.__dict__["user_identifier_attribute"] = user_identifier_attribute
        __props__.__dict__["user_identifier_patterns"] = user_identifier_patterns
        __props__.__dict__["user_identifier_type"] = user_identifier_type
        return RuleIdpDiscovery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appExcludes")
    def app_excludes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryAppExclude']]]:
        """
        Applications to exclude in discovery. See `app_include` for details.
        """
        return pulumi.get(self, "app_excludes")

    @_builtins.property
    @pulumi.getter(name="appIncludes")
    def app_includes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryAppInclude']]]:
        """
        Applications to include in discovery rule.
        - 'id' - (Optional) Use if 'type' is 'APP' to indicate the application id to include.
        - 'name' - (Optional) Use if the 'type' is 'APP_TYPE' to indicate the type of application(s) to include in instances where an entire group (i.e. 'yahoo_mail') of applications should be included.
        - 'type' - (Required) One of: 'APP', 'APP_TYPE'
        """
        return pulumi.get(self, "app_includes")

    @_builtins.property
    @pulumi.getter(name="idpProviders")
    def idp_providers(self) -> pulumi.Output[Sequence['outputs.RuleIdpDiscoveryIdpProvider']]:
        return pulumi.get(self, "idp_providers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network selection mode: `ANYWHERE`, `ZONE`, `ON_NETWORK`, or `OFF_NETWORK`. Default: `ANYWHERE`
        """
        return pulumi.get(self, "network_connection")

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to exclude.
        """
        return pulumi.get(self, "network_excludes")

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Required if `network_connection` = `ZONE`. Indicates the network zones to include.
        """
        return pulumi.get(self, "network_includes")

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryPlatformInclude']]]:
        """
        Platform to include in discovery rule.
        - 'type' - (Optional) One of: 'ANY', 'MOBILE', 'DESKTOP'
        - 'os_expression - (Optional) Only available when using os_type = 'OTHER'
        - 'os_type' - (Optional) One of: 'ANY', 'IOS', 'WINDOWS', 'ANDROID', 'OTHER', 'OSX'
        """
        return pulumi.get(self, "platform_includes")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy Rule Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userIdentifierAttribute")
    def user_identifier_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        """
        return pulumi.get(self, "user_identifier_attribute")

    @_builtins.property
    @pulumi.getter(name="userIdentifierPatterns")
    def user_identifier_patterns(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryUserIdentifierPattern']]]:
        """
        Specifies a User Identifier pattern condition to match against. If 'match_type' of 'EXPRESSION' is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        - 'match_type' - (Optional) The kind of pattern. For regex, use 'EXPRESSION'. For simple string matches, use one of the following: 'SUFFIX', 'EQUALS', 'STARTS_WITH', 'CONTAINS'
        - 'value' - (Optional) The regex or simple match string to match against.
        """
        return pulumi.get(self, "user_identifier_patterns")

    @_builtins.property
    @pulumi.getter(name="userIdentifierType")
    def user_identifier_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        One of: `IDENTIFIER`, `ATTRIBUTE`
        """
        return pulumi.get(self, "user_identifier_type")

