# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreviewSigninPageArgs', 'PreviewSigninPage']

@pulumi.input_type
class PreviewSigninPageArgs:
    def __init__(__self__, *,
                 brand_id: pulumi.Input[_builtins.str],
                 page_content: pulumi.Input[_builtins.str],
                 widget_version: pulumi.Input[_builtins.str],
                 content_security_policy_setting: Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']] = None,
                 widget_customizations: Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']] = None):
        """
        The set of arguments for constructing a PreviewSigninPage resource.
        :param pulumi.Input[_builtins.str] brand_id: brand id of the preview signin page
        :param pulumi.Input[_builtins.str] page_content: page content of the preview signin page
        :param pulumi.Input[_builtins.str] widget_version: widget version specified as a Semver. The following are currently supported
               		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
               		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
               		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
               		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
               		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        pulumi.set(__self__, "brand_id", brand_id)
        pulumi.set(__self__, "page_content", page_content)
        pulumi.set(__self__, "widget_version", widget_version)
        if content_security_policy_setting is not None:
            pulumi.set(__self__, "content_security_policy_setting", content_security_policy_setting)
        if widget_customizations is not None:
            pulumi.set(__self__, "widget_customizations", widget_customizations)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Input[_builtins.str]:
        """
        brand id of the preview signin page
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "brand_id", value)

    @_builtins.property
    @pulumi.getter(name="pageContent")
    def page_content(self) -> pulumi.Input[_builtins.str]:
        """
        page content of the preview signin page
        """
        return pulumi.get(self, "page_content")

    @page_content.setter
    def page_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "page_content", value)

    @_builtins.property
    @pulumi.getter(name="widgetVersion")
    def widget_version(self) -> pulumi.Input[_builtins.str]:
        """
        widget version specified as a Semver. The following are currently supported
        		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
        		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
        		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
        		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
        		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        return pulumi.get(self, "widget_version")

    @widget_version.setter
    def widget_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "widget_version", value)

    @_builtins.property
    @pulumi.getter(name="contentSecurityPolicySetting")
    def content_security_policy_setting(self) -> Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']]:
        return pulumi.get(self, "content_security_policy_setting")

    @content_security_policy_setting.setter
    def content_security_policy_setting(self, value: Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']]):
        pulumi.set(self, "content_security_policy_setting", value)

    @_builtins.property
    @pulumi.getter(name="widgetCustomizations")
    def widget_customizations(self) -> Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']]:
        return pulumi.get(self, "widget_customizations")

    @widget_customizations.setter
    def widget_customizations(self, value: Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']]):
        pulumi.set(self, "widget_customizations", value)


@pulumi.input_type
class _PreviewSigninPageState:
    def __init__(__self__, *,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_security_policy_setting: Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']] = None,
                 page_content: Optional[pulumi.Input[_builtins.str]] = None,
                 widget_customizations: Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']] = None,
                 widget_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PreviewSigninPage resources.
        :param pulumi.Input[_builtins.str] brand_id: brand id of the preview signin page
        :param pulumi.Input[_builtins.str] page_content: page content of the preview signin page
        :param pulumi.Input[_builtins.str] widget_version: widget version specified as a Semver. The following are currently supported
               		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
               		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
               		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
               		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
               		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        if brand_id is not None:
            pulumi.set(__self__, "brand_id", brand_id)
        if content_security_policy_setting is not None:
            pulumi.set(__self__, "content_security_policy_setting", content_security_policy_setting)
        if page_content is not None:
            pulumi.set(__self__, "page_content", page_content)
        if widget_customizations is not None:
            pulumi.set(__self__, "widget_customizations", widget_customizations)
        if widget_version is not None:
            pulumi.set(__self__, "widget_version", widget_version)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        brand id of the preview signin page
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "brand_id", value)

    @_builtins.property
    @pulumi.getter(name="contentSecurityPolicySetting")
    def content_security_policy_setting(self) -> Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']]:
        return pulumi.get(self, "content_security_policy_setting")

    @content_security_policy_setting.setter
    def content_security_policy_setting(self, value: Optional[pulumi.Input['PreviewSigninPageContentSecurityPolicySettingArgs']]):
        pulumi.set(self, "content_security_policy_setting", value)

    @_builtins.property
    @pulumi.getter(name="pageContent")
    def page_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        page content of the preview signin page
        """
        return pulumi.get(self, "page_content")

    @page_content.setter
    def page_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "page_content", value)

    @_builtins.property
    @pulumi.getter(name="widgetCustomizations")
    def widget_customizations(self) -> Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']]:
        return pulumi.get(self, "widget_customizations")

    @widget_customizations.setter
    def widget_customizations(self, value: Optional[pulumi.Input['PreviewSigninPageWidgetCustomizationsArgs']]):
        pulumi.set(self, "widget_customizations", value)

    @_builtins.property
    @pulumi.getter(name="widgetVersion")
    def widget_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        widget version specified as a Semver. The following are currently supported
        		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
        		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
        		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
        		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
        		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        return pulumi.get(self, "widget_version")

    @widget_version.setter
    def widget_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "widget_version", value)


@pulumi.type_token("okta:index/previewSigninPage:PreviewSigninPage")
class PreviewSigninPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_security_policy_setting: Optional[pulumi.Input[Union['PreviewSigninPageContentSecurityPolicySettingArgs', 'PreviewSigninPageContentSecurityPolicySettingArgsDict']]] = None,
                 page_content: Optional[pulumi.Input[_builtins.str]] = None,
                 widget_customizations: Optional[pulumi.Input[Union['PreviewSigninPageWidgetCustomizationsArgs', 'PreviewSigninPageWidgetCustomizationsArgsDict']]] = None,
                 widget_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage the preview signin page of a brand

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.Brand("test",
            name="testBrand",
            locale="en")
        test_preview_signin_page = okta.PreviewSigninPage("test",
            brand_id=okta_brand["test"]["id"],
            page_content=\"\"\"<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
        <html>
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <meta name="robots" content="noindex,nofollow" />
            <!-- Styles generated from theme -->
            <link href="{{themedStylesUrl}}" rel="stylesheet" type="text/css">
            <!-- Favicon from theme -->
            <link rel="shortcut icon" href="{{faviconUrl}}" type="image/x-icon"/>

            <title>{{pageTitle}}</title>
            {{{SignInWidgetResources}}}

            <style nonce="{{nonceValue}}">
                #login-bg-image-id {
                    background-image: {{bgImageUrl}}
                }
            </style>
        </head>
        <body>
            <div id="login-bg-image-id" class="login-bg-image tb--background"></div>
            <div id="okta-login-container"></div>

            <!--
                "OktaUtil" defines a global OktaUtil object
                that contains methods used to complete the Okta login flow.
             -->
            {{{OktaUtil}}}

            <script type="text/javascript" nonce="{{nonceValue}}">
                // "config" object contains default widget configuration
                // with any custom overrides defined in your admin settings.
                var config = OktaUtil.getSignInWidgetConfig();

                // Render the Okta Sign-In Widget
                var oktaSignIn = new OktaSignIn(config);
                oktaSignIn.renderEl({ el: '#okta-login-container' },
                    OktaUtil.completeLogin,
                    function(error) {
                        // Logs errors that occur when configuring the widget.
                        // Remove or replace this with your own custom error handler.
                        console.log(error.message, error);
                    }
                );
            </script>
        </body>
        </html>
        \"\"\",
            widget_version="^6",
            widget_customizations={
                "widget_generation": "G3",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brand_id: brand id of the preview signin page
        :param pulumi.Input[_builtins.str] page_content: page content of the preview signin page
        :param pulumi.Input[_builtins.str] widget_version: widget version specified as a Semver. The following are currently supported
               		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
               		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
               		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
               		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
               		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreviewSigninPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage the preview signin page of a brand

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.Brand("test",
            name="testBrand",
            locale="en")
        test_preview_signin_page = okta.PreviewSigninPage("test",
            brand_id=okta_brand["test"]["id"],
            page_content=\"\"\"<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
        <html>
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <meta name="robots" content="noindex,nofollow" />
            <!-- Styles generated from theme -->
            <link href="{{themedStylesUrl}}" rel="stylesheet" type="text/css">
            <!-- Favicon from theme -->
            <link rel="shortcut icon" href="{{faviconUrl}}" type="image/x-icon"/>

            <title>{{pageTitle}}</title>
            {{{SignInWidgetResources}}}

            <style nonce="{{nonceValue}}">
                #login-bg-image-id {
                    background-image: {{bgImageUrl}}
                }
            </style>
        </head>
        <body>
            <div id="login-bg-image-id" class="login-bg-image tb--background"></div>
            <div id="okta-login-container"></div>

            <!--
                "OktaUtil" defines a global OktaUtil object
                that contains methods used to complete the Okta login flow.
             -->
            {{{OktaUtil}}}

            <script type="text/javascript" nonce="{{nonceValue}}">
                // "config" object contains default widget configuration
                // with any custom overrides defined in your admin settings.
                var config = OktaUtil.getSignInWidgetConfig();

                // Render the Okta Sign-In Widget
                var oktaSignIn = new OktaSignIn(config);
                oktaSignIn.renderEl({ el: '#okta-login-container' },
                    OktaUtil.completeLogin,
                    function(error) {
                        // Logs errors that occur when configuring the widget.
                        // Remove or replace this with your own custom error handler.
                        console.log(error.message, error);
                    }
                );
            </script>
        </body>
        </html>
        \"\"\",
            widget_version="^6",
            widget_customizations={
                "widget_generation": "G3",
            })
        ```

        :param str resource_name: The name of the resource.
        :param PreviewSigninPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreviewSigninPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_security_policy_setting: Optional[pulumi.Input[Union['PreviewSigninPageContentSecurityPolicySettingArgs', 'PreviewSigninPageContentSecurityPolicySettingArgsDict']]] = None,
                 page_content: Optional[pulumi.Input[_builtins.str]] = None,
                 widget_customizations: Optional[pulumi.Input[Union['PreviewSigninPageWidgetCustomizationsArgs', 'PreviewSigninPageWidgetCustomizationsArgsDict']]] = None,
                 widget_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreviewSigninPageArgs.__new__(PreviewSigninPageArgs)

            if brand_id is None and not opts.urn:
                raise TypeError("Missing required property 'brand_id'")
            __props__.__dict__["brand_id"] = brand_id
            __props__.__dict__["content_security_policy_setting"] = content_security_policy_setting
            if page_content is None and not opts.urn:
                raise TypeError("Missing required property 'page_content'")
            __props__.__dict__["page_content"] = page_content
            __props__.__dict__["widget_customizations"] = widget_customizations
            if widget_version is None and not opts.urn:
                raise TypeError("Missing required property 'widget_version'")
            __props__.__dict__["widget_version"] = widget_version
        super(PreviewSigninPage, __self__).__init__(
            'okta:index/previewSigninPage:PreviewSigninPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            brand_id: Optional[pulumi.Input[_builtins.str]] = None,
            content_security_policy_setting: Optional[pulumi.Input[Union['PreviewSigninPageContentSecurityPolicySettingArgs', 'PreviewSigninPageContentSecurityPolicySettingArgsDict']]] = None,
            page_content: Optional[pulumi.Input[_builtins.str]] = None,
            widget_customizations: Optional[pulumi.Input[Union['PreviewSigninPageWidgetCustomizationsArgs', 'PreviewSigninPageWidgetCustomizationsArgsDict']]] = None,
            widget_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'PreviewSigninPage':
        """
        Get an existing PreviewSigninPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brand_id: brand id of the preview signin page
        :param pulumi.Input[_builtins.str] page_content: page content of the preview signin page
        :param pulumi.Input[_builtins.str] widget_version: widget version specified as a Semver. The following are currently supported
               		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
               		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
               		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
               		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
               		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreviewSigninPageState.__new__(_PreviewSigninPageState)

        __props__.__dict__["brand_id"] = brand_id
        __props__.__dict__["content_security_policy_setting"] = content_security_policy_setting
        __props__.__dict__["page_content"] = page_content
        __props__.__dict__["widget_customizations"] = widget_customizations
        __props__.__dict__["widget_version"] = widget_version
        return PreviewSigninPage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Output[_builtins.str]:
        """
        brand id of the preview signin page
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="contentSecurityPolicySetting")
    def content_security_policy_setting(self) -> pulumi.Output[Optional['outputs.PreviewSigninPageContentSecurityPolicySetting']]:
        return pulumi.get(self, "content_security_policy_setting")

    @_builtins.property
    @pulumi.getter(name="pageContent")
    def page_content(self) -> pulumi.Output[_builtins.str]:
        """
        page content of the preview signin page
        """
        return pulumi.get(self, "page_content")

    @_builtins.property
    @pulumi.getter(name="widgetCustomizations")
    def widget_customizations(self) -> pulumi.Output[Optional['outputs.PreviewSigninPageWidgetCustomizations']]:
        return pulumi.get(self, "widget_customizations")

    @_builtins.property
    @pulumi.getter(name="widgetVersion")
    def widget_version(self) -> pulumi.Output[_builtins.str]:
        """
        widget version specified as a Semver. The following are currently supported
        		*, ^1, ^2, ^3, ^4, ^5, ^6, ^7, 1.6, 1.7, 1.8, 1.9, 1.10, 1.11, 1.12, 1.13, 2.1, 2.2, 2.3, 2.4,
        		2.5, 2.6, 2.7, 2.8, 2.9, 2.10, 2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.20, 2.21,
        		3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 5.0, 5.1, 5.2, 5.3,
        		5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 5.10, 5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5,
        		6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.10, 7.11, 7.12, 7.13.
        """
        return pulumi.get(self, "widget_version")

