# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PrincipalRateLimitsArgs', 'PrincipalRateLimits']

@pulumi.input_type
class PrincipalRateLimitsArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str],
                 default_concurrency_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 default_percentage: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PrincipalRateLimits resource.
        :param pulumi.Input[_builtins.str] principal_id: The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        :param pulumi.Input[_builtins.str] principal_type: The type of principal, either an API token or an OAuth 2.0 app.
        :param pulumi.Input[_builtins.int] default_concurrency_percentage: The default percentage of a given concurrency limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.int] default_percentage: The default percentage of a given rate limit threshold that the owning principal can consume.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if default_concurrency_percentage is not None:
            pulumi.set(__self__, "default_concurrency_percentage", default_concurrency_percentage)
        if default_percentage is not None:
            pulumi.set(__self__, "default_percentage", default_percentage)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of principal, either an API token or an OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultConcurrencyPercentage")
    def default_concurrency_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default percentage of a given concurrency limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_concurrency_percentage")

    @default_concurrency_percentage.setter
    def default_concurrency_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_concurrency_percentage", value)

    @_builtins.property
    @pulumi.getter(name="defaultPercentage")
    def default_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default percentage of a given rate limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_percentage")

    @default_percentage.setter
    def default_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_percentage", value)


@pulumi.input_type
class _PrincipalRateLimitsState:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 default_concurrency_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 default_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 last_update: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrincipalRateLimits resources.
        :param pulumi.Input[_builtins.str] created_by: The Okta user ID of the user who created the principle rate limit entity.
        :param pulumi.Input[_builtins.str] created_date: The date and time the principle rate limit entity was created.
        :param pulumi.Input[_builtins.int] default_concurrency_percentage: The default percentage of a given concurrency limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.int] default_percentage: The default percentage of a given rate limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.str] last_update: The date and time the principle rate limit entity was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The Okta user ID of the user who last updated the principle rate limit entity.
        :param pulumi.Input[_builtins.str] org_id: The unique identifier of the Okta org.
        :param pulumi.Input[_builtins.str] principal_id: The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        :param pulumi.Input[_builtins.str] principal_type: The type of principal, either an API token or an OAuth 2.0 app.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if default_concurrency_percentage is not None:
            pulumi.set(__self__, "default_concurrency_percentage", default_concurrency_percentage)
        if default_percentage is not None:
            pulumi.set(__self__, "default_percentage", default_percentage)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Okta user ID of the user who created the principle rate limit entity.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the principle rate limit entity was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter(name="defaultConcurrencyPercentage")
    def default_concurrency_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default percentage of a given concurrency limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_concurrency_percentage")

    @default_concurrency_percentage.setter
    def default_concurrency_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_concurrency_percentage", value)

    @_builtins.property
    @pulumi.getter(name="defaultPercentage")
    def default_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default percentage of a given rate limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_percentage")

    @default_percentage.setter
    def default_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_percentage", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the principle rate limit entity was last updated.
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Okta user ID of the user who last updated the principle rate limit entity.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Okta org.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of principal, either an API token or an OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)


@pulumi.type_token("okta:index/principalRateLimits:PrincipalRateLimits")
class PrincipalRateLimits(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_concurrency_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 default_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PrincipalRateLimits resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] default_concurrency_percentage: The default percentage of a given concurrency limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.int] default_percentage: The default percentage of a given rate limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.str] principal_id: The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        :param pulumi.Input[_builtins.str] principal_type: The type of principal, either an API token or an OAuth 2.0 app.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrincipalRateLimitsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PrincipalRateLimits resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PrincipalRateLimitsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrincipalRateLimitsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_concurrency_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 default_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrincipalRateLimitsArgs.__new__(PrincipalRateLimitsArgs)

            __props__.__dict__["default_concurrency_percentage"] = default_concurrency_percentage
            __props__.__dict__["default_percentage"] = default_percentage
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["org_id"] = None
        super(PrincipalRateLimits, __self__).__init__(
            'okta:index/principalRateLimits:PrincipalRateLimits',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            default_concurrency_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            default_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            last_update: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrincipalRateLimits':
        """
        Get an existing PrincipalRateLimits resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: The Okta user ID of the user who created the principle rate limit entity.
        :param pulumi.Input[_builtins.str] created_date: The date and time the principle rate limit entity was created.
        :param pulumi.Input[_builtins.int] default_concurrency_percentage: The default percentage of a given concurrency limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.int] default_percentage: The default percentage of a given rate limit threshold that the owning principal can consume.
        :param pulumi.Input[_builtins.str] last_update: The date and time the principle rate limit entity was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The Okta user ID of the user who last updated the principle rate limit entity.
        :param pulumi.Input[_builtins.str] org_id: The unique identifier of the Okta org.
        :param pulumi.Input[_builtins.str] principal_id: The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        :param pulumi.Input[_builtins.str] principal_type: The type of principal, either an API token or an OAuth 2.0 app.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrincipalRateLimitsState.__new__(_PrincipalRateLimitsState)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["default_concurrency_percentage"] = default_concurrency_percentage
        __props__.__dict__["default_percentage"] = default_percentage
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        return PrincipalRateLimits(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The Okta user ID of the user who created the principle rate limit entity.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the principle rate limit entity was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="defaultConcurrencyPercentage")
    def default_concurrency_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The default percentage of a given concurrency limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_concurrency_percentage")

    @_builtins.property
    @pulumi.getter(name="defaultPercentage")
    def default_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The default percentage of a given rate limit threshold that the owning principal can consume.
        """
        return pulumi.get(self, "default_percentage")

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the principle rate limit entity was last updated.
        """
        return pulumi.get(self, "last_update")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The Okta user ID of the user who last updated the principle rate limit entity.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Okta org.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the principal. This is the ID of the API token or OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of principal, either an API token or an OAuth 2.0 app.
        """
        return pulumi.get(self, "principal_type")

