# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RateLimitWarningThresholdPercentageArgs', 'RateLimitWarningThresholdPercentage']

@pulumi.input_type
class RateLimitWarningThresholdPercentageArgs:
    def __init__(__self__, *,
                 warning_threshold: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a RateLimitWarningThresholdPercentage resource.
        :param pulumi.Input[_builtins.int] warning_threshold: The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        pulumi.set(__self__, "warning_threshold", warning_threshold)

    @_builtins.property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> pulumi.Input[_builtins.int]:
        """
        The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "warning_threshold", value)


@pulumi.input_type
class _RateLimitWarningThresholdPercentageState:
    def __init__(__self__, *,
                 warning_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RateLimitWarningThresholdPercentage resources.
        :param pulumi.Input[_builtins.int] warning_threshold: The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @_builtins.property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "warning_threshold", value)


@pulumi.type_token("okta:index/rateLimitWarningThresholdPercentage:RateLimitWarningThresholdPercentage")
class RateLimitWarningThresholdPercentage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 warning_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Rate limit warning threshold percentage provides operations to manage threshold for warning notifications when the API's rate limit is exceeded.
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RateLimitWarningThresholdPercentage("example", warning_threshold=90)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/rateLimitWarningThresholdPercentage:RateLimitWarningThresholdPercentage example .
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] warning_threshold: The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RateLimitWarningThresholdPercentageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Rate limit warning threshold percentage provides operations to manage threshold for warning notifications when the API's rate limit is exceeded.
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RateLimitWarningThresholdPercentage("example", warning_threshold=90)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/rateLimitWarningThresholdPercentage:RateLimitWarningThresholdPercentage example .
        ```

        :param str resource_name: The name of the resource.
        :param RateLimitWarningThresholdPercentageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RateLimitWarningThresholdPercentageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 warning_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RateLimitWarningThresholdPercentageArgs.__new__(RateLimitWarningThresholdPercentageArgs)

            if warning_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'warning_threshold'")
            __props__.__dict__["warning_threshold"] = warning_threshold
        super(RateLimitWarningThresholdPercentage, __self__).__init__(
            'okta:index/rateLimitWarningThresholdPercentage:RateLimitWarningThresholdPercentage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            warning_threshold: Optional[pulumi.Input[_builtins.int]] = None) -> 'RateLimitWarningThresholdPercentage':
        """
        Get an existing RateLimitWarningThresholdPercentage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] warning_threshold: The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RateLimitWarningThresholdPercentageState.__new__(_RateLimitWarningThresholdPercentageState)

        __props__.__dict__["warning_threshold"] = warning_threshold
        return RateLimitWarningThresholdPercentage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.
        """
        return pulumi.get(self, "warning_threshold")

