# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RateLimitingArgs', 'RateLimiting']

@pulumi.input_type
class RateLimitingArgs:
    def __init__(__self__, *,
                 default_mode: pulumi.Input[_builtins.str],
                 use_case_mode_overrides: Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']] = None):
        """
        The set of arguments for constructing a RateLimiting resource.
        :param pulumi.Input['RateLimitingUseCaseModeOverridesArgs'] use_case_mode_overrides: A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        if use_case_mode_overrides is not None:
            pulumi.set(__self__, "use_case_mode_overrides", use_case_mode_overrides)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_mode", value)

    @_builtins.property
    @pulumi.getter(name="useCaseModeOverrides")
    def use_case_mode_overrides(self) -> Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']]:
        """
        A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        return pulumi.get(self, "use_case_mode_overrides")

    @use_case_mode_overrides.setter
    def use_case_mode_overrides(self, value: Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']]):
        pulumi.set(self, "use_case_mode_overrides", value)


@pulumi.input_type
class _RateLimitingState:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 use_case_mode_overrides: Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']] = None):
        """
        Input properties used for looking up and filtering RateLimiting resources.
        :param pulumi.Input['RateLimitingUseCaseModeOverridesArgs'] use_case_mode_overrides: A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if use_case_mode_overrides is not None:
            pulumi.set(__self__, "use_case_mode_overrides", use_case_mode_overrides)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_mode", value)

    @_builtins.property
    @pulumi.getter(name="useCaseModeOverrides")
    def use_case_mode_overrides(self) -> Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']]:
        """
        A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        return pulumi.get(self, "use_case_mode_overrides")

    @use_case_mode_overrides.setter
    def use_case_mode_overrides(self, value: Optional[pulumi.Input['RateLimitingUseCaseModeOverridesArgs']]):
        pulumi.set(self, "use_case_mode_overrides", value)


@pulumi.type_token("okta:index/rateLimiting:RateLimiting")
class RateLimiting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 use_case_mode_overrides: Optional[pulumi.Input[Union['RateLimitingUseCaseModeOverridesArgs', 'RateLimitingUseCaseModeOverridesArgsDict']]] = None,
                 __props__=None):
        """
        Manages rate limiting.
        This resource allows you to configure the client-based rate limit and rate limiting communications settings.
        > **WARNING:** This resource is deprecated and will be removed in a future release. A new resource to manage rate limiting settings will be implemented in the future.

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:index/rateLimiting:RateLimiting example .
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RateLimitingUseCaseModeOverridesArgs', 'RateLimitingUseCaseModeOverridesArgsDict']] use_case_mode_overrides: A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RateLimitingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages rate limiting.
        This resource allows you to configure the client-based rate limit and rate limiting communications settings.
        > **WARNING:** This resource is deprecated and will be removed in a future release. A new resource to manage rate limiting settings will be implemented in the future.

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:index/rateLimiting:RateLimiting example .
        ```

        :param str resource_name: The name of the resource.
        :param RateLimitingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RateLimitingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 use_case_mode_overrides: Optional[pulumi.Input[Union['RateLimitingUseCaseModeOverridesArgs', 'RateLimitingUseCaseModeOverridesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RateLimitingArgs.__new__(RateLimitingArgs)

            if default_mode is None and not opts.urn:
                raise TypeError("Missing required property 'default_mode'")
            __props__.__dict__["default_mode"] = default_mode
            __props__.__dict__["use_case_mode_overrides"] = use_case_mode_overrides
        super(RateLimiting, __self__).__init__(
            'okta:index/rateLimiting:RateLimiting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_mode: Optional[pulumi.Input[_builtins.str]] = None,
            use_case_mode_overrides: Optional[pulumi.Input[Union['RateLimitingUseCaseModeOverridesArgs', 'RateLimitingUseCaseModeOverridesArgsDict']]] = None) -> 'RateLimiting':
        """
        Get an existing RateLimiting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RateLimitingUseCaseModeOverridesArgs', 'RateLimitingUseCaseModeOverridesArgsDict']] use_case_mode_overrides: A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RateLimitingState.__new__(_RateLimitingState)

        __props__.__dict__["default_mode"] = default_mode
        __props__.__dict__["use_case_mode_overrides"] = use_case_mode_overrides
        return RateLimiting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter(name="useCaseModeOverrides")
    def use_case_mode_overrides(self) -> pulumi.Output[Optional['outputs.RateLimitingUseCaseModeOverrides']]:
        """
        A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode.Overrides the defaultMode property for the specified use cases.
        """
        return pulumi.get(self, "use_case_mode_overrides")

