# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RequestConditionArgs', 'RequestCondition']

@pulumi.input_type
class RequestConditionArgs:
    def __init__(__self__, *,
                 approval_sequence_id: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 access_duration_settings: Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']] = None,
                 access_scope_settings: Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requester_settings: Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']] = None):
        """
        The set of arguments for constructing a RequestCondition resource.
        :param pulumi.Input[_builtins.str] approval_sequence_id: The ID of the approval sequence.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        :param pulumi.Input['RequestConditionAccessDurationSettingsArgs'] access_duration_settings: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] name: The name of the request condition.
        :param pulumi.Input[_builtins.int] priority: The priority of the request condition. Lower numbers indicate higher priority.
        """
        pulumi.set(__self__, "approval_sequence_id", approval_sequence_id)
        pulumi.set(__self__, "resource_id", resource_id)
        if access_duration_settings is not None:
            pulumi.set(__self__, "access_duration_settings", access_duration_settings)
        if access_scope_settings is not None:
            pulumi.set(__self__, "access_scope_settings", access_scope_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if requester_settings is not None:
            pulumi.set(__self__, "requester_settings", requester_settings)

    @_builtins.property
    @pulumi.getter(name="approvalSequenceId")
    def approval_sequence_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the approval sequence.
        """
        return pulumi.get(self, "approval_sequence_id")

    @approval_sequence_id.setter
    def approval_sequence_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "approval_sequence_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="accessDurationSettings")
    def access_duration_settings(self) -> Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']]:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "access_duration_settings")

    @access_duration_settings.setter
    def access_duration_settings(self, value: Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']]):
        pulumi.set(self, "access_duration_settings", value)

    @_builtins.property
    @pulumi.getter(name="accessScopeSettings")
    def access_scope_settings(self) -> Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']]:
        return pulumi.get(self, "access_scope_settings")

    @access_scope_settings.setter
    def access_scope_settings(self, value: Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']]):
        pulumi.set(self, "access_scope_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the request condition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the request condition. Lower numbers indicate higher priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="requesterSettings")
    def requester_settings(self) -> Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']]:
        return pulumi.get(self, "requester_settings")

    @requester_settings.setter
    def requester_settings(self, value: Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']]):
        pulumi.set(self, "requester_settings", value)


@pulumi.input_type
class _RequestConditionState:
    def __init__(__self__, *,
                 access_duration_settings: Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']] = None,
                 access_scope_settings: Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']] = None,
                 approval_sequence_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requester_settings: Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RequestCondition resources.
        :param pulumi.Input['RequestConditionAccessDurationSettingsArgs'] access_duration_settings: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] approval_sequence_id: The ID of the approval sequence.
        :param pulumi.Input[_builtins.str] created: The date and time when the request condition was created.
        :param pulumi.Input[_builtins.str] created_by: The id of the user who created the request condition.
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] last_updated: The date and time when the request condition was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of the user who last updated the request condition.
        :param pulumi.Input[_builtins.str] name: The name of the request condition.
        :param pulumi.Input[_builtins.int] priority: The priority of the request condition. Lower numbers indicate higher priority.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        :param pulumi.Input[_builtins.str] status: Status indicates if this condition is active or not. Default status is INACTIVE. Enum: `ACTIVE`, `INACTIVE`, `DELETED`, `INVALID`.
        """
        if access_duration_settings is not None:
            pulumi.set(__self__, "access_duration_settings", access_duration_settings)
        if access_scope_settings is not None:
            pulumi.set(__self__, "access_scope_settings", access_scope_settings)
        if approval_sequence_id is not None:
            pulumi.set(__self__, "approval_sequence_id", approval_sequence_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if requester_settings is not None:
            pulumi.set(__self__, "requester_settings", requester_settings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessDurationSettings")
    def access_duration_settings(self) -> Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']]:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "access_duration_settings")

    @access_duration_settings.setter
    def access_duration_settings(self, value: Optional[pulumi.Input['RequestConditionAccessDurationSettingsArgs']]):
        pulumi.set(self, "access_duration_settings", value)

    @_builtins.property
    @pulumi.getter(name="accessScopeSettings")
    def access_scope_settings(self) -> Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']]:
        return pulumi.get(self, "access_scope_settings")

    @access_scope_settings.setter
    def access_scope_settings(self, value: Optional[pulumi.Input['RequestConditionAccessScopeSettingsArgs']]):
        pulumi.set(self, "access_scope_settings", value)

    @_builtins.property
    @pulumi.getter(name="approvalSequenceId")
    def approval_sequence_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the approval sequence.
        """
        return pulumi.get(self, "approval_sequence_id")

    @approval_sequence_id.setter
    def approval_sequence_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_sequence_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the request condition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the request condition. Lower numbers indicate higher priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="requesterSettings")
    def requester_settings(self) -> Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']]:
        return pulumi.get(self, "requester_settings")

    @requester_settings.setter
    def requester_settings(self, value: Optional[pulumi.Input['RequestConditionRequesterSettingsArgs']]):
        pulumi.set(self, "requester_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status indicates if this condition is active or not. Default status is INACTIVE. Enum: `ACTIVE`, `INACTIVE`, `DELETED`, `INVALID`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("okta:index/requestCondition:RequestCondition")
class RequestCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_duration_settings: Optional[pulumi.Input[Union['RequestConditionAccessDurationSettingsArgs', 'RequestConditionAccessDurationSettingsArgsDict']]] = None,
                 access_scope_settings: Optional[pulumi.Input[Union['RequestConditionAccessScopeSettingsArgs', 'RequestConditionAccessScopeSettingsArgsDict']]] = None,
                 approval_sequence_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requester_settings: Optional[pulumi.Input[Union['RequestConditionRequesterSettingsArgs', 'RequestConditionRequesterSettingsArgsDict']]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages request conditions. This resource allows you to create and configure an Okta [request-condition](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Conditions/#tag/Request-Conditions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RequestCondition("example",
            resource_id="<resource_id>",
            approval_sequence_id="<approval_sequence_id>",
            name="<name>",
            access_scope_settings={
                "type": "RESOURCE_DEFAULT",
            },
            requester_settings={
                "type": "EVERYONE",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestCondition:RequestCondition example <resource_id>/<request_condition_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RequestConditionAccessDurationSettingsArgs', 'RequestConditionAccessDurationSettingsArgsDict']] access_duration_settings: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] approval_sequence_id: The ID of the approval sequence.
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] name: The name of the request condition.
        :param pulumi.Input[_builtins.int] priority: The priority of the request condition. Lower numbers indicate higher priority.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages request conditions. This resource allows you to create and configure an Okta [request-condition](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Conditions/#tag/Request-Conditions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RequestCondition("example",
            resource_id="<resource_id>",
            approval_sequence_id="<approval_sequence_id>",
            name="<name>",
            access_scope_settings={
                "type": "RESOURCE_DEFAULT",
            },
            requester_settings={
                "type": "EVERYONE",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestCondition:RequestCondition example <resource_id>/<request_condition_id>
        ```

        :param str resource_name: The name of the resource.
        :param RequestConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_duration_settings: Optional[pulumi.Input[Union['RequestConditionAccessDurationSettingsArgs', 'RequestConditionAccessDurationSettingsArgsDict']]] = None,
                 access_scope_settings: Optional[pulumi.Input[Union['RequestConditionAccessScopeSettingsArgs', 'RequestConditionAccessScopeSettingsArgsDict']]] = None,
                 approval_sequence_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requester_settings: Optional[pulumi.Input[Union['RequestConditionRequesterSettingsArgs', 'RequestConditionRequesterSettingsArgsDict']]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestConditionArgs.__new__(RequestConditionArgs)

            __props__.__dict__["access_duration_settings"] = access_duration_settings
            __props__.__dict__["access_scope_settings"] = access_scope_settings
            if approval_sequence_id is None and not opts.urn:
                raise TypeError("Missing required property 'approval_sequence_id'")
            __props__.__dict__["approval_sequence_id"] = approval_sequence_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["requester_settings"] = requester_settings
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["created"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["status"] = None
        super(RequestCondition, __self__).__init__(
            'okta:index/requestCondition:RequestCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_duration_settings: Optional[pulumi.Input[Union['RequestConditionAccessDurationSettingsArgs', 'RequestConditionAccessDurationSettingsArgsDict']]] = None,
            access_scope_settings: Optional[pulumi.Input[Union['RequestConditionAccessScopeSettingsArgs', 'RequestConditionAccessScopeSettingsArgsDict']]] = None,
            approval_sequence_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            requester_settings: Optional[pulumi.Input[Union['RequestConditionRequesterSettingsArgs', 'RequestConditionRequesterSettingsArgsDict']]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RequestCondition':
        """
        Get an existing RequestCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RequestConditionAccessDurationSettingsArgs', 'RequestConditionAccessDurationSettingsArgsDict']] access_duration_settings: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] approval_sequence_id: The ID of the approval sequence.
        :param pulumi.Input[_builtins.str] created: The date and time when the request condition was created.
        :param pulumi.Input[_builtins.str] created_by: The id of the user who created the request condition.
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] last_updated: The date and time when the request condition was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of the user who last updated the request condition.
        :param pulumi.Input[_builtins.str] name: The name of the request condition.
        :param pulumi.Input[_builtins.int] priority: The priority of the request condition. Lower numbers indicate higher priority.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        :param pulumi.Input[_builtins.str] status: Status indicates if this condition is active or not. Default status is INACTIVE. Enum: `ACTIVE`, `INACTIVE`, `DELETED`, `INVALID`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestConditionState.__new__(_RequestConditionState)

        __props__.__dict__["access_duration_settings"] = access_duration_settings
        __props__.__dict__["access_scope_settings"] = access_scope_settings
        __props__.__dict__["approval_sequence_id"] = approval_sequence_id
        __props__.__dict__["created"] = created
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["requester_settings"] = requester_settings
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["status"] = status
        return RequestCondition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessDurationSettings")
    def access_duration_settings(self) -> pulumi.Output[Optional['outputs.RequestConditionAccessDurationSettings']]:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "access_duration_settings")

    @_builtins.property
    @pulumi.getter(name="accessScopeSettings")
    def access_scope_settings(self) -> pulumi.Output[Optional['outputs.RequestConditionAccessScopeSettings']]:
        return pulumi.get(self, "access_scope_settings")

    @_builtins.property
    @pulumi.getter(name="approvalSequenceId")
    def approval_sequence_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the approval sequence.
        """
        return pulumi.get(self, "approval_sequence_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the request condition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the request condition. Lower numbers indicate higher priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="requesterSettings")
    def requester_settings(self) -> pulumi.Output[Optional['outputs.RequestConditionRequesterSettings']]:
        return pulumi.get(self, "requester_settings")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status indicates if this condition is active or not. Default status is INACTIVE. Enum: `ACTIVE`, `INACTIVE`, `DELETED`, `INVALID`.
        """
        return pulumi.get(self, "status")

