# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RequestSequenceArgs', 'RequestSequence']

@pulumi.input_type
class RequestSequenceArgs:
    def __init__(__self__, *,
                 id_property: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RequestSequence resource.
        :param pulumi.Input[_builtins.str] id_property: The id of the sequence.Must be of 24 characters length.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        """
        pulumi.set(__self__, "id_property", id_property)
        pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the sequence.Must be of 24 characters length.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class _RequestSequenceState:
    def __init__(__self__, *,
                 compatible_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 link: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RequestSequence resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_resource_types: Enum: `APP`, `GROUP`.
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] id_property: The id of the sequence.Must be of 24 characters length.
        :param pulumi.Input[_builtins.str] link: Link to edit the request sequence.
        :param pulumi.Input[_builtins.str] name: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        """
        if compatible_resource_types is not None:
            pulumi.set(__self__, "compatible_resource_types", compatible_resource_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id_property is not None:
            pulumi.set(__self__, "id_property", id_property)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="compatibleResourceTypes")
    def compatible_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Enum: `APP`, `GROUP`.
        """
        return pulumi.get(self, "compatible_resource_types")

    @compatible_resource_types.setter
    def compatible_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatible_resource_types", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the sequence.Must be of 24 characters length.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link to edit the request sequence.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.type_token("okta:index/requestSequence:RequestSequence")
class RequestSequence(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages request sequence. This resource allows you to read and delete an Okta [request-sequence](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Sequences/#tag/Request-Sequences).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.RequestSequence("test",
            id_property="<sequence_id>",
            resource_id="<resource_id>")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestSequence:RequestSequence example <resource_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] id_property: The id of the sequence.Must be of 24 characters length.
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestSequenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages request sequence. This resource allows you to read and delete an Okta [request-sequence](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Sequences/#tag/Request-Sequences).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.RequestSequence("test",
            id_property="<sequence_id>",
            resource_id="<resource_id>")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestSequence:RequestSequence example <resource_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param RequestSequenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestSequenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestSequenceArgs.__new__(RequestSequenceArgs)

            if id_property is None and not opts.urn:
                raise TypeError("Missing required property 'id_property'")
            __props__.__dict__["id_property"] = id_property
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["compatible_resource_types"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["link"] = None
            __props__.__dict__["name"] = None
        super(RequestSequence, __self__).__init__(
            'okta:index/requestSequence:RequestSequence',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compatible_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            id_property: Optional[pulumi.Input[_builtins.str]] = None,
            link: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RequestSequence':
        """
        Get an existing RequestSequence resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_resource_types: Enum: `APP`, `GROUP`.
        :param pulumi.Input[_builtins.str] description: The description of the request condition.
        :param pulumi.Input[_builtins.str] id_property: The id of the sequence.Must be of 24 characters length.
        :param pulumi.Input[_builtins.str] link: Link to edit the request sequence.
        :param pulumi.Input[_builtins.str] name: The access duration settings for the request condition
        :param pulumi.Input[_builtins.str] resource_id: The id of the resource in Okta ID format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestSequenceState.__new__(_RequestSequenceState)

        __props__.__dict__["compatible_resource_types"] = compatible_resource_types
        __props__.__dict__["description"] = description
        __props__.__dict__["id_property"] = id_property
        __props__.__dict__["link"] = link
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_id"] = resource_id
        return RequestSequence(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compatibleResourceTypes")
    def compatible_resource_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Enum: `APP`, `GROUP`.
        """
        return pulumi.get(self, "compatible_resource_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the request condition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the sequence.Must be of 24 characters length.
        """
        return pulumi.get(self, "id_property")

    @_builtins.property
    @pulumi.getter
    def link(self) -> pulumi.Output[_builtins.str]:
        """
        Link to edit the request sequence.
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The access duration settings for the request condition
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "resource_id")

