# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RequestSettingOrganizationArgs', 'RequestSettingOrganization']

@pulumi.input_type
class RequestSettingOrganizationArgs:
    def __init__(__self__, *,
                 id_property: pulumi.Input[_builtins.str],
                 subprocessors_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a RequestSettingOrganization resource.
        :param pulumi.Input[_builtins.str] id_property: Request condition id.
        :param pulumi.Input[_builtins.bool] subprocessors_acknowledged: Whether a customer has acknowledged Access Requests subprocessors.
        """
        pulumi.set(__self__, "id_property", id_property)
        if subprocessors_acknowledged is not None:
            pulumi.set(__self__, "subprocessors_acknowledged", subprocessors_acknowledged)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Input[_builtins.str]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter(name="subprocessorsAcknowledged")
    def subprocessors_acknowledged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether a customer has acknowledged Access Requests subprocessors.
        """
        return pulumi.get(self, "subprocessors_acknowledged")

    @subprocessors_acknowledged.setter
    def subprocessors_acknowledged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subprocessors_acknowledged", value)


@pulumi.input_type
class _RequestSettingOrganizationState:
    def __init__(__self__, *,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 subprocessors_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RequestSettingOrganization resources.
        :param pulumi.Input[_builtins.str] id_property: Request condition id.
        :param pulumi.Input[_builtins.bool] subprocessors_acknowledged: Whether a customer has acknowledged Access Requests subprocessors.
        """
        if id_property is not None:
            pulumi.set(__self__, "id_property", id_property)
        if subprocessors_acknowledged is not None:
            pulumi.set(__self__, "subprocessors_acknowledged", subprocessors_acknowledged)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter(name="subprocessorsAcknowledged")
    def subprocessors_acknowledged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether a customer has acknowledged Access Requests subprocessors.
        """
        return pulumi.get(self, "subprocessors_acknowledged")

    @subprocessors_acknowledged.setter
    def subprocessors_acknowledged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subprocessors_acknowledged", value)


@pulumi.type_token("okta:index/requestSettingOrganization:RequestSettingOrganization")
class RequestSettingOrganization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 subprocessors_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages request settings. This resource allows you to read and configure an Okta [request-setting](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Settings/#tag/Request-Settings/operation/updateOrgRequestSettingsV2).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RequestCondition("example",
            resource_id="<resource_id>",
            approval_sequence_id="<approval_sequence_id>",
            name="<name>",
            access_scope_settings={
                "type": "RESOURCE_DEFAULT",
            },
            requester_settings={
                "type": "EVERYONE",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestSettingOrganization:RequestSettingOrganization example "default"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] id_property: Request condition id.
        :param pulumi.Input[_builtins.bool] subprocessors_acknowledged: Whether a customer has acknowledged Access Requests subprocessors.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestSettingOrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages request settings. This resource allows you to read and configure an Okta [request-setting](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Settings/#tag/Request-Settings/operation/updateOrgRequestSettingsV2).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.RequestCondition("example",
            resource_id="<resource_id>",
            approval_sequence_id="<approval_sequence_id>",
            name="<name>",
            access_scope_settings={
                "type": "RESOURCE_DEFAULT",
            },
            requester_settings={
                "type": "EVERYONE",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestSettingOrganization:RequestSettingOrganization example "default"
        ```

        :param str resource_name: The name of the resource.
        :param RequestSettingOrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestSettingOrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 subprocessors_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestSettingOrganizationArgs.__new__(RequestSettingOrganizationArgs)

            if id_property is None and not opts.urn:
                raise TypeError("Missing required property 'id_property'")
            __props__.__dict__["id_property"] = id_property
            __props__.__dict__["subprocessors_acknowledged"] = subprocessors_acknowledged
        super(RequestSettingOrganization, __self__).__init__(
            'okta:index/requestSettingOrganization:RequestSettingOrganization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            id_property: Optional[pulumi.Input[_builtins.str]] = None,
            subprocessors_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None) -> 'RequestSettingOrganization':
        """
        Get an existing RequestSettingOrganization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] id_property: Request condition id.
        :param pulumi.Input[_builtins.bool] subprocessors_acknowledged: Whether a customer has acknowledged Access Requests subprocessors.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestSettingOrganizationState.__new__(_RequestSettingOrganizationState)

        __props__.__dict__["id_property"] = id_property
        __props__.__dict__["subprocessors_acknowledged"] = subprocessors_acknowledged
        return RequestSettingOrganization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Output[_builtins.str]:
        """
        Request condition id.
        """
        return pulumi.get(self, "id_property")

    @_builtins.property
    @pulumi.getter(name="subprocessorsAcknowledged")
    def subprocessors_acknowledged(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether a customer has acknowledged Access Requests subprocessors.
        """
        return pulumi.get(self, "subprocessors_acknowledged")

