# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RequestSettingResourceArgs', 'RequestSettingResource']

@pulumi.input_type
class RequestSettingResourceArgs:
    def __init__(__self__, *,
                 id_property: pulumi.Input[_builtins.str],
                 request_on_behalf_of_settings: Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']] = None,
                 risk_settings: Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']] = None):
        """
        The set of arguments for constructing a RequestSettingResource resource.
        :param pulumi.Input[_builtins.str] id_property: The id of the resource in Okta ID format.
        :param pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs'] request_on_behalf_of_settings: Specifies if and for whom a requester may request the resource for.
        :param pulumi.Input['RequestSettingResourceRiskSettingsArgs'] risk_settings: Risk settings for the resource.
        """
        pulumi.set(__self__, "id_property", id_property)
        if request_on_behalf_of_settings is not None:
            pulumi.set(__self__, "request_on_behalf_of_settings", request_on_behalf_of_settings)
        if risk_settings is not None:
            pulumi.set(__self__, "risk_settings", risk_settings)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter(name="requestOnBehalfOfSettings")
    def request_on_behalf_of_settings(self) -> Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']]:
        """
        Specifies if and for whom a requester may request the resource for.
        """
        return pulumi.get(self, "request_on_behalf_of_settings")

    @request_on_behalf_of_settings.setter
    def request_on_behalf_of_settings(self, value: Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']]):
        pulumi.set(self, "request_on_behalf_of_settings", value)

    @_builtins.property
    @pulumi.getter(name="riskSettings")
    def risk_settings(self) -> Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']]:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "risk_settings")

    @risk_settings.setter
    def risk_settings(self, value: Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']]):
        pulumi.set(self, "risk_settings", value)


@pulumi.input_type
class _RequestSettingResourceState:
    def __init__(__self__, *,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 request_on_behalf_of_settings: Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']] = None,
                 risk_settings: Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering RequestSettingResource resources.
        :param pulumi.Input[_builtins.str] id_property: The id of the resource in Okta ID format.
        :param pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs'] request_on_behalf_of_settings: Specifies if and for whom a requester may request the resource for.
        :param pulumi.Input['RequestSettingResourceRiskSettingsArgs'] risk_settings: Risk settings for the resource.
        """
        if id_property is not None:
            pulumi.set(__self__, "id_property", id_property)
        if request_on_behalf_of_settings is not None:
            pulumi.set(__self__, "request_on_behalf_of_settings", request_on_behalf_of_settings)
        if risk_settings is not None:
            pulumi.set(__self__, "risk_settings", risk_settings)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "id_property")

    @id_property.setter
    def id_property(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_property", value)

    @_builtins.property
    @pulumi.getter(name="requestOnBehalfOfSettings")
    def request_on_behalf_of_settings(self) -> Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']]:
        """
        Specifies if and for whom a requester may request the resource for.
        """
        return pulumi.get(self, "request_on_behalf_of_settings")

    @request_on_behalf_of_settings.setter
    def request_on_behalf_of_settings(self, value: Optional[pulumi.Input['RequestSettingResourceRequestOnBehalfOfSettingsArgs']]):
        pulumi.set(self, "request_on_behalf_of_settings", value)

    @_builtins.property
    @pulumi.getter(name="riskSettings")
    def risk_settings(self) -> Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']]:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "risk_settings")

    @risk_settings.setter
    def risk_settings(self, value: Optional[pulumi.Input['RequestSettingResourceRiskSettingsArgs']]):
        pulumi.set(self, "risk_settings", value)


@pulumi.type_token("okta:index/requestSettingResource:RequestSettingResource")
class RequestSettingResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 request_on_behalf_of_settings: Optional[pulumi.Input[Union['RequestSettingResourceRequestOnBehalfOfSettingsArgs', 'RequestSettingResourceRequestOnBehalfOfSettingsArgsDict']]] = None,
                 risk_settings: Optional[pulumi.Input[Union['RequestSettingResourceRiskSettingsArgs', 'RequestSettingResourceRiskSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Manages request settings. This resource allows you to read and configure an Okta [request-setting](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Settings/#tag/Request-Settings/operation/getRequestSettingsV2).

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:index/requestSettingResource:RequestSettingResource example "<resource_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] id_property: The id of the resource in Okta ID format.
        :param pulumi.Input[Union['RequestSettingResourceRequestOnBehalfOfSettingsArgs', 'RequestSettingResourceRequestOnBehalfOfSettingsArgsDict']] request_on_behalf_of_settings: Specifies if and for whom a requester may request the resource for.
        :param pulumi.Input[Union['RequestSettingResourceRiskSettingsArgs', 'RequestSettingResourceRiskSettingsArgsDict']] risk_settings: Risk settings for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestSettingResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages request settings. This resource allows you to read and configure an Okta [request-setting](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Request-Settings/#tag/Request-Settings/operation/getRequestSettingsV2).

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:index/requestSettingResource:RequestSettingResource example "<resource_id>"
        ```

        :param str resource_name: The name of the resource.
        :param RequestSettingResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestSettingResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 id_property: Optional[pulumi.Input[_builtins.str]] = None,
                 request_on_behalf_of_settings: Optional[pulumi.Input[Union['RequestSettingResourceRequestOnBehalfOfSettingsArgs', 'RequestSettingResourceRequestOnBehalfOfSettingsArgsDict']]] = None,
                 risk_settings: Optional[pulumi.Input[Union['RequestSettingResourceRiskSettingsArgs', 'RequestSettingResourceRiskSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestSettingResourceArgs.__new__(RequestSettingResourceArgs)

            if id_property is None and not opts.urn:
                raise TypeError("Missing required property 'id_property'")
            __props__.__dict__["id_property"] = id_property
            __props__.__dict__["request_on_behalf_of_settings"] = request_on_behalf_of_settings
            __props__.__dict__["risk_settings"] = risk_settings
        super(RequestSettingResource, __self__).__init__(
            'okta:index/requestSettingResource:RequestSettingResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            id_property: Optional[pulumi.Input[_builtins.str]] = None,
            request_on_behalf_of_settings: Optional[pulumi.Input[Union['RequestSettingResourceRequestOnBehalfOfSettingsArgs', 'RequestSettingResourceRequestOnBehalfOfSettingsArgsDict']]] = None,
            risk_settings: Optional[pulumi.Input[Union['RequestSettingResourceRiskSettingsArgs', 'RequestSettingResourceRiskSettingsArgsDict']]] = None) -> 'RequestSettingResource':
        """
        Get an existing RequestSettingResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] id_property: The id of the resource in Okta ID format.
        :param pulumi.Input[Union['RequestSettingResourceRequestOnBehalfOfSettingsArgs', 'RequestSettingResourceRequestOnBehalfOfSettingsArgsDict']] request_on_behalf_of_settings: Specifies if and for whom a requester may request the resource for.
        :param pulumi.Input[Union['RequestSettingResourceRiskSettingsArgs', 'RequestSettingResourceRiskSettingsArgsDict']] risk_settings: Risk settings for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestSettingResourceState.__new__(_RequestSettingResourceState)

        __props__.__dict__["id_property"] = id_property
        __props__.__dict__["request_on_behalf_of_settings"] = request_on_behalf_of_settings
        __props__.__dict__["risk_settings"] = risk_settings
        return RequestSettingResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="idProperty")
    def id_property(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the resource in Okta ID format.
        """
        return pulumi.get(self, "id_property")

    @_builtins.property
    @pulumi.getter(name="requestOnBehalfOfSettings")
    def request_on_behalf_of_settings(self) -> pulumi.Output[Optional['outputs.RequestSettingResourceRequestOnBehalfOfSettings']]:
        """
        Specifies if and for whom a requester may request the resource for.
        """
        return pulumi.get(self, "request_on_behalf_of_settings")

    @_builtins.property
    @pulumi.getter(name="riskSettings")
    def risk_settings(self) -> pulumi.Output[Optional['outputs.RequestSettingResourceRiskSettings']]:
        """
        Risk settings for the resource.
        """
        return pulumi.get(self, "risk_settings")

