# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RequestV2Args', 'RequestV2']

@pulumi.input_type
class RequestV2Args:
    def __init__(__self__, *,
                 requested: Optional[pulumi.Input['RequestV2RequestedArgs']] = None,
                 requested_for: Optional[pulumi.Input['RequestV2RequestedForArgs']] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]] = None):
        """
        The set of arguments for constructing a RequestV2 resource.
        :param pulumi.Input['RequestV2RequestedArgs'] requested: A representation of a resource that can be requested for access.
        :param pulumi.Input['RequestV2RequestedForArgs'] requested_for: A representation of a principal.
        :param pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]] requester_field_values: The requester input fields required by the approval system.
        """
        if requested is not None:
            pulumi.set(__self__, "requested", requested)
        if requested_for is not None:
            pulumi.set(__self__, "requested_for", requested_for)
        if requester_field_values is not None:
            pulumi.set(__self__, "requester_field_values", requester_field_values)

    @_builtins.property
    @pulumi.getter
    def requested(self) -> Optional[pulumi.Input['RequestV2RequestedArgs']]:
        """
        A representation of a resource that can be requested for access.
        """
        return pulumi.get(self, "requested")

    @requested.setter
    def requested(self, value: Optional[pulumi.Input['RequestV2RequestedArgs']]):
        pulumi.set(self, "requested", value)

    @_builtins.property
    @pulumi.getter(name="requestedFor")
    def requested_for(self) -> Optional[pulumi.Input['RequestV2RequestedForArgs']]:
        """
        A representation of a principal.
        """
        return pulumi.get(self, "requested_for")

    @requested_for.setter
    def requested_for(self, value: Optional[pulumi.Input['RequestV2RequestedForArgs']]):
        pulumi.set(self, "requested_for", value)

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]]:
        """
        The requester input fields required by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @requester_field_values.setter
    def requester_field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]]):
        pulumi.set(self, "requester_field_values", value)


@pulumi.input_type
class _RequestV2State:
    def __init__(__self__, *,
                 access_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_status: Optional[pulumi.Input[_builtins.str]] = None,
                 granted: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 requested: Optional[pulumi.Input['RequestV2RequestedArgs']] = None,
                 requested_for: Optional[pulumi.Input['RequestV2RequestedForArgs']] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]] = None,
                 resolved: Optional[pulumi.Input[_builtins.str]] = None,
                 revocation_scheduled: Optional[pulumi.Input[_builtins.str]] = None,
                 revocation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 revoked: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RequestV2 resources.
        :param pulumi.Input[_builtins.str] access_duration: How long the requester retains access after their request is approved and fulfilled.
        :param pulumi.Input[_builtins.str] created: The date and time when the request condition was created.
        :param pulumi.Input[_builtins.str] created_by: The id of the user who created the request condition.
        :param pulumi.Input[_builtins.str] grant_status: The status of the granted access request.
        :param pulumi.Input[_builtins.str] granted: The date the approved access was granted. Only set if request . Status is APPROVED.
        :param pulumi.Input[_builtins.str] last_updated: The date and time when the request condition was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of the user who last updated the request condition.
        :param pulumi.Input['RequestV2RequestedArgs'] requested: A representation of a resource that can be requested for access.
        :param pulumi.Input['RequestV2RequestedForArgs'] requested_for: A representation of a principal.
        :param pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]] requester_field_values: The requester input fields required by the approval system.
        :param pulumi.Input[_builtins.str] resolved: The date the request was resolved.
        :param pulumi.Input[_builtins.str] revocation_scheduled: The date the request was scheduled for revocation.
        :param pulumi.Input[_builtins.str] revocation_status: The revocation status of the request.
        :param pulumi.Input[_builtins.str] revoked: The date the granted access was revoked.
        :param pulumi.Input[_builtins.str] status: The status of the request.
        """
        if access_duration is not None:
            pulumi.set(__self__, "access_duration", access_duration)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if grant_status is not None:
            pulumi.set(__self__, "grant_status", grant_status)
        if granted is not None:
            pulumi.set(__self__, "granted", granted)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if requested is not None:
            pulumi.set(__self__, "requested", requested)
        if requested_for is not None:
            pulumi.set(__self__, "requested_for", requested_for)
        if requester_field_values is not None:
            pulumi.set(__self__, "requester_field_values", requester_field_values)
        if resolved is not None:
            pulumi.set(__self__, "resolved", resolved)
        if revocation_scheduled is not None:
            pulumi.set(__self__, "revocation_scheduled", revocation_scheduled)
        if revocation_status is not None:
            pulumi.set(__self__, "revocation_status", revocation_status)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessDuration")
    def access_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long the requester retains access after their request is approved and fulfilled.
        """
        return pulumi.get(self, "access_duration")

    @access_duration.setter
    def access_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_duration", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="grantStatus")
    def grant_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the granted access request.
        """
        return pulumi.get(self, "grant_status")

    @grant_status.setter
    def grant_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grant_status", value)

    @_builtins.property
    @pulumi.getter
    def granted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the approved access was granted. Only set if request . Status is APPROVED.
        """
        return pulumi.get(self, "granted")

    @granted.setter
    def granted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granted", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def requested(self) -> Optional[pulumi.Input['RequestV2RequestedArgs']]:
        """
        A representation of a resource that can be requested for access.
        """
        return pulumi.get(self, "requested")

    @requested.setter
    def requested(self, value: Optional[pulumi.Input['RequestV2RequestedArgs']]):
        pulumi.set(self, "requested", value)

    @_builtins.property
    @pulumi.getter(name="requestedFor")
    def requested_for(self) -> Optional[pulumi.Input['RequestV2RequestedForArgs']]:
        """
        A representation of a principal.
        """
        return pulumi.get(self, "requested_for")

    @requested_for.setter
    def requested_for(self, value: Optional[pulumi.Input['RequestV2RequestedForArgs']]):
        pulumi.set(self, "requested_for", value)

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]]:
        """
        The requester input fields required by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @requester_field_values.setter
    def requester_field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RequestV2RequesterFieldValueArgs']]]]):
        pulumi.set(self, "requester_field_values", value)

    @_builtins.property
    @pulumi.getter
    def resolved(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the request was resolved.
        """
        return pulumi.get(self, "resolved")

    @resolved.setter
    def resolved(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolved", value)

    @_builtins.property
    @pulumi.getter(name="revocationScheduled")
    def revocation_scheduled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the request was scheduled for revocation.
        """
        return pulumi.get(self, "revocation_scheduled")

    @revocation_scheduled.setter
    def revocation_scheduled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_scheduled", value)

    @_builtins.property
    @pulumi.getter(name="revocationStatus")
    def revocation_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revocation status of the request.
        """
        return pulumi.get(self, "revocation_status")

    @revocation_status.setter
    def revocation_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_status", value)

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the granted access was revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revoked", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the request.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("okta:index/requestV2:RequestV2")
class RequestV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 requested: Optional[pulumi.Input[Union['RequestV2RequestedArgs', 'RequestV2RequestedArgsDict']]] = None,
                 requested_for: Optional[pulumi.Input[Union['RequestV2RequestedForArgs', 'RequestV2RequestedForArgsDict']]] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RequestV2RequesterFieldValueArgs', 'RequestV2RequesterFieldValueArgsDict']]]]] = None,
                 __props__=None):
        """
        Manage the access request process. This resource allows you to create and read an Okta [request](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Requests/#tag/Requests).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.RequestV2("test",
            requested={
                "type": "CATALOG_ENTRY",
                "entry_id": "<entry_id>",
            },
            requested_for={
                "type": "OKTA_USER",
                "external_id": "<user_id>",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestV2:RequestV2 example <request_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RequestV2RequestedArgs', 'RequestV2RequestedArgsDict']] requested: A representation of a resource that can be requested for access.
        :param pulumi.Input[Union['RequestV2RequestedForArgs', 'RequestV2RequestedForArgsDict']] requested_for: A representation of a principal.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RequestV2RequesterFieldValueArgs', 'RequestV2RequesterFieldValueArgsDict']]]] requester_field_values: The requester input fields required by the approval system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RequestV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage the access request process. This resource allows you to create and read an Okta [request](https://developer.okta.com/docs/api/iga/openapi/governance.requests.admin.v2/tag/Requests/#tag/Requests).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.RequestV2("test",
            requested={
                "type": "CATALOG_ENTRY",
                "entry_id": "<entry_id>",
            },
            requested_for={
                "type": "OKTA_USER",
                "external_id": "<user_id>",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/requestV2:RequestV2 example <request_id>
        ```

        :param str resource_name: The name of the resource.
        :param RequestV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 requested: Optional[pulumi.Input[Union['RequestV2RequestedArgs', 'RequestV2RequestedArgsDict']]] = None,
                 requested_for: Optional[pulumi.Input[Union['RequestV2RequestedForArgs', 'RequestV2RequestedForArgsDict']]] = None,
                 requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RequestV2RequesterFieldValueArgs', 'RequestV2RequesterFieldValueArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestV2Args.__new__(RequestV2Args)

            __props__.__dict__["requested"] = requested
            __props__.__dict__["requested_for"] = requested_for
            __props__.__dict__["requester_field_values"] = requester_field_values
            __props__.__dict__["access_duration"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["grant_status"] = None
            __props__.__dict__["granted"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["resolved"] = None
            __props__.__dict__["revocation_scheduled"] = None
            __props__.__dict__["revocation_status"] = None
            __props__.__dict__["revoked"] = None
            __props__.__dict__["status"] = None
        super(RequestV2, __self__).__init__(
            'okta:index/requestV2:RequestV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_duration: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            grant_status: Optional[pulumi.Input[_builtins.str]] = None,
            granted: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            requested: Optional[pulumi.Input[Union['RequestV2RequestedArgs', 'RequestV2RequestedArgsDict']]] = None,
            requested_for: Optional[pulumi.Input[Union['RequestV2RequestedForArgs', 'RequestV2RequestedForArgsDict']]] = None,
            requester_field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RequestV2RequesterFieldValueArgs', 'RequestV2RequesterFieldValueArgsDict']]]]] = None,
            resolved: Optional[pulumi.Input[_builtins.str]] = None,
            revocation_scheduled: Optional[pulumi.Input[_builtins.str]] = None,
            revocation_status: Optional[pulumi.Input[_builtins.str]] = None,
            revoked: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RequestV2':
        """
        Get an existing RequestV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_duration: How long the requester retains access after their request is approved and fulfilled.
        :param pulumi.Input[_builtins.str] created: The date and time when the request condition was created.
        :param pulumi.Input[_builtins.str] created_by: The id of the user who created the request condition.
        :param pulumi.Input[_builtins.str] grant_status: The status of the granted access request.
        :param pulumi.Input[_builtins.str] granted: The date the approved access was granted. Only set if request . Status is APPROVED.
        :param pulumi.Input[_builtins.str] last_updated: The date and time when the request condition was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of the user who last updated the request condition.
        :param pulumi.Input[Union['RequestV2RequestedArgs', 'RequestV2RequestedArgsDict']] requested: A representation of a resource that can be requested for access.
        :param pulumi.Input[Union['RequestV2RequestedForArgs', 'RequestV2RequestedForArgsDict']] requested_for: A representation of a principal.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RequestV2RequesterFieldValueArgs', 'RequestV2RequesterFieldValueArgsDict']]]] requester_field_values: The requester input fields required by the approval system.
        :param pulumi.Input[_builtins.str] resolved: The date the request was resolved.
        :param pulumi.Input[_builtins.str] revocation_scheduled: The date the request was scheduled for revocation.
        :param pulumi.Input[_builtins.str] revocation_status: The revocation status of the request.
        :param pulumi.Input[_builtins.str] revoked: The date the granted access was revoked.
        :param pulumi.Input[_builtins.str] status: The status of the request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestV2State.__new__(_RequestV2State)

        __props__.__dict__["access_duration"] = access_duration
        __props__.__dict__["created"] = created
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["grant_status"] = grant_status
        __props__.__dict__["granted"] = granted
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["requested"] = requested
        __props__.__dict__["requested_for"] = requested_for
        __props__.__dict__["requester_field_values"] = requester_field_values
        __props__.__dict__["resolved"] = resolved
        __props__.__dict__["revocation_scheduled"] = revocation_scheduled
        __props__.__dict__["revocation_status"] = revocation_status
        __props__.__dict__["revoked"] = revoked
        __props__.__dict__["status"] = status
        return RequestV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessDuration")
    def access_duration(self) -> pulumi.Output[_builtins.str]:
        """
        How long the requester retains access after their request is approved and fulfilled.
        """
        return pulumi.get(self, "access_duration")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the request condition was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the user who created the request condition.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="grantStatus")
    def grant_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the granted access request.
        """
        return pulumi.get(self, "grant_status")

    @_builtins.property
    @pulumi.getter
    def granted(self) -> pulumi.Output[_builtins.str]:
        """
        The date the approved access was granted. Only set if request . Status is APPROVED.
        """
        return pulumi.get(self, "granted")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the request condition was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the user who last updated the request condition.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def requested(self) -> pulumi.Output[Optional['outputs.RequestV2Requested']]:
        """
        A representation of a resource that can be requested for access.
        """
        return pulumi.get(self, "requested")

    @_builtins.property
    @pulumi.getter(name="requestedFor")
    def requested_for(self) -> pulumi.Output[Optional['outputs.RequestV2RequestedFor']]:
        """
        A representation of a principal.
        """
        return pulumi.get(self, "requested_for")

    @_builtins.property
    @pulumi.getter(name="requesterFieldValues")
    def requester_field_values(self) -> pulumi.Output[Optional[Sequence['outputs.RequestV2RequesterFieldValue']]]:
        """
        The requester input fields required by the approval system.
        """
        return pulumi.get(self, "requester_field_values")

    @_builtins.property
    @pulumi.getter
    def resolved(self) -> pulumi.Output[_builtins.str]:
        """
        The date the request was resolved.
        """
        return pulumi.get(self, "resolved")

    @_builtins.property
    @pulumi.getter(name="revocationScheduled")
    def revocation_scheduled(self) -> pulumi.Output[_builtins.str]:
        """
        The date the request was scheduled for revocation.
        """
        return pulumi.get(self, "revocation_scheduled")

    @_builtins.property
    @pulumi.getter(name="revocationStatus")
    def revocation_status(self) -> pulumi.Output[_builtins.str]:
        """
        The revocation status of the request.
        """
        return pulumi.get(self, "revocation_status")

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> pulumi.Output[_builtins.str]:
        """
        The date the granted access was revoked.
        """
        return pulumi.get(self, "revoked")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the request.
        """
        return pulumi.get(self, "status")

