# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReviewArgs', 'Review']

@pulumi.input_type
class ReviewArgs:
    def __init__(__self__, *,
                 campaign_id: pulumi.Input[_builtins.str],
                 note: pulumi.Input[_builtins.str],
                 review_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 reviewer_id: pulumi.Input[_builtins.str],
                 reviewer_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Review resource.
        :param pulumi.Input[_builtins.str] campaign_id: The id of the campaign.
        :param pulumi.Input[_builtins.str] note: A note to justify the reassignment decision for the specified review.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] review_ids: A list of reviews (review id values) that are reassigned to the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_id: The Okta user id of the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_level: Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        """
        pulumi.set(__self__, "campaign_id", campaign_id)
        pulumi.set(__self__, "note", note)
        pulumi.set(__self__, "review_ids", review_ids)
        pulumi.set(__self__, "reviewer_id", reviewer_id)
        if reviewer_level is not None:
            pulumi.set(__self__, "reviewer_level", reviewer_level)

    @_builtins.property
    @pulumi.getter(name="campaignId")
    def campaign_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the campaign.
        """
        return pulumi.get(self, "campaign_id")

    @campaign_id.setter
    def campaign_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "campaign_id", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Input[_builtins.str]:
        """
        A note to justify the reassignment decision for the specified review.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="reviewIds")
    def review_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of reviews (review id values) that are reassigned to the new reviewer.
        """
        return pulumi.get(self, "review_ids")

    @review_ids.setter
    def review_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "review_ids", value)

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Okta user id of the new reviewer.
        """
        return pulumi.get(self, "reviewer_id")

    @reviewer_id.setter
    def reviewer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reviewer_id", value)

    @_builtins.property
    @pulumi.getter(name="reviewerLevel")
    def reviewer_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        """
        return pulumi.get(self, "reviewer_level")

    @reviewer_level.setter
    def reviewer_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reviewer_level", value)


@pulumi.input_type
class _ReviewState:
    def __init__(__self__, *,
                 campaign_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 review_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reviewer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reviewer_level: Optional[pulumi.Input[_builtins.str]] = None,
                 reviewer_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Review resources.
        :param pulumi.Input[_builtins.str] campaign_id: The id of the campaign.
        :param pulumi.Input[_builtins.str] created: The ISO 8601 formatted date and time when the resource was created
        :param pulumi.Input[_builtins.str] created_by: The id of user who created the resource.
        :param pulumi.Input[_builtins.str] decision: The decision of the reviewer.
        :param pulumi.Input[_builtins.str] last_updated: The ISO 8601 formatted date and time when the object was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of user who last updated the object.
        :param pulumi.Input[_builtins.str] note: A note to justify the reassignment decision for the specified review.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] review_ids: A list of reviews (review id values) that are reassigned to the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_id: The Okta user id of the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_level: Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        :param pulumi.Input[_builtins.str] reviewer_type: The type of reviewer to which the review is assigned.
        """
        if campaign_id is not None:
            pulumi.set(__self__, "campaign_id", campaign_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if decision is not None:
            pulumi.set(__self__, "decision", decision)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if review_ids is not None:
            pulumi.set(__self__, "review_ids", review_ids)
        if reviewer_id is not None:
            pulumi.set(__self__, "reviewer_id", reviewer_id)
        if reviewer_level is not None:
            pulumi.set(__self__, "reviewer_level", reviewer_level)
        if reviewer_type is not None:
            pulumi.set(__self__, "reviewer_type", reviewer_type)

    @_builtins.property
    @pulumi.getter(name="campaignId")
    def campaign_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the campaign.
        """
        return pulumi.get(self, "campaign_id")

    @campaign_id.setter
    def campaign_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "campaign_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 formatted date and time when the resource was created
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of user who created the resource.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The decision of the reviewer.
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 formatted date and time when the object was last updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of user who last updated the object.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A note to justify the reassignment decision for the specified review.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="reviewIds")
    def review_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of reviews (review id values) that are reassigned to the new reviewer.
        """
        return pulumi.get(self, "review_ids")

    @review_ids.setter
    def review_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "review_ids", value)

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Okta user id of the new reviewer.
        """
        return pulumi.get(self, "reviewer_id")

    @reviewer_id.setter
    def reviewer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reviewer_id", value)

    @_builtins.property
    @pulumi.getter(name="reviewerLevel")
    def reviewer_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        """
        return pulumi.get(self, "reviewer_level")

    @reviewer_level.setter
    def reviewer_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reviewer_level", value)

    @_builtins.property
    @pulumi.getter(name="reviewerType")
    def reviewer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of reviewer to which the review is assigned.
        """
        return pulumi.get(self, "reviewer_type")

    @reviewer_type.setter
    def reviewer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reviewer_type", value)


@pulumi.type_token("okta:index/review:Review")
class Review(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 campaign_id: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 review_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reviewer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reviewer_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages reassignment of review.

        This resource allows you to reassign an already existing review.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.Review("test",
            campaign_id="icizigd86iM9sOcbN1d6",
            reviewer_id="00unli90kor62oF5Z1d7",
            review_ids=["icrztblxbBFiVKepb1d6"],
            reviewer_level="FIRST",
            note="John Smith is on leave for this month. His manager Tim will be the reviewer instead.")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/review:Review example <review_id?
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] campaign_id: The id of the campaign.
        :param pulumi.Input[_builtins.str] note: A note to justify the reassignment decision for the specified review.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] review_ids: A list of reviews (review id values) that are reassigned to the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_id: The Okta user id of the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_level: Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReviewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages reassignment of review.

        This resource allows you to reassign an already existing review.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.Review("test",
            campaign_id="icizigd86iM9sOcbN1d6",
            reviewer_id="00unli90kor62oF5Z1d7",
            review_ids=["icrztblxbBFiVKepb1d6"],
            reviewer_level="FIRST",
            note="John Smith is on leave for this month. His manager Tim will be the reviewer instead.")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/review:Review example <review_id?
        ```

        :param str resource_name: The name of the resource.
        :param ReviewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReviewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 campaign_id: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 review_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reviewer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reviewer_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReviewArgs.__new__(ReviewArgs)

            if campaign_id is None and not opts.urn:
                raise TypeError("Missing required property 'campaign_id'")
            __props__.__dict__["campaign_id"] = campaign_id
            if note is None and not opts.urn:
                raise TypeError("Missing required property 'note'")
            __props__.__dict__["note"] = note
            if review_ids is None and not opts.urn:
                raise TypeError("Missing required property 'review_ids'")
            __props__.__dict__["review_ids"] = review_ids
            if reviewer_id is None and not opts.urn:
                raise TypeError("Missing required property 'reviewer_id'")
            __props__.__dict__["reviewer_id"] = reviewer_id
            __props__.__dict__["reviewer_level"] = reviewer_level
            __props__.__dict__["created"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["decision"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["reviewer_type"] = None
        super(Review, __self__).__init__(
            'okta:index/review:Review',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            campaign_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            decision: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            review_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            reviewer_id: Optional[pulumi.Input[_builtins.str]] = None,
            reviewer_level: Optional[pulumi.Input[_builtins.str]] = None,
            reviewer_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Review':
        """
        Get an existing Review resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] campaign_id: The id of the campaign.
        :param pulumi.Input[_builtins.str] created: The ISO 8601 formatted date and time when the resource was created
        :param pulumi.Input[_builtins.str] created_by: The id of user who created the resource.
        :param pulumi.Input[_builtins.str] decision: The decision of the reviewer.
        :param pulumi.Input[_builtins.str] last_updated: The ISO 8601 formatted date and time when the object was last updated.
        :param pulumi.Input[_builtins.str] last_updated_by: The id of user who last updated the object.
        :param pulumi.Input[_builtins.str] note: A note to justify the reassignment decision for the specified review.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] review_ids: A list of reviews (review id values) that are reassigned to the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_id: The Okta user id of the new reviewer.
        :param pulumi.Input[_builtins.str] reviewer_level: Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        :param pulumi.Input[_builtins.str] reviewer_type: The type of reviewer to which the review is assigned.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReviewState.__new__(_ReviewState)

        __props__.__dict__["campaign_id"] = campaign_id
        __props__.__dict__["created"] = created
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["decision"] = decision
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["note"] = note
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["review_ids"] = review_ids
        __props__.__dict__["reviewer_id"] = reviewer_id
        __props__.__dict__["reviewer_level"] = reviewer_level
        __props__.__dict__["reviewer_type"] = reviewer_type
        return Review(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="campaignId")
    def campaign_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the campaign.
        """
        return pulumi.get(self, "campaign_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO 8601 formatted date and time when the resource was created
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of user who created the resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Output[_builtins.str]:
        """
        The decision of the reviewer.
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO 8601 formatted date and time when the object was last updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The id of user who last updated the object.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[_builtins.str]:
        """
        A note to justify the reassignment decision for the specified review.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="reviewIds")
    def review_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of reviews (review id values) that are reassigned to the new reviewer.
        """
        return pulumi.get(self, "review_ids")

    @_builtins.property
    @pulumi.getter(name="reviewerId")
    def reviewer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Okta user id of the new reviewer.
        """
        return pulumi.get(self, "reviewer_id")

    @_builtins.property
    @pulumi.getter(name="reviewerLevel")
    def reviewer_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifies the reviewer level of each reviews during access certification. Applicable for multi level campaigns only.
        """
        return pulumi.get(self, "reviewer_level")

    @_builtins.property
    @pulumi.getter(name="reviewerType")
    def reviewer_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of reviewer to which the review is assigned.
        """
        return pulumi.get(self, "reviewer_type")

