# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ThemeArgs', 'Theme']

@pulumi.input_type
class ThemeArgs:
    def __init__(__self__, *,
                 brand_id: pulumi.Input[_builtins.str],
                 background_image: Optional[pulumi.Input[_builtins.str]] = None,
                 email_template_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 end_user_dashboard_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 error_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 favicon: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_in_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Theme resource.
        :param pulumi.Input[_builtins.str] brand_id: Brand ID
        :param pulumi.Input[_builtins.str] background_image: Path to local file
        :param pulumi.Input[_builtins.str] email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param pulumi.Input[_builtins.str] end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param pulumi.Input[_builtins.str] error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] favicon: Path to local file
        :param pulumi.Input[_builtins.str] logo: Path to local file
        :param pulumi.Input[_builtins.str] primary_color_contrast_hex: Primary color contrast hex code
        :param pulumi.Input[_builtins.str] primary_color_hex: Primary color hex code
        :param pulumi.Input[_builtins.str] secondary_color_contrast_hex: Secondary color contrast hex code
        :param pulumi.Input[_builtins.str] secondary_color_hex: Secondary color hex code
        :param pulumi.Input[_builtins.str] sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] theme_id: Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        pulumi.set(__self__, "brand_id", brand_id)
        if background_image is not None:
            pulumi.set(__self__, "background_image", background_image)
        if email_template_touch_point_variant is not None:
            pulumi.set(__self__, "email_template_touch_point_variant", email_template_touch_point_variant)
        if end_user_dashboard_touch_point_variant is not None:
            pulumi.set(__self__, "end_user_dashboard_touch_point_variant", end_user_dashboard_touch_point_variant)
        if error_page_touch_point_variant is not None:
            pulumi.set(__self__, "error_page_touch_point_variant", error_page_touch_point_variant)
        if favicon is not None:
            pulumi.set(__self__, "favicon", favicon)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if primary_color_contrast_hex is not None:
            pulumi.set(__self__, "primary_color_contrast_hex", primary_color_contrast_hex)
        if primary_color_hex is not None:
            pulumi.set(__self__, "primary_color_hex", primary_color_hex)
        if secondary_color_contrast_hex is not None:
            pulumi.set(__self__, "secondary_color_contrast_hex", secondary_color_contrast_hex)
        if secondary_color_hex is not None:
            pulumi.set(__self__, "secondary_color_hex", secondary_color_hex)
        if sign_in_page_touch_point_variant is not None:
            pulumi.set(__self__, "sign_in_page_touch_point_variant", sign_in_page_touch_point_variant)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Input[_builtins.str]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "brand_id", value)

    @_builtins.property
    @pulumi.getter(name="backgroundImage")
    def background_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "background_image")

    @background_image.setter
    def background_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "background_image", value)

    @_builtins.property
    @pulumi.getter(name="emailTemplateTouchPointVariant")
    def email_template_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        """
        return pulumi.get(self, "email_template_touch_point_variant")

    @email_template_touch_point_variant.setter
    def email_template_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_template_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="endUserDashboardTouchPointVariant")
    def end_user_dashboard_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        """
        return pulumi.get(self, "end_user_dashboard_touch_point_variant")

    @end_user_dashboard_touch_point_variant.setter
    def end_user_dashboard_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_user_dashboard_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="errorPageTouchPointVariant")
    def error_page_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "error_page_touch_point_variant")

    @error_page_touch_point_variant.setter
    def error_page_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_page_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter
    def favicon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "favicon")

    @favicon.setter
    def favicon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "favicon", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="primaryColorContrastHex")
    def primary_color_contrast_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary color contrast hex code
        """
        return pulumi.get(self, "primary_color_contrast_hex")

    @primary_color_contrast_hex.setter
    def primary_color_contrast_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_color_contrast_hex", value)

    @_builtins.property
    @pulumi.getter(name="primaryColorHex")
    def primary_color_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary color hex code
        """
        return pulumi.get(self, "primary_color_hex")

    @primary_color_hex.setter
    def primary_color_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_color_hex", value)

    @_builtins.property
    @pulumi.getter(name="secondaryColorContrastHex")
    def secondary_color_contrast_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary color contrast hex code
        """
        return pulumi.get(self, "secondary_color_contrast_hex")

    @secondary_color_contrast_hex.setter
    def secondary_color_contrast_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_color_contrast_hex", value)

    @_builtins.property
    @pulumi.getter(name="secondaryColorHex")
    def secondary_color_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary color hex code
        """
        return pulumi.get(self, "secondary_color_hex")

    @secondary_color_hex.setter
    def secondary_color_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_color_hex", value)

    @_builtins.property
    @pulumi.getter(name="signInPageTouchPointVariant")
    def sign_in_page_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "sign_in_page_touch_point_variant")

    @sign_in_page_touch_point_variant.setter
    def sign_in_page_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_in_page_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme_id", value)


@pulumi.input_type
class _ThemeState:
    def __init__(__self__, *,
                 background_image: Optional[pulumi.Input[_builtins.str]] = None,
                 background_image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email_template_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 end_user_dashboard_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 error_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 favicon: Optional[pulumi.Input[_builtins.str]] = None,
                 favicon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_url: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_in_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Theme resources.
        :param pulumi.Input[_builtins.str] background_image: Path to local file
        :param pulumi.Input[_builtins.str] background_image_url: Background image URL
        :param pulumi.Input[_builtins.str] brand_id: Brand ID
        :param pulumi.Input[_builtins.str] email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param pulumi.Input[_builtins.str] end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param pulumi.Input[_builtins.str] error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] favicon: Path to local file
        :param pulumi.Input[_builtins.str] favicon_url: Favicon URL
        :param pulumi.Input[_builtins.str] links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param pulumi.Input[_builtins.str] logo: Path to local file
        :param pulumi.Input[_builtins.str] logo_url: Logo URL
        :param pulumi.Input[_builtins.str] primary_color_contrast_hex: Primary color contrast hex code
        :param pulumi.Input[_builtins.str] primary_color_hex: Primary color hex code
        :param pulumi.Input[_builtins.str] secondary_color_contrast_hex: Secondary color contrast hex code
        :param pulumi.Input[_builtins.str] secondary_color_hex: Secondary color hex code
        :param pulumi.Input[_builtins.str] sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] theme_id: Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        if background_image is not None:
            pulumi.set(__self__, "background_image", background_image)
        if background_image_url is not None:
            pulumi.set(__self__, "background_image_url", background_image_url)
        if brand_id is not None:
            pulumi.set(__self__, "brand_id", brand_id)
        if email_template_touch_point_variant is not None:
            pulumi.set(__self__, "email_template_touch_point_variant", email_template_touch_point_variant)
        if end_user_dashboard_touch_point_variant is not None:
            pulumi.set(__self__, "end_user_dashboard_touch_point_variant", end_user_dashboard_touch_point_variant)
        if error_page_touch_point_variant is not None:
            pulumi.set(__self__, "error_page_touch_point_variant", error_page_touch_point_variant)
        if favicon is not None:
            pulumi.set(__self__, "favicon", favicon)
        if favicon_url is not None:
            pulumi.set(__self__, "favicon_url", favicon_url)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if primary_color_contrast_hex is not None:
            pulumi.set(__self__, "primary_color_contrast_hex", primary_color_contrast_hex)
        if primary_color_hex is not None:
            pulumi.set(__self__, "primary_color_hex", primary_color_hex)
        if secondary_color_contrast_hex is not None:
            pulumi.set(__self__, "secondary_color_contrast_hex", secondary_color_contrast_hex)
        if secondary_color_hex is not None:
            pulumi.set(__self__, "secondary_color_hex", secondary_color_hex)
        if sign_in_page_touch_point_variant is not None:
            pulumi.set(__self__, "sign_in_page_touch_point_variant", sign_in_page_touch_point_variant)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)

    @_builtins.property
    @pulumi.getter(name="backgroundImage")
    def background_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "background_image")

    @background_image.setter
    def background_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "background_image", value)

    @_builtins.property
    @pulumi.getter(name="backgroundImageUrl")
    def background_image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Background image URL
        """
        return pulumi.get(self, "background_image_url")

    @background_image_url.setter
    def background_image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "background_image_url", value)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "brand_id", value)

    @_builtins.property
    @pulumi.getter(name="emailTemplateTouchPointVariant")
    def email_template_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        """
        return pulumi.get(self, "email_template_touch_point_variant")

    @email_template_touch_point_variant.setter
    def email_template_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_template_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="endUserDashboardTouchPointVariant")
    def end_user_dashboard_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        """
        return pulumi.get(self, "end_user_dashboard_touch_point_variant")

    @end_user_dashboard_touch_point_variant.setter
    def end_user_dashboard_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_user_dashboard_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="errorPageTouchPointVariant")
    def error_page_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "error_page_touch_point_variant")

    @error_page_touch_point_variant.setter
    def error_page_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_page_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter
    def favicon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "favicon")

    @favicon.setter
    def favicon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "favicon", value)

    @_builtins.property
    @pulumi.getter(name="faviconUrl")
    def favicon_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Favicon URL
        """
        return pulumi.get(self, "favicon_url")

    @favicon_url.setter
    def favicon_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "favicon_url", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logo URL
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @_builtins.property
    @pulumi.getter(name="primaryColorContrastHex")
    def primary_color_contrast_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary color contrast hex code
        """
        return pulumi.get(self, "primary_color_contrast_hex")

    @primary_color_contrast_hex.setter
    def primary_color_contrast_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_color_contrast_hex", value)

    @_builtins.property
    @pulumi.getter(name="primaryColorHex")
    def primary_color_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary color hex code
        """
        return pulumi.get(self, "primary_color_hex")

    @primary_color_hex.setter
    def primary_color_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_color_hex", value)

    @_builtins.property
    @pulumi.getter(name="secondaryColorContrastHex")
    def secondary_color_contrast_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary color contrast hex code
        """
        return pulumi.get(self, "secondary_color_contrast_hex")

    @secondary_color_contrast_hex.setter
    def secondary_color_contrast_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_color_contrast_hex", value)

    @_builtins.property
    @pulumi.getter(name="secondaryColorHex")
    def secondary_color_hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary color hex code
        """
        return pulumi.get(self, "secondary_color_hex")

    @secondary_color_hex.setter
    def secondary_color_hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_color_hex", value)

    @_builtins.property
    @pulumi.getter(name="signInPageTouchPointVariant")
    def sign_in_page_touch_point_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "sign_in_page_touch_point_variant")

    @sign_in_page_touch_point_variant.setter
    def sign_in_page_touch_point_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_in_page_touch_point_variant", value)

    @_builtins.property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme_id", value)


@pulumi.type_token("okta:index/theme:Theme")
class Theme(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 background_image: Optional[pulumi.Input[_builtins.str]] = None,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email_template_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 end_user_dashboard_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 error_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 favicon: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_in_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Gets, updates, a single Theme of a Brand of an Okta Organization.

        This resource allows you to get and update an Okta
        [Theme](https://developer.okta.com/docs/reference/api/brands/#theme-object).

        The Okta Management API does not have a true Create or Delete for a theme. Therefore, the theme resource must be imported
        first into the pulumi state before updates can be applied to the theme.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.get_brands()
        # resource has been imported into current state:
        # $ terraform import okta_theme.example <theme id>
        example = okta.Theme("example",
            brand_id=test.brands[0].id,
            logo="path/to/logo.png",
            favicon="path/to/favicon.png",
            background_image="path/to/background.png",
            primary_color_hex="#1662dd",
            secondary_color_hex="#ebebed",
            sign_in_page_touch_point_variant="OKTA_DEFAULT",
            end_user_dashboard_touch_point_variant="OKTA_DEFAULT",
            error_page_touch_point_variant="OKTA_DEFAULT",
            email_template_touch_point_variant="OKTA_DEFAULT")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/theme:Theme example <brand_id>/<theme_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] background_image: Path to local file
        :param pulumi.Input[_builtins.str] brand_id: Brand ID
        :param pulumi.Input[_builtins.str] email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param pulumi.Input[_builtins.str] end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param pulumi.Input[_builtins.str] error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] favicon: Path to local file
        :param pulumi.Input[_builtins.str] logo: Path to local file
        :param pulumi.Input[_builtins.str] primary_color_contrast_hex: Primary color contrast hex code
        :param pulumi.Input[_builtins.str] primary_color_hex: Primary color hex code
        :param pulumi.Input[_builtins.str] secondary_color_contrast_hex: Secondary color contrast hex code
        :param pulumi.Input[_builtins.str] secondary_color_hex: Secondary color hex code
        :param pulumi.Input[_builtins.str] sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] theme_id: Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThemeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Gets, updates, a single Theme of a Brand of an Okta Organization.

        This resource allows you to get and update an Okta
        [Theme](https://developer.okta.com/docs/reference/api/brands/#theme-object).

        The Okta Management API does not have a true Create or Delete for a theme. Therefore, the theme resource must be imported
        first into the pulumi state before updates can be applied to the theme.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.get_brands()
        # resource has been imported into current state:
        # $ terraform import okta_theme.example <theme id>
        example = okta.Theme("example",
            brand_id=test.brands[0].id,
            logo="path/to/logo.png",
            favicon="path/to/favicon.png",
            background_image="path/to/background.png",
            primary_color_hex="#1662dd",
            secondary_color_hex="#ebebed",
            sign_in_page_touch_point_variant="OKTA_DEFAULT",
            end_user_dashboard_touch_point_variant="OKTA_DEFAULT",
            error_page_touch_point_variant="OKTA_DEFAULT",
            email_template_touch_point_variant="OKTA_DEFAULT")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/theme:Theme example <brand_id>/<theme_id>
        ```

        :param str resource_name: The name of the resource.
        :param ThemeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThemeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 background_image: Optional[pulumi.Input[_builtins.str]] = None,
                 brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email_template_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 end_user_dashboard_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 error_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 favicon: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_in_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThemeArgs.__new__(ThemeArgs)

            __props__.__dict__["background_image"] = background_image
            if brand_id is None and not opts.urn:
                raise TypeError("Missing required property 'brand_id'")
            __props__.__dict__["brand_id"] = brand_id
            __props__.__dict__["email_template_touch_point_variant"] = email_template_touch_point_variant
            __props__.__dict__["end_user_dashboard_touch_point_variant"] = end_user_dashboard_touch_point_variant
            __props__.__dict__["error_page_touch_point_variant"] = error_page_touch_point_variant
            __props__.__dict__["favicon"] = favicon
            __props__.__dict__["logo"] = logo
            __props__.__dict__["primary_color_contrast_hex"] = primary_color_contrast_hex
            __props__.__dict__["primary_color_hex"] = primary_color_hex
            __props__.__dict__["secondary_color_contrast_hex"] = secondary_color_contrast_hex
            __props__.__dict__["secondary_color_hex"] = secondary_color_hex
            __props__.__dict__["sign_in_page_touch_point_variant"] = sign_in_page_touch_point_variant
            __props__.__dict__["theme_id"] = theme_id
            __props__.__dict__["background_image_url"] = None
            __props__.__dict__["favicon_url"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["logo_url"] = None
        super(Theme, __self__).__init__(
            'okta:index/theme:Theme',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            background_image: Optional[pulumi.Input[_builtins.str]] = None,
            background_image_url: Optional[pulumi.Input[_builtins.str]] = None,
            brand_id: Optional[pulumi.Input[_builtins.str]] = None,
            email_template_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
            end_user_dashboard_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
            error_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
            favicon: Optional[pulumi.Input[_builtins.str]] = None,
            favicon_url: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[_builtins.str]] = None,
            logo: Optional[pulumi.Input[_builtins.str]] = None,
            logo_url: Optional[pulumi.Input[_builtins.str]] = None,
            primary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
            primary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_color_contrast_hex: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_color_hex: Optional[pulumi.Input[_builtins.str]] = None,
            sign_in_page_touch_point_variant: Optional[pulumi.Input[_builtins.str]] = None,
            theme_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Theme':
        """
        Get an existing Theme resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] background_image: Path to local file
        :param pulumi.Input[_builtins.str] background_image_url: Background image URL
        :param pulumi.Input[_builtins.str] brand_id: Brand ID
        :param pulumi.Input[_builtins.str] email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param pulumi.Input[_builtins.str] end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param pulumi.Input[_builtins.str] error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] favicon: Path to local file
        :param pulumi.Input[_builtins.str] favicon_url: Favicon URL
        :param pulumi.Input[_builtins.str] links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param pulumi.Input[_builtins.str] logo: Path to local file
        :param pulumi.Input[_builtins.str] logo_url: Logo URL
        :param pulumi.Input[_builtins.str] primary_color_contrast_hex: Primary color contrast hex code
        :param pulumi.Input[_builtins.str] primary_color_hex: Primary color hex code
        :param pulumi.Input[_builtins.str] secondary_color_contrast_hex: Secondary color contrast hex code
        :param pulumi.Input[_builtins.str] secondary_color_hex: Secondary color hex code
        :param pulumi.Input[_builtins.str] sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param pulumi.Input[_builtins.str] theme_id: Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThemeState.__new__(_ThemeState)

        __props__.__dict__["background_image"] = background_image
        __props__.__dict__["background_image_url"] = background_image_url
        __props__.__dict__["brand_id"] = brand_id
        __props__.__dict__["email_template_touch_point_variant"] = email_template_touch_point_variant
        __props__.__dict__["end_user_dashboard_touch_point_variant"] = end_user_dashboard_touch_point_variant
        __props__.__dict__["error_page_touch_point_variant"] = error_page_touch_point_variant
        __props__.__dict__["favicon"] = favicon
        __props__.__dict__["favicon_url"] = favicon_url
        __props__.__dict__["links"] = links
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["primary_color_contrast_hex"] = primary_color_contrast_hex
        __props__.__dict__["primary_color_hex"] = primary_color_hex
        __props__.__dict__["secondary_color_contrast_hex"] = secondary_color_contrast_hex
        __props__.__dict__["secondary_color_hex"] = secondary_color_hex
        __props__.__dict__["sign_in_page_touch_point_variant"] = sign_in_page_touch_point_variant
        __props__.__dict__["theme_id"] = theme_id
        return Theme(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backgroundImage")
    def background_image(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "background_image")

    @_builtins.property
    @pulumi.getter(name="backgroundImageUrl")
    def background_image_url(self) -> pulumi.Output[_builtins.str]:
        """
        Background image URL
        """
        return pulumi.get(self, "background_image_url")

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Output[_builtins.str]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="emailTemplateTouchPointVariant")
    def email_template_touch_point_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        """
        return pulumi.get(self, "email_template_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="endUserDashboardTouchPointVariant")
    def end_user_dashboard_touch_point_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        """
        return pulumi.get(self, "end_user_dashboard_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="errorPageTouchPointVariant")
    def error_page_touch_point_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "error_page_touch_point_variant")

    @_builtins.property
    @pulumi.getter
    def favicon(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "favicon")

    @_builtins.property
    @pulumi.getter(name="faviconUrl")
    def favicon_url(self) -> pulumi.Output[_builtins.str]:
        """
        Favicon URL
        """
        return pulumi.get(self, "favicon_url")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[_builtins.str]:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to local file
        """
        return pulumi.get(self, "logo")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[_builtins.str]:
        """
        Logo URL
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter(name="primaryColorContrastHex")
    def primary_color_contrast_hex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Primary color contrast hex code
        """
        return pulumi.get(self, "primary_color_contrast_hex")

    @_builtins.property
    @pulumi.getter(name="primaryColorHex")
    def primary_color_hex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Primary color hex code
        """
        return pulumi.get(self, "primary_color_hex")

    @_builtins.property
    @pulumi.getter(name="secondaryColorContrastHex")
    def secondary_color_contrast_hex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Secondary color contrast hex code
        """
        return pulumi.get(self, "secondary_color_contrast_hex")

    @_builtins.property
    @pulumi.getter(name="secondaryColorHex")
    def secondary_color_hex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Secondary color hex code
        """
        return pulumi.get(self, "secondary_color_hex")

    @_builtins.property
    @pulumi.getter(name="signInPageTouchPointVariant")
    def sign_in_page_touch_point_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "sign_in_page_touch_point_variant")

    @_builtins.property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Theme ID - Note: Okta API for theme only reads and updates therefore the okta*theme resource needs to act as a quasi data source. Do this by setting theme*id.
        """
        return pulumi.get(self, "theme_id")

