from django.conf import settings

__all__ = (
    "DETAIL_IMAGE_KWARGS",
    "DETAIL_IMAGE_PROCESSORS",
    "PAGINATE_BY",
    "THUMBNAIL_IMAGE_KWARGS",
    "THUMBNAIL_IMAGE_PROCESSORS",
)


def S(name, default=None):
    return getattr(settings, "TOUCHTECHNOLOGY_NEWS_" + name, default) or default


DEFAULT_DETAIL_IMAGE_KWARGS = {}
DEFAULT_DETAIL_IMAGE_PROCESSORS = (
    ("pilkit.processors.resize.SmartResize", (320, 240), {}),
)

DEFAULT_THUMBNAIL_IMAGE_KWARGS = {}
DEFAULT_THUMBNAIL_IMAGE_PROCESSORS = (
    ("pilkit.processors.resize.SmartResize", (160, 120), {}),
)

DETAIL_IMAGE_KWARGS = S("DETAIL_IMAGE_KWARGS", DEFAULT_DETAIL_IMAGE_KWARGS)
DETAIL_IMAGE_PROCESSORS = S("DETAIL_IMAGE_PROCESSORS", DEFAULT_DETAIL_IMAGE_PROCESSORS)
PAGINATE_BY = S("PAGINATE_BY", 5)
THUMBNAIL_IMAGE_KWARGS = S("THUMBNAIL_IMAGE_KWARGS", DEFAULT_THUMBNAIL_IMAGE_KWARGS)
THUMBNAIL_IMAGE_PROCESSORS = S(
    "THUMBNAIL_IMAGE_PROCESSORS", DEFAULT_THUMBNAIL_IMAGE_PROCESSORS
)
