# ===========
# pysap - Python library for crafting SAP's network protocols packets
#
# Copyright (C) 2015 by Martin Gallo, Core Security
#
# The library was designed and developed by Martin Gallo from the Security
# Consulting Services team of Core Security.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# ==============

"""
pysap
=====

pysap is a Python library for communicating using SAP network protocols.

Currently the following SAP protocols are included:
    - SAP NI (Network Interface).
    - SAP Diag.
    - SAP Enqueue Server.
    - SAP Message Server.
    - SAP Router.
    - SAP RFC.

:copyright: (c) 2015 by Martin Gallo, Core Security.
:license: GNU General Public License v2 or later (GPLv2+).

"""

__title__ = 'pysap'
"""The title of the library"""

__version__ = '0.1.7'
"""The version of pysap"""

__url__ = "http://corelabs.coresecurity.com/index.php?module=Wiki&action=view&type=tool&name=pysap"
"""The URL for pysap's homepage"""

__repo__ = "https://github.com/CoreSecurity/pysap"
"""The URL for pysap's repository"""

__license__ = "GNU General Public License v2 or later (GPLv2+)"
"""The license governing the use and distribution of pysap"""
