# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.ad_hoc_execute_prompt_event import AdHocExecutePromptEvent
from ...types.ad_hoc_expand_meta import AdHocExpandMeta
from ...types.deprecated_prompt_request_input import DeprecatedPromptRequestInput
from ...types.function_definition import FunctionDefinition
from ...types.prompt_block import PromptBlock
from ...types.prompt_parameters import PromptParameters
from ...types.prompt_settings import PromptSettings
from ...types.vellum_variable import VellumVariable
from .raw_client import AsyncRawAdHocClient, RawAdHocClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AdHocClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAdHocClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawAdHocClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAdHocClient
        """
        return self._raw_client

    def adhoc_execute_prompt(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AdHocExecutePromptEvent:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdHocExecutePromptEvent


        Examples
        --------
        from vellum import (
            JinjaPromptBlock,
            PromptParameters,
            StringInput,
            Vellum,
            VellumVariable,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.ad_hoc.adhoc_execute_prompt(
            ml_model="x",
            input_values=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
            input_variables=[
                VellumVariable(
                    id="x",
                    key="key",
                    type="STRING",
                ),
                VellumVariable(
                    id="x",
                    key="key",
                    type="STRING",
                ),
            ],
            parameters=PromptParameters(),
            blocks=[
                JinjaPromptBlock(
                    template="template",
                ),
                JinjaPromptBlock(
                    template="template",
                ),
            ],
        )
        """
        _response = self._raw_client.adhoc_execute_prompt(
            ml_model=ml_model,
            input_values=input_values,
            input_variables=input_variables,
            parameters=parameters,
            blocks=blocks,
            settings=settings,
            functions=functions,
            expand_meta=expand_meta,
            request_options=request_options,
        )
        return _response.data

    def adhoc_execute_prompt_stream(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[AdHocExecutePromptEvent]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[AdHocExecutePromptEvent]


        Examples
        --------
        from vellum import (
            JinjaPromptBlock,
            PromptParameters,
            StringInput,
            Vellum,
            VellumVariable,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.ad_hoc.adhoc_execute_prompt_stream(
            ml_model="x",
            input_values=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
            input_variables=[
                VellumVariable(
                    id="x",
                    key="key",
                    type="STRING",
                ),
                VellumVariable(
                    id="x",
                    key="key",
                    type="STRING",
                ),
            ],
            parameters=PromptParameters(),
            blocks=[
                JinjaPromptBlock(
                    template="template",
                ),
                JinjaPromptBlock(
                    template="template",
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.adhoc_execute_prompt_stream(
            ml_model=ml_model,
            input_values=input_values,
            input_variables=input_variables,
            parameters=parameters,
            blocks=blocks,
            settings=settings,
            functions=functions,
            expand_meta=expand_meta,
            request_options=request_options,
        ) as r:
            yield from r.data


class AsyncAdHocClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAdHocClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAdHocClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAdHocClient
        """
        return self._raw_client

    async def adhoc_execute_prompt(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AdHocExecutePromptEvent:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdHocExecutePromptEvent


        Examples
        --------
        import asyncio

        from vellum import (
            AsyncVellum,
            JinjaPromptBlock,
            PromptParameters,
            StringInput,
            VellumVariable,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ad_hoc.adhoc_execute_prompt(
                ml_model="x",
                input_values=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
                input_variables=[
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                ],
                parameters=PromptParameters(),
                blocks=[
                    JinjaPromptBlock(
                        template="template",
                    ),
                    JinjaPromptBlock(
                        template="template",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.adhoc_execute_prompt(
            ml_model=ml_model,
            input_values=input_values,
            input_variables=input_variables,
            parameters=parameters,
            blocks=blocks,
            settings=settings,
            functions=functions,
            expand_meta=expand_meta,
            request_options=request_options,
        )
        return _response.data

    async def adhoc_execute_prompt_stream(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AdHocExecutePromptEvent]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[AdHocExecutePromptEvent]


        Examples
        --------
        import asyncio

        from vellum import (
            AsyncVellum,
            JinjaPromptBlock,
            PromptParameters,
            StringInput,
            VellumVariable,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.ad_hoc.adhoc_execute_prompt_stream(
                ml_model="x",
                input_values=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
                input_variables=[
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                ],
                parameters=PromptParameters(),
                blocks=[
                    JinjaPromptBlock(
                        template="template",
                    ),
                    JinjaPromptBlock(
                        template="template",
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.adhoc_execute_prompt_stream(
            ml_model=ml_model,
            input_values=input_values,
            input_variables=input_variables,
            parameters=parameters,
            blocks=blocks,
            settings=settings,
            functions=functions,
            expand_meta=expand_meta,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk
