# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import EarthEnvironment

if typing.TYPE_CHECKING:
    from .cyclones.client import AsyncCyclonesClient, CyclonesClient
    from .weather.client import AsyncWeatherClient, WeatherClient


class Earth:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : EarthEnvironment
        The environment to use for requests from the client. from .environment import EarthEnvironment



        Defaults to EarthEnvironment.PRODUCTION



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from silurian import Earth

    client = Earth(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: EarthEnvironment = EarthEnvironment.PRODUCTION,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._cyclones: typing.Optional[CyclonesClient] = None
        self._weather: typing.Optional[WeatherClient] = None

    @property
    def cyclones(self):
        if self._cyclones is None:
            from .cyclones.client import CyclonesClient  # noqa: E402

            self._cyclones = CyclonesClient(client_wrapper=self._client_wrapper)
        return self._cyclones

    @property
    def weather(self):
        if self._weather is None:
            from .weather.client import WeatherClient  # noqa: E402

            self._weather = WeatherClient(client_wrapper=self._client_wrapper)
        return self._weather


class AsyncEarth:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : EarthEnvironment
        The environment to use for requests from the client. from .environment import EarthEnvironment



        Defaults to EarthEnvironment.PRODUCTION



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from silurian import AsyncEarth

    client = AsyncEarth(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: EarthEnvironment = EarthEnvironment.PRODUCTION,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._cyclones: typing.Optional[AsyncCyclonesClient] = None
        self._weather: typing.Optional[AsyncWeatherClient] = None

    @property
    def cyclones(self):
        if self._cyclones is None:
            from .cyclones.client import AsyncCyclonesClient  # noqa: E402

            self._cyclones = AsyncCyclonesClient(client_wrapper=self._client_wrapper)
        return self._cyclones

    @property
    def weather(self):
        if self._weather is None:
            from .weather.client import AsyncWeatherClient  # noqa: E402

            self._weather = AsyncWeatherClient(client_wrapper=self._client_wrapper)
        return self._weather


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: EarthEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
