# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawCyclonesClient, RawCyclonesClient

if typing.TYPE_CHECKING:
    from .forecasts.client import AsyncForecastsClient, ForecastsClient


class CyclonesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCyclonesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecasts: typing.Optional[ForecastsClient] = None

    @property
    def with_raw_response(self) -> RawCyclonesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCyclonesClient
        """
        return self._raw_client

    @property
    def forecasts(self):
        if self._forecasts is None:
            from .forecasts.client import ForecastsClient  # noqa: E402

            self._forecasts = ForecastsClient(client_wrapper=self._client_wrapper)
        return self._forecasts


class AsyncCyclonesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCyclonesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecasts: typing.Optional[AsyncForecastsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawCyclonesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCyclonesClient
        """
        return self._raw_client

    @property
    def forecasts(self):
        if self._forecasts is None:
            from .forecasts.client import AsyncForecastsClient  # noqa: E402

            self._forecasts = AsyncForecastsClient(client_wrapper=self._client_wrapper)
        return self._forecasts
