# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.cyclone_forecast_response import CycloneForecastResponse
from ...types.feature_collection import FeatureCollection
from ...types.model_name import ModelName
from .raw_client import AsyncRawForecastsClient, RawForecastsClient


class ForecastsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawForecastsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawForecastsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawForecastsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        time: typing.Optional[dt.datetime] = None,
        min_storm_category: typing.Optional[int] = None,
        basin_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[CycloneForecastResponse]:
        """
        Query the available cyclone forecasts for a particular time

        Parameters
        ----------
        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        min_storm_category : typing.Optional[int]

        basin_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[CycloneForecastResponse]
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.cyclones.forecasts.list(
            time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            min_storm_category=1,
            model="OFCL",
        )
        """
        _response = self._raw_client.list(
            time=time,
            min_storm_category=min_storm_category,
            basin_ids=basin_ids,
            model=model,
            request_options=request_options,
        )
        return _response.data

    def track(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeatureCollection:
        """
        Get cyclone tracks in GeoJSON (MF-GeoJSON) format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeatureCollection
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.cyclones.forecasts.track(
            storm_id="storm_id",
            time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            max_lead_time="max_lead_time",
            model="OFCL",
        )
        """
        _response = self._raw_client.track(
            storm_id, time=time, max_lead_time=max_lead_time, model=model, request_options=request_options
        )
        return _response.data

    def cone(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        smooth_cone: typing.Optional[bool] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeatureCollection:
        """
        Get cyclone forecast cone in GeoJSON format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        smooth_cone : typing.Optional[bool]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeatureCollection
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.cyclones.forecasts.cone(
            storm_id="storm_id",
            time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            max_lead_time="max_lead_time",
            smooth_cone=True,
            model="OFCL",
        )
        """
        _response = self._raw_client.cone(
            storm_id,
            time=time,
            max_lead_time=max_lead_time,
            smooth_cone=smooth_cone,
            model=model,
            request_options=request_options,
        )
        return _response.data


class AsyncForecastsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawForecastsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawForecastsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawForecastsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        time: typing.Optional[dt.datetime] = None,
        min_storm_category: typing.Optional[int] = None,
        basin_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[CycloneForecastResponse]:
        """
        Query the available cyclone forecasts for a particular time

        Parameters
        ----------
        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        min_storm_category : typing.Optional[int]

        basin_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[CycloneForecastResponse]
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.cyclones.forecasts.list(
                time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                min_storm_category=1,
                model="OFCL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            time=time,
            min_storm_category=min_storm_category,
            basin_ids=basin_ids,
            model=model,
            request_options=request_options,
        )
        return _response.data

    async def track(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeatureCollection:
        """
        Get cyclone tracks in GeoJSON (MF-GeoJSON) format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeatureCollection
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.cyclones.forecasts.track(
                storm_id="storm_id",
                time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                max_lead_time="max_lead_time",
                model="OFCL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.track(
            storm_id, time=time, max_lead_time=max_lead_time, model=model, request_options=request_options
        )
        return _response.data

    async def cone(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        smooth_cone: typing.Optional[bool] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeatureCollection:
        """
        Get cyclone forecast cone in GeoJSON format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        smooth_cone : typing.Optional[bool]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeatureCollection
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.cyclones.forecasts.cone(
                storm_id="storm_id",
                time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                max_lead_time="max_lead_time",
                smooth_cone=True,
                model="OFCL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cone(
            storm_id,
            time=time,
            max_lead_time=max_lead_time,
            smooth_cone=smooth_cone,
            model=model,
            request_options=request_options,
        )
        return _response.data
