# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.datetime_utils import serialize_datetime
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.cyclone_forecast_response import CycloneForecastResponse
from ...types.feature_collection import FeatureCollection
from ...types.http_validation_error import HttpValidationError
from ...types.model_name import ModelName


class RawForecastsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        time: typing.Optional[dt.datetime] = None,
        min_storm_category: typing.Optional[int] = None,
        basin_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[CycloneForecastResponse]]:
        """
        Query the available cyclone forecasts for a particular time

        Parameters
        ----------
        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        min_storm_category : typing.Optional[int]

        basin_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[CycloneForecastResponse]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "cyclones/forecasts",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "min_storm_category": min_storm_category,
                "basin_ids": basin_ids,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[CycloneForecastResponse],
                    parse_obj_as(
                        type_=typing.List[CycloneForecastResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def track(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FeatureCollection]:
        """
        Get cyclone tracks in GeoJSON (MF-GeoJSON) format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FeatureCollection]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"cyclones/forecasts/{jsonable_encoder(storm_id)}/track",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "max_lead_time": max_lead_time,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FeatureCollection,
                    parse_obj_as(
                        type_=FeatureCollection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cone(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        smooth_cone: typing.Optional[bool] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FeatureCollection]:
        """
        Get cyclone forecast cone in GeoJSON format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        smooth_cone : typing.Optional[bool]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FeatureCollection]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"cyclones/forecasts/{jsonable_encoder(storm_id)}/cone",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "max_lead_time": max_lead_time,
                "smooth_cone": smooth_cone,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FeatureCollection,
                    parse_obj_as(
                        type_=FeatureCollection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawForecastsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        time: typing.Optional[dt.datetime] = None,
        min_storm_category: typing.Optional[int] = None,
        basin_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[CycloneForecastResponse]]:
        """
        Query the available cyclone forecasts for a particular time

        Parameters
        ----------
        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        min_storm_category : typing.Optional[int]

        basin_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[CycloneForecastResponse]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "cyclones/forecasts",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "min_storm_category": min_storm_category,
                "basin_ids": basin_ids,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[CycloneForecastResponse],
                    parse_obj_as(
                        type_=typing.List[CycloneForecastResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def track(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FeatureCollection]:
        """
        Get cyclone tracks in GeoJSON (MF-GeoJSON) format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FeatureCollection]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"cyclones/forecasts/{jsonable_encoder(storm_id)}/track",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "max_lead_time": max_lead_time,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FeatureCollection,
                    parse_obj_as(
                        type_=FeatureCollection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cone(
        self,
        storm_id: str,
        *,
        time: typing.Optional[dt.datetime] = None,
        max_lead_time: typing.Optional[str] = None,
        smooth_cone: typing.Optional[bool] = None,
        model: typing.Optional[ModelName] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FeatureCollection]:
        """
        Get cyclone forecast cone in GeoJSON format

        Parameters
        ----------
        storm_id : str

        time : typing.Optional[dt.datetime]
            *Default value: (current time) - Default time zone: UTC*

        max_lead_time : typing.Optional[str]
            *Value must be > P0D*

        smooth_cone : typing.Optional[bool]

        model : typing.Optional[ModelName]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FeatureCollection]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"cyclones/forecasts/{jsonable_encoder(storm_id)}/cone",
            method="GET",
            params={
                "time": serialize_datetime(time) if time is not None else None,
                "max_lead_time": max_lead_time,
                "smooth_cone": smooth_cone,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FeatureCollection,
                    parse_obj_as(
                        type_=FeatureCollection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
