# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GftusBaseUnits(UniversalBaseModel):
    elevation: str
    temperature: str
    humidity: typing.Optional[str] = None
    wind_speed: str
    wind_direction: typing.Optional[str] = None
    wind_speed_80_m: typing_extensions.Annotated[str, FieldMetadata(alias="wind_speed_80m")]
    wind_direction_80_m: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="wind_direction_80m")
    ] = None
    dewpoint_temperature: str
    feels_like_temperature: str
    pressure: str
    downward_solar_radiation: str
    precipitation_accumulation: str
    precipitation_probability: typing.Optional[str] = None
    cloud_cover: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
