# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawWeatherClient, RawWeatherClient

if typing.TYPE_CHECKING:
    from .experimental.client import AsyncExperimentalClient, ExperimentalClient
    from .forecast.client import AsyncForecastClient, ForecastClient
    from .past.client import AsyncPastClient, PastClient


class WeatherClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWeatherClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecast: typing.Optional[ForecastClient] = None
        self._experimental: typing.Optional[ExperimentalClient] = None
        self._past: typing.Optional[PastClient] = None

    @property
    def with_raw_response(self) -> RawWeatherClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWeatherClient
        """
        return self._raw_client

    @property
    def forecast(self):
        if self._forecast is None:
            from .forecast.client import ForecastClient  # noqa: E402

            self._forecast = ForecastClient(client_wrapper=self._client_wrapper)
        return self._forecast

    @property
    def experimental(self):
        if self._experimental is None:
            from .experimental.client import ExperimentalClient  # noqa: E402

            self._experimental = ExperimentalClient(client_wrapper=self._client_wrapper)
        return self._experimental

    @property
    def past(self):
        if self._past is None:
            from .past.client import PastClient  # noqa: E402

            self._past = PastClient(client_wrapper=self._client_wrapper)
        return self._past


class AsyncWeatherClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWeatherClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecast: typing.Optional[AsyncForecastClient] = None
        self._experimental: typing.Optional[AsyncExperimentalClient] = None
        self._past: typing.Optional[AsyncPastClient] = None

    @property
    def with_raw_response(self) -> AsyncRawWeatherClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWeatherClient
        """
        return self._raw_client

    @property
    def forecast(self):
        if self._forecast is None:
            from .forecast.client import AsyncForecastClient  # noqa: E402

            self._forecast = AsyncForecastClient(client_wrapper=self._client_wrapper)
        return self._forecast

    @property
    def experimental(self):
        if self._experimental is None:
            from .experimental.client import AsyncExperimentalClient  # noqa: E402

            self._experimental = AsyncExperimentalClient(client_wrapper=self._client_wrapper)
        return self._experimental

    @property
    def past(self):
        if self._past is None:
            from .past.client import AsyncPastClient  # noqa: E402

            self._past = AsyncPastClient(client_wrapper=self._client_wrapper)
        return self._past
