# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.hourly_weather_response import HourlyWeatherResponse
from ...types.timezone import Timezone
from ...types.units import Units
from .raw_client import AsyncRawExperimentalClient, RawExperimentalClient

if typing.TYPE_CHECKING:
    from .past.client import AsyncPastClient, PastClient
    from .personalized.client import AsyncPersonalizedClient, PersonalizedClient
    from .regional.client import AsyncRegionalClient, RegionalClient


class ExperimentalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExperimentalClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._regional: typing.Optional[RegionalClient] = None
        self._personalized: typing.Optional[PersonalizedClient] = None
        self._past: typing.Optional[PastClient] = None

    @property
    def with_raw_response(self) -> RawExperimentalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExperimentalClient
        """
        return self._raw_client

    def extended(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.experimental.extended(
            latitude=47.6061,
            longitude=-122.3328,
            timezone="local",
            units="metric",
        )
        """
        _response = self._raw_client.extended(
            latitude=latitude, longitude=longitude, timezone=timezone, units=units, request_options=request_options
        )
        return _response.data

    @property
    def regional(self):
        if self._regional is None:
            from .regional.client import RegionalClient  # noqa: E402

            self._regional = RegionalClient(client_wrapper=self._client_wrapper)
        return self._regional

    @property
    def personalized(self):
        if self._personalized is None:
            from .personalized.client import PersonalizedClient  # noqa: E402

            self._personalized = PersonalizedClient(client_wrapper=self._client_wrapper)
        return self._personalized

    @property
    def past(self):
        if self._past is None:
            from .past.client import PastClient  # noqa: E402

            self._past = PastClient(client_wrapper=self._client_wrapper)
        return self._past


class AsyncExperimentalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExperimentalClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._regional: typing.Optional[AsyncRegionalClient] = None
        self._personalized: typing.Optional[AsyncPersonalizedClient] = None
        self._past: typing.Optional[AsyncPastClient] = None

    @property
    def with_raw_response(self) -> AsyncRawExperimentalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExperimentalClient
        """
        return self._raw_client

    async def extended(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.experimental.extended(
                latitude=47.6061,
                longitude=-122.3328,
                timezone="local",
                units="metric",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.extended(
            latitude=latitude, longitude=longitude, timezone=timezone, units=units, request_options=request_options
        )
        return _response.data

    @property
    def regional(self):
        if self._regional is None:
            from .regional.client import AsyncRegionalClient  # noqa: E402

            self._regional = AsyncRegionalClient(client_wrapper=self._client_wrapper)
        return self._regional

    @property
    def personalized(self):
        if self._personalized is None:
            from .personalized.client import AsyncPersonalizedClient  # noqa: E402

            self._personalized = AsyncPersonalizedClient(client_wrapper=self._client_wrapper)
        return self._personalized

    @property
    def past(self):
        if self._past is None:
            from .past.client import AsyncPastClient  # noqa: E402

            self._past = AsyncPastClient(client_wrapper=self._client_wrapper)
        return self._past
