# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawPastClient, RawPastClient

if typing.TYPE_CHECKING:
    from .regional.client import AsyncRegionalClient, RegionalClient


class PastClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPastClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._regional: typing.Optional[RegionalClient] = None

    @property
    def with_raw_response(self) -> RawPastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPastClient
        """
        return self._raw_client

    @property
    def regional(self):
        if self._regional is None:
            from .regional.client import RegionalClient  # noqa: E402

            self._regional = RegionalClient(client_wrapper=self._client_wrapper)
        return self._regional


class AsyncPastClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPastClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._regional: typing.Optional[AsyncRegionalClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPastClient
        """
        return self._raw_client

    @property
    def regional(self):
        if self._regional is None:
            from .regional.client import AsyncRegionalClient  # noqa: E402

            self._regional = AsyncRegionalClient(client_wrapper=self._client_wrapper)
        return self._regional
