# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from .....types.gftus_hourly_weather_response import GftusHourlyWeatherResponse
from .....types.timezone import Timezone
from .....types.units import Units
from .raw_client import AsyncRawRegionalClient, RawRegionalClient


class RegionalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRegionalClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRegionalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRegionalClient
        """
        return self._raw_client

    def usa(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GftusHourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GftusHourlyWeatherResponse
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.experimental.past.regional.usa(
            latitude=47.6061,
            longitude=-122.3328,
            time=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            timezone="local",
            units="metric",
        )
        """
        _response = self._raw_client.usa(
            latitude=latitude,
            longitude=longitude,
            time=time,
            timezone=timezone,
            units=units,
            request_options=request_options,
        )
        return _response.data


class AsyncRegionalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRegionalClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRegionalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRegionalClient
        """
        return self._raw_client

    async def usa(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GftusHourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GftusHourlyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.experimental.past.regional.usa(
                latitude=47.6061,
                longitude=-122.3328,
                time=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
                timezone="local",
                units="metric",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.usa(
            latitude=latitude,
            longitude=longitude,
            time=time,
            timezone=timezone,
            units=units,
            request_options=request_options,
        )
        return _response.data
