# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from .raw_client import AsyncRawPersonalizedClient, RawPersonalizedClient


class PersonalizedClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPersonalizedClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPersonalizedClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPersonalizedClient
        """
        return self._raw_client

    def total_energies(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.experimental.personalized.total_energies()
        """
        _response = self._raw_client.total_energies(request_options=request_options)
        return _response.data


class AsyncPersonalizedClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPersonalizedClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPersonalizedClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPersonalizedClient
        """
        return self._raw_client

    async def total_energies(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.experimental.personalized.total_energies()


        asyncio.run(main())
        """
        _response = await self._raw_client.total_energies(request_options=request_options)
        return _response.data
