# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.daily_weather_response import DailyWeatherResponse
from ...types.hourly_weather_response import HourlyWeatherResponse
from ...types.timezone import Timezone
from ...types.units import Units
from .raw_client import AsyncRawForecastClient, RawForecastClient


class ForecastClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawForecastClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawForecastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawForecastClient
        """
        return self._raw_client

    def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[typing.Literal["local"]] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyWeatherResponse:
        """
        Get daily weather forecast for a specific location
        Only allowing local timezone aggregations for now since
        it is unclear how exactly users will understand "UTC".

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[typing.Literal["local"]]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyWeatherResponse
            Successful Response

        Examples
        --------
        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.forecast.daily(
            latitude=47.6061,
            longitude=-122.3328,
            units="metric",
        )
        """
        _response = self._raw_client.daily(
            latitude=latitude, longitude=longitude, timezone=timezone, units=units, request_options=request_options
        )
        return _response.data

    def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        include_past: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        include_past : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.forecast.hourly(
            latitude=47.6061,
            longitude=-122.3328,
            timezone="local",
            units="metric",
            include_past=True,
        )
        """
        _response = self._raw_client.hourly(
            latitude=latitude,
            longitude=longitude,
            timezone=timezone,
            units=units,
            include_past=include_past,
            request_options=request_options,
        )
        return _response.data


class AsyncForecastClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawForecastClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawForecastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawForecastClient
        """
        return self._raw_client

    async def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[typing.Literal["local"]] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyWeatherResponse:
        """
        Get daily weather forecast for a specific location
        Only allowing local timezone aggregations for now since
        it is unclear how exactly users will understand "UTC".

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[typing.Literal["local"]]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.forecast.daily(
                latitude=47.6061,
                longitude=-122.3328,
                units="metric",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.daily(
            latitude=latitude, longitude=longitude, timezone=timezone, units=units, request_options=request_options
        )
        return _response.data

    async def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        include_past: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location

        Parameters
        ----------
        latitude : float

        longitude : float

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        include_past : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.forecast.hourly(
                latitude=47.6061,
                longitude=-122.3328,
                timezone="local",
                units="metric",
                include_past=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.hourly(
            latitude=latitude,
            longitude=longitude,
            timezone=timezone,
            units=units,
            include_past=include_past,
            request_options=request_options,
        )
        return _response.data
