# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawPastClient, RawPastClient

if typing.TYPE_CHECKING:
    from .forecast.client import AsyncForecastClient, ForecastClient


class PastClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPastClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecast: typing.Optional[ForecastClient] = None

    @property
    def with_raw_response(self) -> RawPastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPastClient
        """
        return self._raw_client

    @property
    def forecast(self):
        if self._forecast is None:
            from .forecast.client import ForecastClient  # noqa: E402

            self._forecast = ForecastClient(client_wrapper=self._client_wrapper)
        return self._forecast


class AsyncPastClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPastClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._forecast: typing.Optional[AsyncForecastClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPastClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPastClient
        """
        return self._raw_client

    @property
    def forecast(self):
        if self._forecast is None:
            from .forecast.client import AsyncForecastClient  # noqa: E402

            self._forecast = AsyncForecastClient(client_wrapper=self._client_wrapper)
        return self._forecast
