# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ....core.api_error import ApiError
from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.datetime_utils import serialize_datetime
from ....core.http_response import AsyncHttpResponse, HttpResponse
from ....core.pydantic_utilities import parse_obj_as
from ....core.request_options import RequestOptions
from ....errors.unprocessable_entity_error import UnprocessableEntityError
from ....types.daily_weather_response import DailyWeatherResponse
from ....types.hourly_weather_response import HourlyWeatherResponse
from ....types.http_validation_error import HttpValidationError
from ....types.timezone import Timezone
from ....types.units import Units


class RawForecastClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DailyWeatherResponse]:
        """
        Get daily weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DailyWeatherResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "past/forecast/daily",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DailyWeatherResponse,
                    parse_obj_as(
                        type_=DailyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[HourlyWeatherResponse]:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[HourlyWeatherResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "past/forecast/hourly",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    HourlyWeatherResponse,
                    parse_obj_as(
                        type_=HourlyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawForecastClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DailyWeatherResponse]:
        """
        Get daily weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DailyWeatherResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "past/forecast/daily",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DailyWeatherResponse,
                    parse_obj_as(
                        type_=DailyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[HourlyWeatherResponse]:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[HourlyWeatherResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "past/forecast/hourly",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    HourlyWeatherResponse,
                    parse_obj_as(
                        type_=HourlyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
