# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from meshtrade.reporting.income_report.v1 import income_report_pb2 as meshtrade_dot_reporting_dot_income__report_dot_v1_dot_income__report__pb2
from meshtrade.reporting.income_report.v1 import service_pb2 as meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2


class IncomeReportServiceStub(object):
    """
    IncomeReportService manages income report generation and export.

    This service allows clients to retrieve structured income reports
    and download them as Excel files. Reports are generated for a
    specified account over a given time range and denominated in
    a selected reporting currency.

    All operations require access to financial reporting permissions.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetIncomeReport = channel.unary_unary(
                '/meshtrade.reporting.income_report.v1.IncomeReportService/GetIncomeReport',
                request_serializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetIncomeReportRequest.SerializeToString,
                response_deserializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_income__report__pb2.IncomeReport.FromString,
                _registered_method=True)
        self.GetExcelIncomeReport = channel.unary_unary(
                '/meshtrade.reporting.income_report.v1.IncomeReportService/GetExcelIncomeReport',
                request_serializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportRequest.SerializeToString,
                response_deserializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportResponse.FromString,
                _registered_method=True)


class IncomeReportServiceServicer(object):
    """
    IncomeReportService manages income report generation and export.

    This service allows clients to retrieve structured income reports
    and download them as Excel files. Reports are generated for a
    specified account over a given time range and denominated in
    a selected reporting currency.

    All operations require access to financial reporting permissions.
    """

    def GetIncomeReport(self, request, context):
        """
        Retrieves a structured income report for a specific account and time range.

        Parameters:
        - account_num: Unique account identifier
        - from: Start timestamp for the report period
        - to: End timestamp for the report period
        - reporting_currency_token: Token in which report values are denominated

        Returns:
        - GetIncomeReportResponse: Structured income report with earnings breakdown
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetExcelIncomeReport(self, request, context):
        """
        Exports an income report to Excel format for download.

        Parameters:
        - account_num: Unique account identifier
        - from: Start timestamp for the report period
        - to: End timestamp for the report period
        - reporting_currency_token: Token in which report values are denominated

        Returns:
        - GetExcelIncomeReportResponse: Base64-encoded Excel file containing the report
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_IncomeReportServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetIncomeReport': grpc.unary_unary_rpc_method_handler(
                    servicer.GetIncomeReport,
                    request_deserializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetIncomeReportRequest.FromString,
                    response_serializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_income__report__pb2.IncomeReport.SerializeToString,
            ),
            'GetExcelIncomeReport': grpc.unary_unary_rpc_method_handler(
                    servicer.GetExcelIncomeReport,
                    request_deserializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportRequest.FromString,
                    response_serializer=meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'meshtrade.reporting.income_report.v1.IncomeReportService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('meshtrade.reporting.income_report.v1.IncomeReportService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class IncomeReportService(object):
    """
    IncomeReportService manages income report generation and export.

    This service allows clients to retrieve structured income reports
    and download them as Excel files. Reports are generated for a
    specified account over a given time range and denominated in
    a selected reporting currency.

    All operations require access to financial reporting permissions.
    """

    @staticmethod
    def GetIncomeReport(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.reporting.income_report.v1.IncomeReportService/GetIncomeReport',
            meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetIncomeReportRequest.SerializeToString,
            meshtrade_dot_reporting_dot_income__report_dot_v1_dot_income__report__pb2.IncomeReport.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetExcelIncomeReport(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.reporting.income_report.v1.IncomeReportService/GetExcelIncomeReport',
            meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportRequest.SerializeToString,
            meshtrade_dot_reporting_dot_income__report_dot_v1_dot_service__pb2.GetExcelIncomeReportResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
