# Code generated by protoc-gen-meshpy. DO NOT EDIT.
# source: meshtrade/trading/limit_order/v1/service.proto

"""
Configuration options for LimitOrderService gRPC service.
This module provides a clean, extensible way to configure the service with optional
parameters while maintaining backward compatibility and readability.
"""

from datetime import timedelta


class ServiceOptions:
    """Configuration options for LimitOrderService gRPC service.

    This class provides a clean, extensible way to configure the service with optional
    parameters while maintaining backward compatibility and readability.
    """

    def __init__(
        self,
        tls: bool = True,
        url: str | None = None,
        port: int | None = None,
        api_key: str | None = None,
        group: str | None = None,
        timeout: timedelta = timedelta(seconds=30),
    ):
        """Initialize service options.

        Args:
            tls: Whether to use TLS encryption for the gRPC connection.
                When True, establishes a secure connection using TLS.
                When False, uses an insecure connection.
                Default: True (secure connection)

            url: The server hostname or IP address (e.g., "api.example.com", "localhost").
                Default: Uses DEFAULT_GRPC_URL from common module

            port: The server port number (e.g., 443 for HTTPS, 8080 for development).
                Default: Uses DEFAULT_GRPC_PORT from common module

            api_key: The API key string (without "Bearer " prefix) for authentication.
                The API key will be sent as a Bearer token in the Authorization header.
                This is the primary authentication method for service-to-service communication.

            group: The group resource name in format groups/{group_id} required for all API requests.
                The group determines the authorization context for operations
                and is sent as an "x-group" header with every request.

            timeout: The default timeout for all gRPC method calls.
                This timeout applies to individual method calls and helps prevent hanging requests.
                If a request takes longer than the specified timeout, it will be cancelled.
                Default: 30 seconds
        """
        self.tls = tls
        self.url = url
        self.port = port
        self.api_key = api_key
        self.group = group
        self.timeout = timeout


# Create alias to match expected exports
ClientOptions = ServiceOptions
